-- timeControlledslidingGate
-- @author: Daniel (Desperados93) W.
-- @date: 01.03.2011

-- Copyright () by Daniel "Desperados93" W.
   
  timeControlledslidingGate = {};
  
  local timeControlledslidingGate_mt = Class(timeControlledslidingGate);
  
  function timeControlledslidingGate.onCreate(id)
      g_currentMission:addUpdateable(timeControlledslidingGate:new(id));

  end;
  
  function timeControlledslidingGate:new(id, customMt)
  
      local instance = {};
      if customMt ~= nil then
          setmetatable(instance, customMt);
      else
          setmetatable(instance, timeControlledslidingGate_mt);
      end;
  
      instance.triggerId = id;
      addTrigger(id, "triggerCallback", instance);
  
      instance.gate = {};
      instance.rul = {};
      
      local gateIndex = getUserAttribute(id,"torIndex");
      local rulIndex = getUserAttribute(id,"rulIndex");
   
      local rul = Utils.indexToObject(id,rulIndex);
      local gate = Utils.indexToObject(id,gateIndex);
      table.insert(instance.gate, gate);
      instance.rul.rot = getChildAt(rul,0);
      instance.rul.lit = getChildAt(instance.rul.rot,0);
  
      instance.isEnabled = true;
      instance.rulOn = false;
  
      self.count = 0;
  
      self.trans = 0;
      self.maxTrans = 14;
      self.minTrans = 0;
  	  
      return instance;
  end;
  
  function timeControlledslidingGate:delete()
 
      removeTrigger(self.triggerId);
  end;
  	
  
function timeControlledslidingGate:update(dt)
 
    
	local available = false;
	
	if  (g_currentMission.environment.dayTime > 28800000 and g_currentMission.environment.dayTime < 43200000) or --8 - 12 Uhr
		(g_currentMission.environment.dayTime > 50400000 and g_currentMission.environment.dayTime < 61200000) then --14 - 17 Uhr

		available = true;
	end;
	
	if available == true then 
		local old = self.trans;
		if self.count > 0 then
			if self.trans < self.maxTrans then
				self.trans = self.trans + dt*0.002;    
			end;
		else  
			if self.trans > self.minTrans then
				self.trans = self.trans - dt*0.002;    
			end;
		end;
		
		if old ~= self.trans then
			if not self.rulOn then
				setVisibility(self.rul.lit, true);
				self.rulOn = true;
			end;
			rotate(self.rul.rot,0,(dt*0.007),0);
			for i=1, table.getn(self.gate) do
				setTranslation(self.gate[i], self.trans, 0, 0);
			end;
		else
			if self.rulOn then
				setVisibility(self.rul.lit, false);
				self.rulOn = false;
			end;
		end;
	end;
      
end;
    
  function timeControlledslidingGate:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
  
      if onEnter and self.isEnabled then
          self.count = self.count + 1;
      elseif onLeave then
         self.count = self.count - 1;
      end; 
  end;
    
g_onCreateUtil.addOnCreateFunction("timeControlledslidingGateOnCreate", timeControlledslidingGate.onCreate);