
moveAttacher2 = {};

function moveAttacher2.prerequisitesPresent(specializations)
    return true;
end;

function moveAttacher2:load(xmlFile)
	self.setxAttacher= SpecializationUtil.callSpecializationsFunction("setxAttacher");
	self.moveableAttacher2 = {};
	self.moveableAttacher2.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableAttacher2#index"));
	self.moveableAttacher2.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#maxX"), 0); 
	self.moveableAttacher2.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#minX"), 0); 
	self.moveableAttacher2.home = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableAttacher2#home"), 0); 
	
	if self.moveableAttacher2 ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher2.index);
		self.xAttacher = xAttacher
	end
	
	self.doJointOrientation = false;
	self.attacherJointCopy = nil;
	self.updateJoint = false;
end;

function moveAttacher2:delete()
end;

function moveAttacher2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveAttacher2:keyEvent(unicode, sym, modifier, isDown)

end;

function moveAttacher2:update(dt)

	if self.moveableAttacher2 ~= nil then
		local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher2.index);
		local maxX = self.moveableAttacher2.max;
		local minX = self.moveableAttacher2.min;
		local moveSpeed = 0.004;
			if InputBinding.isPressed(InputBinding.MOVEATTACHER2_LEFT) then
				if self.xAttacher < maxX then
					self.xAttacher = xAttacher + moveSpeed;				
				else
					self.xAttacher = maxX;	
				end;
				self:setxAttacher(self.xAttacher);
			elseif InputBinding.isPressed(InputBinding.MOVEATTACHER2_RIGHT) then
				if self.xAttacher > minX then
					self.xAttacher = xAttacher - moveSpeed;				
				else
					self.xAttacher = minX;
				end;
				self:setxAttacher(self.xAttacher);
			elseif InputBinding.isPressed(InputBinding.MOVEATTACHER2_HOME) then
				self.xAttacher = self.moveableAttacher2.home;
				self:setxAttacher(self.xAttacher);
			end;
	end;
end;

function moveAttacher2:setxAttacher(value, noEventSend)
  local xAttacher, yAttacher, zAttacher = getTranslation(self.moveableAttacher2.index);
  moveAttacher2Event.sendEvent(self, value, noEventSend);
  self.xAttacher = value
  
  setTranslation(self.moveableAttacher2.index, self.xAttacher, yAttacher, zAttacher);
  
end

function moveAttacher2:readStream(streamId, connection)


	self.xAttacher = streamReadFloat32(streamId);	

end;

function moveAttacher2:writeStream(streamId, connection)

	streamWriteFloat32(streamId, self.xAttacher);

end;


function moveAttacher2:onLeave()
	moveAttacher2Event.sendEvent(self, self.xAttacher);
end;

function moveAttacher2:draw()
	g_currentMission:addExtraPrintText("Kugelkopf: , = links / . = mittig / - = rechts");
end;

function moveAttacher2:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function moveAttacher2:updateTick(dt)

	if self.doJointOrientation and self.attacherVehicle ~= nil then
		for k,v in pairs(self.attacherVehicle.attachedImplements) do
			if v.object == self then
				local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
				self.attacherJointCopy = {};
				self.attacherJointCopy.joint = joint;	
				self.attacherJointCopy.minRotCopy = joint.minRot;
				self.attacherJointCopy.maxRotCopy = joint.maxRot;
				joint.minRot = joint.maxRot;
			end;
		end;
		self.doJointOrientation = false;
	end;

end;

function moveAttacher2:onAttach(attacherVehicle)
	self.doJointOrientation = true;	
end;

function moveAttacher2:onDetach()
	if self.attacherJointCopy ~= nil then
		local jointDesc = self.attacherJointCopy.joint;
		jointDesc.maxRot = self.attacherJointCopy.maxRotCopy;
		jointDesc.minRot = self.attacherJointCopy.minRotCopy;
	end;
end;

moveAttacher2Event = {};
moveAttacher2Event_mt = Class(moveAttacher2Event, Event);

InitEventClass(moveAttacher2Event, "moveAttacher2Event");

function moveAttacher2Event:emptyNew()
    local self = Event:new(moveAttacher2Event_mt);
    self.className="moveAttacher2Event";
    return self;
end;

function moveAttacher2Event:new(object, data)
    local self = moveAttacher2Event:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function moveAttacher2Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);	
	self.data = streamReadFloat32(streamId);
	self:run(connection);
end;

function moveAttacher2Event:run(connection)
    self.object:setxAttacher(self.data , true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(moveAttacher2Event:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function moveAttacher2Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.data);
end;

              
function moveAttacher2Event.sendEvent(vehicle, data, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(moveAttacher2Event:new(vehicle, data), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(moveAttacher2Event:new(vehicle, data));
		end;
	end
end;
