--
-- PowerShaft
-- Specialization for PowerShaft
--
-- @author  Manuel Leithner
-- @date  26/07/09
--

PowerShaft = {};

function PowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PowerShaft:load(xmlFile)

	self.movePTOSupportAnimation = getXMLString(xmlFile, "vehicle.movePTOSupport#animationName");
	self.movePTOSupport = true;  
	
	self.powerShaft = {};		
	self.powerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	local x,y,z = getRotation(self.powerShaft.node);
	self.powerShaft.rot = {x,y,z};
	self.powerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
	x,y,z = getTranslation(self.powerShaft.part);
	self.powerShaft.trans = {x,y,z};
	self.powerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
	local ax, ay, az = getWorldTranslation(self.powerShaft.part);
	local bx, by, bz = getWorldTranslation(self.powerShaft.fixPoint);		
	self.powerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);	

	self.attacherVehiclePowerShaft = nil;
	self.doJointSearch = false;
	
	self.setPTO = SpecializationUtil.callSpecializationsFunction("setPTO");
	self.PTOdeattached = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#deattached"));
	self.PTOattached = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#attached"));

	setVisibility(self.PTOdeattached,true);
	setVisibility(self.PTOattached,false);
	
	self.isAttached = false;
end;

function PowerShaft:delete()
end;

function PowerShaft:readStream(streamId, connection)
	self.isLoading = true;
	local PTO = streamReadBool(streamId);
	self:setPTO(PTO, true);
end;
  
function PowerShaft:writeStream(streamId, connection)
	streamWriteBool(streamId, self.PTOId);
end;

function PowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function PowerShaft:update(dt)
	
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];	
				if joint.powerShaftAttacher ~= nil then
					self.attacherVehiclePowerShaft = joint.powerShaftAttacher;
					break;	
				end;
			end;

		end;
		self.doJointSearch = false;
	end;
	if self:getIsActive() then		
			
		if self.attacherVehiclePowerShaft ~= nil then		
			local ax, ay, az = getWorldTranslation(self.powerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.powerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.powerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.powerShaft.part, 0, 0, distance-self.powerShaft.distance);		
		end;	
	end;
	
	if not self:getIsActive() and self.isAttached then
		if self.playerInRange then
			if InputBinding.hasEvent(InputBinding.ATTACH) then
				self:setPTO(not self.PTOId);
			end;
			if self.PTOId then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ATTACHPTO"), self.typeDesc), InputBinding.ATTACH);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("DETACHPTO"), self.typeDesc), InputBinding.ATTACH);
			end;
		end;
	end;
end;

function PowerShaft:updateTick(dt)	

	if g_currentMission.player ~= nil then
		local nearestDistance = 2.5;
		local x1,y1,z1 = getWorldTranslation(self.PTOdeattached);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function PowerShaft:draw()
end;

function PowerShaft:onAttach(attacherVehicle)
	self.isAttached = true;
	self.PTOId = true;
	self.doJointSearch = true;
end;

function PowerShaft:onDetach()
	self.isAttached = false;
	self.PTOId = true;
	if self.PTOId then	
		setTranslation(self.powerShaft.part, unpack(self.powerShaft.trans));
		setRotation(self.powerShaft.node, unpack(self.powerShaft.rot));
		self.attacherVehiclePowerShaft = nil;
		setVisibility(self.PTOdeattached,true);
		setVisibility(self.PTOattached,false);
	end;
	if self.PTOId then
		if self.movePTOSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.movePTOSupportAnimation, 1, nil, true);
			self.movePTOSupport = false;
		end;
	end;
end;

function PowerShaft:setPTO(PTO, noEventSend)
	if PTO ~= self.PTOId then
		 if noEventSend == nil or noEventSend == false then
			  if g_server ~= nil then
				  g_server:broadcastEvent(PTOEvent:new(self, PTO), nil, nil, self);
			  else
				  g_client:getServerConnection():sendEvent(PTOEvent:new(self, PTO));
			  end;
		  end;	
		  
		self.PTOId = PTO;
		
		if not self.PTOId then
			setVisibility(self.PTOdeattached,false);
			setVisibility(self.PTOattached,true);
			if self.movePTOSupportAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.movePTOSupportAnimation, -1, nil, true);
				self.movePTOSupport = true;
			end;
		elseif self.PTOId then
			setVisibility(self.PTOdeattached,true);
			setVisibility(self.PTOattached,false);
			if self.movePTOSupportAnimation ~= nil and self.playAnimation ~= nil then
				self:playAnimation(self.movePTOSupportAnimation, 1, nil, true);
				self.movePTOSupport = false;
			end;
		end;
	end;
end;

PTOEvent = {};
PTOEvent_mt = Class(PTOEvent, Event);

InitEventClass(PTOEvent, "PTOEvent");

function PTOEvent:emptyNew()
    local self = Event:new(PTOEvent_mt);
    self.className="PTOEvent";
    return self;
end;

function PTOEvent:new(object, PTO)
    local self = PTOEvent:emptyNew()
    self.object = object;
	self.PTO = PTO;
    return self;
end;

function PTOEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.PTO = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function PTOEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.PTO);	
end;

function PTOEvent:run(connection)
	self.object:setPTO(self.PTO, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PTOEvent:new(self.object, self.PTO), nil, connection, self.object);
	end;
end;