--
-- woz konny do zbierania skoszonych/wykopanych upraw
-- @author: Burner
--

zbieraczupraw = {};

function zbieraczupraw.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function zbieraczupraw:load(xmlFile)
	self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);
    self.parobek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.parobek#index"));
    self.parobekActive = false;
	self.collect = false;
	self.collectTypes = {};
	self.collectTypes[Fillable.FILLTYPE_UNKNOWN] = true;
	local collectTypes = getXMLString(xmlFile, "vehicle.collectTypes#fruitTypes");
	if collectTypes ~= nil then
		local types = Utils.splitString(" ", collectTypes);
		for k,v in pairs(types) do
			local collectType = Fillable.fillTypeNameToInt[v];
			if collectType ~= nil then
				self.collectTypes[collectType] = true;
			end;
		end;
	end;
	
	local numCuttingExtraAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingExtraAreas#count"), 0);
	self.cuttingExtraAreas = {}
	for i=1, numCuttingExtraAreas do
		self.cuttingExtraAreas[i] = {};
		local areanamei = string.format("vehicle.cuttingExtraAreas.cuttingExtraArea%d", i);
		self.cuttingExtraAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.cuttingExtraAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.cuttingExtraAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
end;

function zbieraczupraw:getSaveAttributesAndNodes(nodeIdent)
end;

function zbieraczupraw:delete()
end;

function zbieraczupraw:mouseEvent(posX, posY, isDown, isUp, button)
end;

function zbieraczupraw:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_v then
		self.parobekActive = not self.parobekActive;
	end;
end;

function zbieraczupraw:update(dt)
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.COLLECTFRUITS) then
            self.collect = not self.collect;
        end;
		if self.collect and self.fillLevel < self.capacity then
			local area = 0;
			for k, cuttingExtraArea in pairs(self.cuttingExtraAreas) do
				local x,y,z = getWorldTranslation(cuttingExtraArea.start);
				local x1,y1,z1 = getWorldTranslation(cuttingExtraArea.width);
				local x2,y2,z2 = getWorldTranslation(cuttingExtraArea.height);
                for collectType,v in pairs(self.collectTypes) do
                    if collectType ~= Fillable.FILLTYPE_UNKNOWN then
						if self.currentFillType == collectType or self.currentFillType == Fillable.FILLTYPE_UNKNOWN then
							local fruitType = FruitUtil.fillTypeToFruitType[collectType];
							local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
							area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
							if area > 0 then
								self.currentFruitType = fruitType;
								if self.currentFruitType == FruitUtil.FRUITTYPE_GRASS or self.currentFruitType == FruitUtil.FRUITTYPE_DRYGRASS then
									literPerSqm = g_strawLitersPerSqm*2;
								else
									literPerSqm = FruitUtil.fruitIndexToDesc[self.currentFruitType].literPerSqm; --* (1 + 0.50 * (3 - g_currentMission.missionStats.difficulty));
								end;
								local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
								local sqm = area*pixelToSqm;
								local deltaLevel = sqm*literPerSqm*self.fillScale;
								self:setFillLevel(self.fillLevel+deltaLevel, collectType);
							end;
						end;
					end;
				end;
			end;
			if self.fillLevel == 0 then
				self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
			end;
		else
			self.collect = false;
		end;
	end;
	setVisibility(self.parobek, self.parobekActive);
end;

function zbieraczupraw:draw()
	if self.attacherVehicle ~= nil then
		if self.collect then
			g_currentMission:addHelpButtonText(g_i18n:getText("collectFruitsTurnOff"), InputBinding.COLLECTFRUITS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("collectFruits"), InputBinding.COLLECTFRUITS);
		end;
		if self.parobekActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("hideWorkers"), InputBinding.TOGGLEWORKERS);	
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("showWorkers"), InputBinding.TOGGLEWORKERS);	
		end;	
	end;
end;