SetPlandekaEvent = {};
SetPlandekaEvent_mt = Class(SetPlandekaEvent, Event);

InitEventClass(SetPlandekaEvent, "SetPlandekaEvent");

function SetPlandekaEvent:emptyNew()
    local self = Event:new(SetPlandekaEvent_mt);
    self.className="SetPlandekaEvent";
    return self;
end;

function SetPlandekaEvent:new(vehicle, plandekaState)
    local self = SetPlandekaEvent:emptyNew()
    self.vehicle = vehicle;
	self.plandekaState = plandekaState;
    return self;
end;

function SetPlandekaEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.plandekaState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPlandekaEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.plandekaState);
end;

function SetPlandekaEvent:run(connection)   
	self.vehicle:togglePlandeka(self.plandekaState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPlandekaEvent:new(self.vehicle, self.plandekaState), nil, connection, self.vehicle);
    end;
end;

function SetPlandekaEvent.sendEvent(vehicle, plandekaState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPlandekaEvent:new(vehicle, plandekaState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPlandekaEvent:new(vehicle, plandekaState));
		end;
	end;
end;