Rozrzutnik_Bordowy = {};

function Rozrzutnik_Bordowy.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;
function Rozrzutnik_Bordowy:load(xmlFile)
	self.toggleAdapter = SpecializationUtil.callSpecializationsFunction("toggleAdapter");
	self.toggleGrid = SpecializationUtil.callSpecializationsFunction("toggleGrid");
	self.toggleAdditionalBoards = SpecializationUtil.callSpecializationsFunction("toggleAdditionalBoards");
	self.toggleLeftDoor = SpecializationUtil.callSpecializationsFunction("toggleLeftDoor");
	self.toggleRightDoor = SpecializationUtil.callSpecializationsFunction("toggleRightDoor");
	self.toggleBackDoor = SpecializationUtil.callSpecializationsFunction("toggleBackDoor");
	self.togglePlandeka = SpecializationUtil.callSpecializationsFunction("togglePlandeka");
	
	self.leftDoorAnimation = getXMLString(xmlFile, "vehicle.leftDoorAnimation#animationName");
	self.leftDoorActive = true;
	
	self.rightDoorAnimation = getXMLString(xmlFile, "vehicle.rightDoorAnimation#animationName");
	self.rightDoorActive = true;
	
	self.backDoorAnimation = getXMLString(xmlFile, "vehicle.backDoorAnimation#animationName");
	self.backDoorActive = true;
	self.backDoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backDoor#index"));

	self.podnogaAnimation = getXMLString(xmlFile, "vehicle.podnogaAnimation#animationName");
	self.podnogaActive = true;
	
	self.grid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grid#index"));
    self.gridActive = true;
	
	self.additionalBoards = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.additionalBoards#index"));
    self.additionalBoardsActive = false;
	
	self.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.adapter#index"));
    self.adapterActive = true;

	self.plandeka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka#index"));
    self.plandekaActive = false;

end;

function Rozrzutnik_Bordowy:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'grid="'.. tostring(self.gridActive) ..'" adapter="'.. tostring(self.adapterActive) ..'" additionalBoards="'.. tostring(self.additionalBoardsActive) ..'" plandeka="'.. tostring(self.plandekaActive) ..'"';
	return attributes, nil;
end;

function Rozrzutnik_Bordowy:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local gridActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#grid"), true);
		local adapterActive = Utils.getNoNil(getXMLBool(xmlFile, key.."#adapter"), true);
		local additionalBoards = Utils.getNoNil(getXMLBool(xmlFile, key.."#additionalBoards"), false);
		local plandeka = Utils.getNoNil(getXMLBool(xmlFile, key.."#plandekas"), false);
		self:toggleGrid(gridActive);
		self:toggleAdapter(adapterActive);
		self:toggleAdditionalBoards(additionalBoards);
		self:togglePlandeka(plandeka);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Rozrzutnik_Bordowy:delete()
end;

function Rozrzutnik_Bordowy:readStream(streamId, connection)
	self:toggleGrid(streamReadBool(streamId), true);
	self:toggleAdditionalBoards(streamReadBool(streamId), true);
	self:toggleAdapter(streamReadBool(streamId), true);
	self:toggleLeftDoor(streamReadBool(streamId), true);
	self:toggleRightDoor(streamReadBool(streamId), true);
	self:toggleBackDoor(streamReadBool(streamId), true);
	self:togglePlandeka(streamReadBool(streamId), true);
end;

function Rozrzutnik_Bordowy:writeStream(streamId, connection)
	streamWriteBool(streamId, self.gridActive);
	streamWriteBool(streamId, self.additionalBoardsActive);
	streamWriteBool(streamId, self.adapterActive);
	streamWriteBool(streamId, self.leftDoorActive);
	streamWriteBool(streamId, self.rightDoorActive);
	streamWriteBool(streamId, self.backDoorActive);
	streamWriteBool(streamId, self.plandekaActive);
end;

function Rozrzutnik_Bordowy:readUpdateStream(streamId, timestamp, connection)
end;

function Rozrzutnik_Bordowy:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Rozrzutnik_Bordowy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Rozrzutnik_Bordowy:keyEvent(unicode, sym, modifier, isDown)
end;

function Rozrzutnik_Bordowy:update(dt)
	setVisibility(self.additionalBoards, self.additionalBoardsActive);
	setVisibility(self.grid, self.gridActive);
    setVisibility(self.adapter, self.adapterActive);
	setVisibility(self.backDoor, not self.adapterActive);	
	setVisibility(self.plandeka, self.plandekaActive);
	
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLEGRID) then
            self:toggleGrid(not self.gridActive);
        end;
		if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLELEFTDOOR) then
            self:toggleLeftDoor(not self.leftDoorActive);
        end;
		if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLERIGHTDOOR) then
            self:toggleRightDoor(not self.rightDoorActive);
        end;
		if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLEBACKDOOR) then
            self:toggleBackDoor(not self.backDoorActive);
        end;
		if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLEPLANDEKA) then
            self:togglePlandeka(not self.plandekaActive);
        end;
		if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
			if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLEADDITIONALBOARDS) then
				self:toggleAdditionalBoards(not self.additionalBoardsActive);
			end;
			if InputBinding.hasEvent(InputBinding.ROZRZUTNIK_TOGGLEADAPTER) then
				self:toggleAdapter(not self.adapterActive);
			end;
		end;
    end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;
	elseif self.currentFillType == Fillable.FILLTYPE_MANURE then
		if self.adapterActive == false then
			self:toggleAdapter(true);
		end;
		if self.additionalBoardsActive == true then
			self:toggleAdditionalBoards(false);
		end;
	end;
end;

function Rozrzutnik_Bordowy:onLeave()
end;
function Rozrzutnik_Bordowy:draw()
	if self.gridActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_hideGrid"),  InputBinding.ROZRZUTNIK_TOGGLEGRID);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_showGrid"),  InputBinding.ROZRZUTNIK_TOGGLEGRID);
	end;
	if self.leftDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_openLeftDoor"),  InputBinding.ROZRZUTNIK_TOGGLELEFTDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_closeLeftDoor"),  InputBinding.ROZRZUTNIK_TOGGLELEFTDOOR);
	end;
	if self.rightDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_openRightDoor"),  InputBinding.ROZRZUTNIK_TOGGLERIGHTDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_closeRightDoor"),  InputBinding.ROZRZUTNIK_TOGGLERIGHTDOOR);
	end;
	if self.backDoorActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_openBackDoor"),  InputBinding.ROZRZUTNIK_TOGGLEBACKDOOR);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_closeRightDoor"),  InputBinding.ROZRZUTNIK_TOGGLEBACKDOOR);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.additionalBoardsActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_hideAdditionalBoards"),  InputBinding.ROZRZUTNIK_TOGGLEADDITIONALBOARDS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_showAdditionalBoards"),  InputBinding.ROZRZUTNIK_TOGGLEADDITIONALBOARDS);
		end;
		if self.adapterActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_hideAdapter"),  InputBinding.ROZRZUTNIK_TOGGLEADAPTER);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_showAdapter"),  InputBinding.ROZRZUTNIK_TOGGLEADAPTER);
		end;
		if self.plandekaActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_hidePlandeka"),  InputBinding.ROZRZUTNIK_TOGGLEPLANDEKA);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ROZRZUTNIK_showPlandeka"),  InputBinding.ROZRZUTNIK_TOGGLEPLANDEKA);
		end;
	end;
end;

function Rozrzutnik_Bordowy:toggleGrid(gridState, noEventSend)
	SetGridEvent.sendEvent(self, gridState, noEventSend);
    self.gridActive = gridState;
end;

function Rozrzutnik_Bordowy:toggleAdditionalBoards(additionalBoardsState, noEventSend)
	SetAdditionalBoardsEvent.sendEvent(self, additionalBoardsState, noEventSend);
    self.additionalBoardsActive = additionalBoardsState;
end;


function Rozrzutnik_Bordowy:toggleAdapter(adapterState, noEventSend)
	SetAdapterEvent.sendEvent(self, adapterState, noEventSend);
    self.adapterActive = adapterState;
end;

function Rozrzutnik_Bordowy:toggleLeftDoor(leftDoorState,noEventSend)
	SetLeftDoorEvent.sendEvent(self, leftDoorState, noEventSend);
	if leftDoorState then
		if self.leftDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftDoorAnimation, -1, nil, true);
			self.leftDoorActive = true;
		end;
	else
		if self.leftDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftDoorAnimation, 1, nil, true);
			self.leftDoorActive = false;
		end;
	end;
end;

function Rozrzutnik_Bordowy:toggleRightDoor(rightDoorState,noEventSend)
	SetRightDoorEvent.sendEvent(self, rightDoorState, noEventSend);
	if rightDoorState then
		if self.rightDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightDoorAnimation, -1, nil, true);
			self.rightDoorActive = true;
		end;
	else
		if self.rightDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightDoorAnimation, 1, nil, true);
			self.rightDoorActive = false;
		end;
	end;
end;

function Rozrzutnik_Bordowy:toggleBackDoor(backDoorState,noEventSend)
	SetBackDoorEvent.sendEvent(self, backDoorState, noEventSend);
	if backDoorState then
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, -1, nil, true);
			self.backDoorActive = true;
		end;
	else
		if self.backDoorAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.backDoorAnimation, 1, nil, true);
			self.backDoorActive = false;
		end;
	end;
end;
function Rozrzutnik_Bordowy:togglePlandeka(plandekaState, noEventSend)
	SetPlandekaEvent.sendEvent(self, plandekaState, noEventSend);
    self.plandekaActive = plandekaState;
end;
