-- Skrypt Animowanej klapy
-- By Fumski (03.08.2012)

GlebogryzarkaAnim = {};

function GlebogryzarkaAnim.prerequisitesPresent(specializations)
   return true;
end;

function GlebogryzarkaAnim:load(xmlFile)
	local Regulacja = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Regulacja#index"));
	if Regulacja ~= nil then
		self.Regulacja = Regulacja;
	end;
end;

function GlebogryzarkaAnim:delete()
end;

function GlebogryzarkaAnim:keyEvent(unicode, sym, modifier, isDown)
end;

function GlebogryzarkaAnim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GlebogryzarkaAnim:update(dt)
	local nearestDistance = 2.5;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Regulacja); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz); 
	if distance < nearestDistance then
		self.przyRegulacjach = true; 
	else
		self.przyRegulacjach = false; 
	end;
	if self.przyRegulacjach then
		if InputBinding.isPressed(InputBinding.Regulacjaup) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.Regulacjadown) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
	end;
	if self.przyRegulacjach then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KlapaUp"), self.typeDesc), InputBinding.Regulacjaup);
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("KlapaDown"), self.typeDesc), InputBinding.Regulacjadown);
	end;
end;

function GlebogryzarkaAnim:draw()
end;

function GlebogryzarkaAnim:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
