--
-- SamsonAttacher
-- This is the specialization for SamsonAttacher
--
-- M@D Author  Headshot XXL
-- M@D date 27.02.2010
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

SamsonAttacher = {};

function SamsonAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function SamsonAttacher:load(xmlFile)

	self.verteiler = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.verteiler#index"));
	self.backupCuttingAreas = self.cuttingAreas;
	
end;

function SamsonAttacher:delete()
end;

function SamsonAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SamsonAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function SamsonAttacher:update(dt)

	if self:getIsActive() then

		if InputBinding.hasEvent(InputBinding.SamsonAttacher_Lower) then
            self:handleLowerImplementEvent();
        end;
		
		if self.attachedImplements ~= nil then
			if table.getn(self.attachedImplements) == 1 then
				setVisibility(self.verteiler, false);
				if self.attachedImplements[1].object.sprayCuttingAreas ~= nil then
					self.cuttingAreas = self.attachedImplements[1].object.sprayCuttingAreas;
				elseif self.attachedImplements[1].object.cuttingAreas ~= nil and self.attachedImplements[1].object.sprayCuttingAreas == nil then
					self.cuttingAreas = self.attachedImplements[1].object.cuttingAreas;
				end;
			else
				self.cuttingAreas = self.backupCuttingAreas;
				setVisibility(self.verteiler, true);
			end;
		end;
		
	end;

end;

function SamsonAttacher:draw()

	if self.attachedImplements ~= nil then
		if table.getn(self.attachedImplements) == 1 then		
			if self.attacherJoints[self.attachedImplements[1].jointDescIndex].moveDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lift_OBJECT"), self.attachedImplements[1].object.typeDesc), InputBinding.SamsonAttacher_Lower);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower_OBJECT"), self.attachedImplements[1].object.typeDesc), InputBinding.SamsonAttacher_Lower);
			end;
		end;
	end;

end;
