



Window = {};

function Window.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Window:load(xmlFile)

	local rotationPartNodewindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window#index"));
    	if rotationPartNodewindow ~= nil then
        self.rotationPartwindow = {};
        self.rotationPartwindow.node = rotationPartNodewindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow#minRot"));
        self.rotationPartwindow.minRot = {};
        self.rotationPartwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window#maxRot"));
        self.rotationPartwindow.maxRot = {};
        self.rotationPartwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window#rotTime"), 2)*1000;
        self.rotationPartwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window#touchRotLimit"), 10));
    end;
	local rotationPartNodewindow1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window1#index"));
    	if rotationPartNodewindow1 ~= nil then
        self.rotationPartwindow1 = {};
        self.rotationPartwindow1.node = rotationPartNodewindow1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow1#minRot"));
        self.rotationPartwindow1.minRot = {};
        self.rotationPartwindow1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window1#maxRot"));
        self.rotationPartwindow1.maxRot = {};
        self.rotationPartwindow1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window1#rotTime"), 2)*1000;
        self.rotationPartwindow1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window1#touchRotLimit"), 10));
    end;
	local rotationPartNodewindow2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window2#index"));
    	if rotationPartNodewindow2 ~= nil then
        self.rotationPartwindow2 = {};
        self.rotationPartwindow2.node = rotationPartNodewindow2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow2#minRot"));
        self.rotationPartwindow2.minRot = {};
        self.rotationPartwindow2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window2#maxRot"));
        self.rotationPartwindow2.maxRot = {};
        self.rotationPartwindow2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window2#rotTime"), 2)*1000;
        self.rotationPartwindow2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window2#touchRotLimit"), 10));
    end;
	local rotationPartNodewindow3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window3#index"));
    	if rotationPartNodewindow3 ~= nil then
        self.rotationPartwindow3 = {};
        self.rotationPartwindow3.node = rotationPartNodewindow3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow3#minRot"));
        self.rotationPartwindow3.minRot = {};
        self.rotationPartwindow3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window3#maxRot"));
        self.rotationPartwindow3.maxRot = {};
        self.rotationPartwindow3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window3#rotTime"), 2)*1000;
        self.rotationPartwindow3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window3#touchRotLimit"), 10));
    end;
	local rotationPartNodewindow4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window4#index"));
   	 if rotationPartNodewindow4 ~= nil then
        self.rotationPartwindow4 = {};
        self.rotationPartwindow4.node = rotationPartNodewindow4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow4#minRot"));
        self.rotationPartwindow4.minRot = {};
        self.rotationPartwindow4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window4#maxRot"));
        self.rotationPartwindow4.maxRot = {};
        self.rotationPartwindow4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window4#rotTime"), 2)*1000;
        self.rotationPartwindow4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window4#touchRotLimit"), 10));
    end;
	local rotationPartNodewindow5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.window5#index"));
    	if rotationPartNodewindow5 ~= nil then
        self.rotationPartwindow5 = {};
        self.rotationPartwindow5.node = rotationPartNodewindow5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwindow5#minRot"));
        self.rotationPartwindow5.minRot = {};
        self.rotationPartwindow5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.window5#maxRot"));
        self.rotationPartwindow5.maxRot = {};
        self.rotationPartwindow5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwindow5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwindow5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwindow5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.window5#rotTime"), 2)*1000;
        self.rotationPartwindow5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.window5#touchRotLimit"), 10));
    end;
end;

function Window:keyEvent(unicode, sym, modifier, isDown)
	if isDown then
		if sym == Input.KEY_KP_7 then
			self.rotationMaxwindow = not self.rotationMaxwindow;
			
       	        end;			
                 if sym == Input.KEY then
			self.rotationMaxwindow1 = not self.rotationMaxwindow1;

		end;
		   if sym == Input.KEY_KP_9 then
			self.rotationMaxwindow2 = not self.rotationMaxwindow2;
		end;
		if sym == Input.KEY then
			self.rotationMaxwindow3 = not self.rotationMaxwindow3;
		end;
		if sym == Input.KEY then
			self.rotationMaxwindow4 = not self.rotationMaxwindow4;
		end;
		if sym == Input.KEY then
			self.rotationMaxwindow5 = not self.rotationMaxwindow5;
		end;																																										
	end;	 
end;



function Window:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Window:update(dt)

	if InputBinding.hasEvent(InputBinding.WINDOW) then
		self.rotationMaxwindow = not self.rotationMaxwindow;
	end;

    if self.isEntered then
	    if self.rotationPartwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwindow.maxRot, self.rotationPartwindow.minRot, 3, self.rotationPartwindow.rotTime, dt, not self.rotationMaxwindow);
		   setRotation(self.rotationPartwindow.node, unpack(newRot));
	     end;
	 
	    if self.rotationPartwindow1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartwindow1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwindow1.maxRot, self.rotationPartwindow1.minRot, 3, self.rotationPartwindow1.rotTime, dt, not self.rotationMaxwindow1);
		   setRotation(self.rotationPartwindow1.node, unpack(newRot));
        end;

	    if self.rotationPartwindow2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartwindow2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwindow2.maxRot, self.rotationPartwindow2.minRot, 3, self.rotationPartwindow2.rotTime, dt, not self.rotationMaxwindow2);
		   setRotation(self.rotationPartwindow2.node, unpack(newRot));
        end;
	    if self.rotationPartwindow3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartwindow3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwindow3.maxRot, self.rotationPartwindow3.minRot, 3, self.rotationPartwindow3.rotTime, dt, not self.rotationMaxwindow3);
		   setRotation(self.rotationPartwindow3.node, unpack(newRot));
        end;	
	    if self.rotationPartwindow5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartwindow5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwindow5.maxRot, self.rotationPartwindow5.minRot, 3, self.rotationPartwindow5.rotTime, dt, not self.rotationMaxwindow5);
		   setRotation(self.rotationPartwindow5.node, unpack(newRot));
        end;
	end;

end;

function Window:draw()
end;

function Window:onEnter()
end;

function Window:onLeave()
end;

function Window:delete()
end;