
Claas = {};

function Claas.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Claas:load(xmlFile)

	self.exhaustFlap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exhaustFlap#index"));
	
	self.frontholder = {};
	self.frontholder.object = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontholder#index"));
	self.frontholder.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontholder#referencePoint"));
	self.frontholder.refRotX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.frontholder#referenceRotX"), -1.09); 
	
	self.backholder = {};
	self.backholder.object = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backholder#index"));
	self.backholder.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backholder#referencePoint"));
	self.backholder.refRotX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.backholder#referenceRotX"), 1.48); 
		
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.worklights.worklight%d", i);
        self.worklights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;
	self.worklightsActive = false;
end;

function Claas:delete()
end;

function Claas:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Claas:keyEvent(unicode, sym, modifier, isDown)

end;

function Claas:update(dt)

	if self.isMotorStarted then
		local rotX, rotY, rotZ = getRotation(self.exhaustFlap);
		local rotX = Utils.degToRad((self.motor.nonClampedMotorRpm+200)/28);
		if self.motor.minRpm < 0 then
			rotX = rotX-Utils.degToRad(self.motor.minRpm/28);
		else
			rotX = rotX
		end;
		if rotX < Utils.degToRad(0) then
			rotX = Utils.degToRad(0);
		end;
		if rotX > Utils.degToRad(70) then
			rotX = Utils.degToRad(70);
		end;
		setRotation(self.exhaustFlap, rotX*-1, rotY, rotZ);
	else
		setRotation(self.exhaustFlap, 0, rotY, rotZ);
	end;
	
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.worklightsActive = not self.worklightsActive;
		end;
	
		for k, worklight in pairs(self.worklights) do
			setVisibility(worklight, self.worklightsActive);
		end;
	end;
		
	if self.frontholder.refPoint ~= nil and self.frontholder.refRotX ~= nil then
		local xRefPointFront, yRefPointFront, zRefPointFront = getRotation(self.frontholder.refPoint);
		if math.floor(xRefPointFront*100)/100 ~= self.frontholder.refRotX then
			setRotation(self.frontholder.object, Utils.degToRad(69.21102), 0, 0);
		else
			setRotation(self.frontholder.object, Utils.degToRad(-1.34007), 0, 0);
		end;
	end;
	if self.backholder.refPoint ~= nil and self.backholder.refRotX ~= nil then
		local xRefPointBack, yRefPointBack, zRefPointBack = getRotation(self.backholder.refPoint);
		if math.floor(xRefPointBack*100)/100 ~= self.backholder.refRotX then
			setRotation(self.backholder.object, Utils.degToRad(-67.97647), 0, 0);
		else
			setRotation(self.backholder.object, Utils.degToRad(2.13506), 0, 0);
		end;
	end;
end;

function Claas:onLeave()
	for k, worklight in pairs(self.worklights) do
		setVisibility(worklight, false);
	end;
	self.worklightsActive = false;
end;

function Claas:draw()

	if self.isMotorStarted then
		if self.worklightsActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("worklightOff"), InputBinding.WORKLIGHTS);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("worklightOn"), InputBinding.WORKLIGHTS);
		end;	
	end;
end;

