-- Skrypt do cignika -U-R-S-U-S- 1014	
-- Created by Ufolec
-- www.landwirtschafts-simulator.pl

ursus = {};

function ursus.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ursus:load(xmlFile)
    self.controlpath = Utils.getFilename("HUD.png", self.baseDirectory);
    self.hudrenaultPoxX = 0.0154;
    self.hudrenaultPoxY = 1-0.4715;
    self.hudrenaultWidth = 0.34;
    self.hudrenaultHeight = 0.282;
    self.hudrenaultOverlay = Overlay:new("hudrenaultcontrol", self.controlpath, self.hudrenaultPoxX, self.hudrenaultPoxY, self.hudrenaultWidth, self.hudrenaultHeight);	
	self.setLightState = SpecializationUtil.callSpecializationsFunction("setLightState");
	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");

	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;	
    local rotationPartNodekolumna = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kolumna#index"));
    if rotationPartNodekolumna ~= nil then
        self.rotationPartkolumna = {};
        self.rotationPartkolumna.node = rotationPartNodekolumna;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kolumna#minRot"));
        self.rotationPartkolumna.minRot = {};
        self.rotationPartkolumna.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkolumna.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkolumna.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kolumna#maxRot"));
        self.rotationPartkolumna.maxRot = {};
        self.rotationPartkolumna.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkolumna.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkolumna.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkolumna.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kolumna#rotTime"), 2)*1000;
        self.rotationPartkolumna.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kolumna#touchRotLimit"), 10));
    end
	local rotationPartNodepedalgazu = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.pedal_gazu#index"));
    if rotationPartNodepedalgazu ~= nil then
        self.rotationPartpedalgazu = {};
        self.rotationPartpedalgazu.node = rotationPartNodepedalgazu;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#minRot"));
        self.rotationPartpedalgazu.minRot = {};
        self.rotationPartpedalgazu.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.pedal_gazu#maxRot"));
        self.rotationPartpedalgazu.maxRot = {};
        self.rotationPartpedalgazu.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartpedalgazu.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartpedalgazu.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartpedalgazu.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#rotTime"), 2)*1000;
        self.rotationPartpedalgazu.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.pedal_gazu#touchRotLimit"), 10));
    end;
    local wychwytnikNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wychwytnik#index"));
    if wychwytnikNode ~= nil then
        self.wychwytnik = {};
        self.wychwytnik.node = wychwytnikNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wychwytnik#minRot"));
        self.wychwytnik.minRot = {};
        self.wychwytnik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wychwytnik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wychwytnik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wychwytnik#maxRot"));
        self.wychwytnik.maxRot = {};
        self.wychwytnik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wychwytnik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wychwytnik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.wychwytnik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wychwytnik#rotTime"), 2)*1000;
        self.wychwytnik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wychwytnik#touchRotLimit"), 10));
    end;
    local obrotomierzNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.obrotomierz#index"));
    if obrotomierzNode ~= nil then
        self.obrotomierz = {};
        self.obrotomierz.node = obrotomierzNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.obrotomierz#minRot"));
        self.obrotomierz.minRot = {};
        self.obrotomierz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.obrotomierz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.obrotomierz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.obrotomierz#maxRot"));
        self.obrotomierz.maxRot = {};
        self.obrotomierz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.obrotomierz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.obrotomierz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.obrotomierz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.obrotomierz#rotTime"), 2)*1000;
        self.obrotomierz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.obrotomierz#touchRotLimit"), 10));
    end;
-----------------------------------------------Tylny TUZ----------------------------------------------------------
    local ciegnaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ciegna#index"));
    if ciegnaNode ~= nil then
        self.ciegna = {};
        self.ciegna.node = ciegnaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ciegna#minRot"));
        self.ciegna.minRot = {};
        self.ciegna.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ciegna.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ciegna.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ciegna#maxRot"));
        self.ciegna.maxRot = {};
        self.ciegna.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ciegna.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ciegna.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.ciegna.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ciegna#rotTime"), 2)*1000;
        self.ciegna.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ciegna#touchRotLimit"), 10));
    end;
    local wagiNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wagi#index"));
    if wagiNode ~= nil then
        self.wagi = {};
        self.wagi.node = wagiNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wagi#minTrans"));
        self.wagi.minTrans = {};
        self.wagi.minTrans[1] = Utils.getNoNil(x, 0);
        self.wagi.minTrans[2] = Utils.getNoNil(y, 0);
        self.wagi.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wagi#maxTrans"));
        self.wagi.maxTrans = {};
        self.wagi.maxTrans[1] = Utils.getNoNil(x, 0);
        self.wagi.maxTrans[2] = Utils.getNoNil(y, 0);
        self.wagi.maxTrans[3] = Utils.getNoNil(z, 0);

        self.wagi.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wagi#transTime"), 2)*1000;
        self.wagi.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wagi#touchTransLimit"), 10);
    end;
    local lapyNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lapy#index"));
    if lapyNode ~= nil then
        self.lapy = {};
        self.lapy.node = lapyNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lapy#minRot"));
        self.lapy.minRot = {};
        self.lapy.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lapy.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lapy.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lapy#maxRot"));
        self.lapy.maxRot = {};
        self.lapy.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.lapy.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.lapy.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.lapy.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lapy#rotTime"), 2)*1000;
        self.lapy.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.lapy#touchRotLimit"), 10));
    end;
    local napinaczeNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.napinacze#index"));
    if napinaczeNode ~= nil then
        self.napinacze = {};
        self.napinacze.node = napinaczeNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.napinacze#minRot"));
        self.napinacze.minRot = {};
        self.napinacze.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.napinacze.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.napinacze.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.napinacze#maxRot"));
        self.napinacze.maxRot = {};
        self.napinacze.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.napinacze.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.napinacze.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.napinacze.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.napinacze#rotTime"), 2)*1000;
        self.napinacze.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.napinacze#touchRotLimit"), 10));
    end;
    local wajchapodNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wajchapod#index"));
    if wajchapodNode ~= nil then
        self.wajchapod = {};
        self.wajchapod.node = wajchapodNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajchapod#minRot"));
        self.wajchapod.minRot = {};
        self.wajchapod.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchapod.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchapod.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wajchapod#maxRot"));
        self.wajchapod.maxRot = {};
        self.wajchapod.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.wajchapod.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.wajchapod.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.wajchapod.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchapod#rotTime"), 2)*1000;
        self.wajchapod.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wajchapod#touchRotLimit"), 10));
    end;
-----------------------------------------------Tylny TUZ----------------------------------------------------------
      local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.zaczep#index"));
      if zaczep ~= nil then
        self.zaczep = {};
        self.zaczep.node = zaczep;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.zaczep#minTrans"));
        self.zaczep.minTrans = {};
        self.zaczep.minTrans[1] = Utils.getNoNil(x, 0);
        self.zaczep.minTrans[2] = Utils.getNoNil(y, 0);
        self.zaczep.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.zaczep#maxTrans"));
        self.zaczep.maxTrans = {};
        self.zaczep.maxTrans[1] = Utils.getNoNil(x, 0);
        self.zaczep.maxTrans[2] = Utils.getNoNil(y, 0);
        self.zaczep.maxTrans[3] = Utils.getNoNil(z, 0);

        self.zaczep.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.zaczep#transTime"), 2)*1000;
        self.zaczep.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.zaczep#touchTransLimit"), 10);
    end; 
	local rotationPartNodedach = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.dach#index"));
    if rotationPartNodedach ~= nil then
        self.rotationPartdach = {};
        self.rotationPartdach.node = rotationPartNodedach;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartdach#minRot"));
        self.rotationPartdach.minRot = {};
        self.rotationPartdach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.dach#maxRot"));
        self.rotationPartdach.maxRot = {};
        self.rotationPartdach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#rotTime"), 2)*1000;
        self.rotationPartdach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.dach#touchRotLimit"), 10));
    end;
	local rotationPartNoderot1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot1#index"));
    if rotationPartNoderot1 ~= nil then
        self.rotationPartrot1 = {};
        self.rotationPartrot1.node = rotationPartNoderot1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrot1#minRot"));
        self.rotationPartrot1.minRot = {};
        self.rotationPartrot1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrot1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrot1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rot1#maxRot"));
        self.rotationPartrot1.maxRot = {};
        self.rotationPartrot1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrot1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrot1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrot1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rot1#rotTime"), 2)*1000;
        self.rotationPartrot1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rot1#touchRotLimit"), 10));
    end;
	local rotationPartNoderot2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot2#index"));
    if rotationPartNoderot2 ~= nil then
        self.rotationPartrot2 = {};
        self.rotationPartrot2.node = rotationPartNoderot2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrot2#minRot"));
        self.rotationPartrot2.minRot = {};
        self.rotationPartrot2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrot2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrot2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rot2#maxRot"));
        self.rotationPartrot2.maxRot = {};
        self.rotationPartrot2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrot2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrot2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrot2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rot2#rotTime"), 2)*1000;
        self.rotationPartrot2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rot2#touchRotLimit"), 10));
    end;
    local rotationPartNodeporte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.porteg#index"));
    if rotationPartNodeporte ~= nil then
        self.rotationPartporte = {};
        self.rotationPartporte.node = rotationPartNodeporte;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartporteg#minRot"));
        self.rotationPartporte.minRot = {};
        self.rotationPartporte.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.porteg#maxRot"));
        self.rotationPartporte.maxRot = {};
        self.rotationPartporte.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartporte.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.porteg#rotTime"), 2)*1000;
        self.rotationPartporte.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.porteg#touchRotLimit"), 10));
    end;

  	local rotationPartNodeporte1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ported#index"));
    if rotationPartNodeporte1 ~= nil then
        self.rotationPartporte1 = {};
        self.rotationPartporte1.node = rotationPartNodeporte1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartported#minRot"));
        self.rotationPartporte1.minRot = {};
        self.rotationPartporte1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ported#maxRot"));
        self.rotationPartporte1.maxRot = {};
        self.rotationPartporte1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartporte1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ported#rotTime"), 2)*1000;
        self.rotationPartporte1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ported#touchRotLimit"), 10));
    end;
	local rotationPartNodeszyba = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.szyba#index"));
    if rotationPartNodeszyba ~= nil then
        self.rotationPartszyba = {};
        self.rotationPartszyba.node = rotationPartNodeszyba;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartszyba#minRot"));
        self.rotationPartszyba.minRot = {};
        self.rotationPartszyba.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartszyba.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartszyba.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.szyba#maxRot"));
        self.rotationPartszyba.maxRot = {};
        self.rotationPartszyba.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartszyba.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartszyba.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartszyba.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.szyba#rotTime"), 2)*1000;
        self.rotationPartszyba.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.szyba#touchRotLimit"), 10));
    end;
	local numLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lightSources#count"), 0);
    self.lightsSource = {};
    for i=1, numLights do
        local lightnamei = string.format("vehicle.lightSources.source%d", i);
        self.lightsSource[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#index"));
        setVisibility(self.lightsSource[i], false);
    end;
    local rotationPartNodewycieraczka2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.wycieraczka#index"));
    if rotationPartNodewycieraczka2 ~= nil then
        self.rotationPartwycieraczka2 = {};
        self.rotationPartwycieraczka2.node = rotationPartNodewycieraczka2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartwycieraczka#minRot"));
        self.rotationPartwycieraczka2.minRot = {};
        self.rotationPartwycieraczka2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwycieraczka2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwycieraczka2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wycieraczka#maxRot"));
        self.rotationPartwycieraczka2.maxRot = {};
        self.rotationPartwycieraczka2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartwycieraczka2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartwycieraczka2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartwycieraczka2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wycieraczka#rotTime"), 2)*1000;
        self.rotationPartwycieraczka2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.wycieraczka#touchRotLimit"), 10));
    end;

    steerHydSoundFile = Utils.getFilename("dzwieki/1014_hyd_kier.wav", self.baseDirectory);
    self.steerHydSoundId = createSample("Skoda180_steerSound");
    loadSample(self.steerHydSoundId, steerHydSoundFile, false);
    self.steerHydPlaying = false;
    HydSoundFile = Utils.getFilename("dzwieki/1014_hyd.wav", self.baseDirectory);
    self.HydSoundId = createSample("Skoda180_HydSound");
    loadSample(self.HydSoundId, HydSoundFile, false);
    self.HydPlaying = false;		
	wycieraczkaSoundFile = Utils.getFilename("dzwieki/1014_wycieraczka.wav", self.baseDirectory);
    self.wycieraczkaSoundId = createSample("wycieraczkaSound");
	loadSample(self.wycieraczkaSoundId, wycieraczkaSoundFile, false);
	self.wycieraczkaPlaying = false;
	self.currentLight = 0;
    self.zuendungKey = false;
	self.allowedZuendung = false; 
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	self.naped = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.naped#index"));
	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_lewy#index"));	
	self.kierunekActive = false;
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_prawy#index"));	
	self.kierunek2Active = false;
	turn1SoundFile = Utils.getFilename("dzwieki/1014_kierunek1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	self.test = 800;	
	turn2SoundFile = Utils.getFilename("dzwieki/1014_kierunek2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
	self.halogenyprzod = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.halogeny_przod#index"));
	self.halogenytyl = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.halogeny_tyl#index"));
	self.halogenyprzodActive = false; 
	self.halogenytylActive = false;
	self.przelacznikkierunki = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.przelacznikkierunki#index"));	
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	self.exhaustParticleSystems2 = {};
    local psName = "vehicle.exhaustParticleSystemExtra1";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems2, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems3 = {};
    local psName = "vehicle.exhaustParticleSystemExtra2";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems3, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems4 = {};
    local psName = "vehicle.exhaustParticleSystemExtra3";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems4, psName, self.rootNode, false, nil, self.baseDirectory)
	self.exhaustParticleSystems5 = {};
    local psName = "vehicle.exhaustParticleSystemExtra4";
    Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems5, psName, self.rootNode, false, nil, self.baseDirectory)
    self.bcActive = false;
end;

function ursus:delete()
    delete(self.steerHydSoundId);
    delete(self.HydSoundId);
end;

function ursus:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
    if isDown and sym == Input.KEY_f2 then 
		self.rotationMaxporte = not self.rotationMaxporte;
	end; 
    if isDown and sym == Input.KEY_f3 then 
		self.rotationMaxporte1 = not self.rotationMaxporte1;
	end; 	
	if isDown and sym == Input.KEY_f4 then 
		self.rotationMaxdach = not self.rotationMaxdach;
		self.rotationMaxrot1 = not self.rotationMaxrot1;
		self.rotationMaxrot2 = not self.rotationMaxrot2;
	end;
	if isDown and sym == Input.KEY_f5 then 
		self.rotationMaxszyba = not self.rotationMaxszyba;
	end;
	if sym == Input.KEY_8 then
		self.zaczepMax = isDown;
	end;
	if sym == Input.KEY_7 then
		self.zaczepMin = isDown;
	end;
    if isDown and sym == Input.KEY_5 then
		self.halogenyprzodActive = not self.halogenyprzodActive;
	end;
	if isDown and sym == Input.KEY_6 then
		self.halogenytylActive = not self.halogenytylActive;
	end;
	if isDown and sym == Input.KEY_9 then 
		self.wycieraczka = not self.wycieraczka;
	end;
	if isDown and sym == Input.KEY_KP_9 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.kierunek2Active = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_KP_7 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.kierunekActive = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_KP_8 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
-----------------------------------------------Tylny TUZ----------------------------------------------------------	
	if sym == Input.KEY_pageup then
		self.ciegnaMax = isDown;
		self.wagiMax = isDown;
		self.lapyMax = isDown;
		self.napinaczeMax = isDown;
		self.wajchapodMax = isDown;
	end;
	if sym == Input.KEY_pagedown then
		self.ciegnaMin = isDown;
		self.wagiMin = isDown;
		self.lapyMin = isDown;
		self.napinaczeMin = isDown;
		self.wajchapodMin = isDown;
	end;
-----------------------------------------------Tylny TUZ----------------------------------------------------------
end;

function ursus:update(dt)
-----------------------------------------------Tylny TUZ----------------------------------------------------------
	local doRotate = self.ciegnaMax or self.ciegnaMin 
	if self.ciegna ~= nil and doRotate then
        	local x, y, z = getRotation(self.ciegna.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ciegna.maxRot, self.ciegna.minRot, 3, self.ciegna.rotTime, dt, not self.ciegnaMax);
        	setRotation(self.ciegna.node, unpack(newRot));
	end;
	local doTranslate = self.wagiMax or self.wagiMin 
	if self.wagi ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.wagi.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.wagi.maxTrans, self.wagi.minTrans, 3, self.wagi.transTime, dt, not self.wagiMax); 
		setTranslation(self.wagi.node, unpack(newTrans)); 
	end;
	local doRotate = self.lapyMax or self.lapyMin 
	if self.lapy ~= nil and doRotate then
        	local x, y, z = getRotation(self.lapy.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.lapy.maxRot, self.lapy.minRot, 3, self.lapy.rotTime, dt, not self.lapyMax);
        	setRotation(self.lapy.node, unpack(newRot));
	end;
	local doRotate = self.napinaczeMax or self.napinaczeMin 
	if self.napinacze ~= nil and doRotate then
        	local x, y, z = getRotation(self.napinacze.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.napinacze.maxRot, self.napinacze.minRot, 3, self.napinacze.rotTime, dt, not self.napinaczeMax);
        	setRotation(self.napinacze.node, unpack(newRot));
	end;
	local doRotate = self.wajchapodMax or self.wajchapodMin 
	if self.wajchapod ~= nil and doRotate then
        	local x, y, z = getRotation(self.wajchapod.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wajchapod.maxRot, self.wajchapod.minRot, 3, self.wajchapod.rotTime, dt, not self.wajchapodMax);
        	setRotation(self.wajchapod.node, unpack(newRot));
	end;
-----------------------------------------------Tylny TUZ----------------------------------------------------------
	local doTranslate = self.zaczepMax or self.zaczepMin 
	if self.zaczep ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.zaczep.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.zaczep.maxTrans, self.zaczep.minTrans, 3, self.zaczep.transTime, dt, not self.zaczepMax); 
		setTranslation(self.zaczep.node, unpack(newTrans)); 
	end; 
if self.rotationPartdach ~= nil then
		local x, y, z = getRotation(self.rotationPartdach.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdach.maxRot, self.rotationPartdach.minRot, 3, self.rotationPartdach.rotTime, dt, not self.rotationMaxdach);
		setRotation(self.rotationPartdach.node, unpack(newRot));
   end;
if self.rotationPartrot1 ~= nil then
		local x, y, z = getRotation(self.rotationPartrot1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrot1.maxRot, self.rotationPartrot1.minRot, 3, self.rotationPartrot1.rotTime, dt, not self.rotationMaxrot1);
		setRotation(self.rotationPartrot1.node, unpack(newRot));
   end;	
if self.rotationPartrot2 ~= nil then
		local x, y, z = getRotation(self.rotationPartrot2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrot2.maxRot, self.rotationPartrot2.minRot, 3, self.rotationPartrot2.rotTime, dt, not self.rotationMaxrot2);
		setRotation(self.rotationPartrot2.node, unpack(newRot));
   end;	
if self.rotationPartszyba ~= nil then
		local x, y, z = getRotation(self.rotationPartszyba.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartszyba.maxRot, self.rotationPartszyba.minRot, 3, self.rotationPartszyba.rotTime, dt, not self.rotationMaxszyba);
		setRotation(self.rotationPartszyba.node, unpack(newRot));
   end;	
  if self.rotationPartporte ~= nil then
		local x, y, z = getRotation(self.rotationPartporte.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte.maxRot, self.rotationPartporte.minRot, 3, self.rotationPartporte.rotTime, dt, not self.rotationMaxporte);
		setRotation(self.rotationPartporte.node, unpack(newRot));
   end;
 if self.rotationPartporte1 ~= nil then
		local x, y, z = getRotation(self.rotationPartporte1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte1.maxRot, self.rotationPartporte1.minRot, 3, self.rotationPartporte1.rotTime, dt, not self.rotationMaxporte1);
		setRotation(self.rotationPartporte1.node, unpack(newRot));
   end;
	if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
			self:setLightState((self.currentLight + 1) % (table.getn(self.lightsSource) + 1));
        end;
	end;
   if not self.isAITractorActivated then
       
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.ZUENDUNG) then
		        self.zuendungKey = not self.zuendungKey;
			    self.allowedZuendung = true;
	        end;
	    end;
		
	    
	    if not self.allowedZuendung and  not self.zuendungKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
	    end;
	
	   
	    if not self.zuendungKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    
	    if self.allowedZuendung then
	        if  not self.zuendungKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedZuendung = false;	
		
			    
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.zuendungKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedZuendung = false;		
       	    end;
	    end;
   
    elseif not self.zuendungKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
	if self.isMotorStarted and self.naped ~= nil then
	    rotate(self.naped, 0, 0, dt*0.2);
	end;
   if self.motor.lastMotorRpm > 750 and self.isMotorStarted then

	if self.wychwytnik ~= nil then
        	local x, y, z = getRotation(self.wychwytnik.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.wychwytnik.maxRot, self.wychwytnik.minRot, 3, self.wychwytnik.rotTime, dt, self.isMotorStarted);
        	setRotation(self.wychwytnik.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra, true)
	if self.motor.lastMotorRpm > 1300 then
	Utils.setEmittingState(self.exhaustParticleSystemextra1, true)
	else
	Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
	end;						
    elseif self.isMotorStarted then
	self.wychwytnikmove = math.random(300,1300);
	if self.wychwytnik ~= nil then
        	local x, y, z = getRotation(self.wychwytnik.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {90,0,0}, {self.wychwytnikmove*0.001,0,0}, 3, 60000, dt, self.isMotorStarted);
        	setRotation(self.wychwytnik.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
        Utils.setEmittingState(self.exhaustParticleSystemextra, false)
        Utils.setEmittingState(self.exhaustParticleSystem, true)
    else
	if self.isAITractorActivated then
		if self.wychwytnik ~= nil then
        		local x, y, z = getRotation(self.wychwytnik.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.wychwytnik.maxRot, self.wychwytnik.minRot, 3, self.wychwytnik.rotTime, dt, true);
        		setRotation(self.wychwytnik.node, unpack(newRot));
    		end;
		Utils.setEmittingState(self.exhaustParticleSystemextra, true)
	else
		if self.wychwytnik ~= nil then
        		local x, y, z = getRotation(self.wychwytnik.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.wychwytnik.maxRot, self.wychwytnik.minRot, 3, self.wychwytnik.rotTime, dt, false);
        		setRotation(self.wychwytnik.node, unpack(newRot));
    		end;
	    end;
    end;
   if self.motor.lastMotorRpm > 750 and self.isMotorStarted then

	if self.obrotomierz ~= nil then
        	local x, y, z = getRotation(self.obrotomierz.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.obrotomierz.maxRot, self.obrotomierz.minRot, 3, self.obrotomierz.rotTime, dt, self.isMotorStarted);
        	setRotation(self.obrotomierz.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra, true)
	if self.motor.lastMotorRpm > 1300 then
	Utils.setEmittingState(self.exhaustParticleSystemextra1, true)
	else
	Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
	end;						
    elseif self.isMotorStarted then
	self.obrotomierzmove = math.random(300,1300);
	if self.obrotomierz ~= nil then
        	local x, y, z = getRotation(self.obrotomierz.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, {90,0,0}, {self.obrotomierzmove*0.001,0,0}, 3, 60000, dt, self.isMotorStarted);
        	setRotation(self.obrotomierz.node, unpack(newRot));
    	end;
        Utils.setEmittingState(self.exhaustParticleSystemextra1, false)
        Utils.setEmittingState(self.exhaustParticleSystemextra, false)
        Utils.setEmittingState(self.exhaustParticleSystem, true)
    else
	if self.isAITractorActivated then
		if self.obrotomierzv ~= nil then
        		local x, y, z = getRotation(self.obrotomierz.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.obrotomierz.maxRot, self.obrotomierz.minRot, 3, self.obrotomierz.rotTime, dt, true);
        		setRotation(self.obrotomierz.node, unpack(newRot));
    		end;
		Utils.setEmittingState(self.exhaustParticleSystemextra, true)
	else
		if self.obrotomierz ~= nil then
        		local x, y, z = getRotation(self.obrotomierz.node);
        		local rot = {x,y,z};
        		local newRot = Utils.getMovedLimitedValues(rot, self.obrotomierz.maxRot, self.obrotomierz.minRot, 3, self.obrotomierz.rotTime, dt, false);
        		setRotation(self.obrotomierz.node, unpack(newRot));
    		end;
	    end;
    end;
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.kierunek2Active = true;
				self.kierunekActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.kierunek2Active = false;
				self.kierunekActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.kierunek2Active = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.kierunek2Active = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.kierunek2Active = false;
		end;
	end;
	if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
			end;
		end;
	if self.flashLeft then
		if not self.flashlightsLeft then
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(-40), 0);
		    end;
		else
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(0), 0);
		    end;
		end;
	end
	if self.flashRight then
		if not self.flashlightsRight then
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(40), 0);
		    end;
        else
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(0), 0);
		    end;
		end;
	end
	if self.flash then
		if not self.flashlightsRight then
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(0), 0);
		    end;
		else
		    if self.przelacznikkierunki ~= nil then
			    setRotation(self.przelacznikkierunki, 0, Utils.degToRad(0), 0);
		    end;
		end;
	end
	if self.rotationPartpedalgazu ~= nil then
		local x, y, z = getRotation(self.rotationPartpedalgazu.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartpedalgazu.maxRot, self.rotationPartpedalgazu.minRot, 3, self.rotationPartpedalgazu.rotTime, dt, not self.rotationMaxpedalgazu);
		setRotation(self.rotationPartpedalgazu.node, unpack(newRot));
	end;
	if self.isMotorStarted then
		if Input.isKeyPressed(Input.KEY_w) or Input.isKeyPressed(Input.KEY_s) then
			self.rotationMaxpedalgazu = true;
		else
			self.rotationMaxpedalgazu = false;
		end;
	end;

    if self.wycieraczka then
		self.test = self.test - dt;
		if self.test < 0 then
				self.rotationMaxwycieraczka2 = not self.rotationMaxwycieraczka2;
				playSample(self.wycieraczkaSoundId,1,1,0);
			self.test = 1000;
		end;
	end;	
    if self.rotationPartwycieraczka2 ~= nil then
		local x, y, z = getRotation(self.rotationPartwycieraczka2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartwycieraczka2.maxRot, self.rotationPartwycieraczka2.minRot, 3, self.rotationPartwycieraczka2.rotTime, dt, not self.rotationMaxwycieraczka2);
		setRotation(self.rotationPartwycieraczka2.node, unpack(newRot));
   end;	
	if self.rotationPartkolumna ~= nil then
		local x, y, z = getRotation(self.rotationPartkolumna.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkolumna.maxRot, self.rotationPartkolumna.minRot, 3, self.rotationPartkolumna.rotTime, dt, not self.rotationMaxkolumna);
		setRotation(self.rotationPartkolumna.node, unpack(newRot));
	end;
 
	if self.isEntered then
		if self.isMotorStarted then
			self.rotationMaxkolumna = true;
		else
			self.rotationMaxkolumna = false;
		end;
	end;
 
	if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
			    end;
	    	end;
				
		else
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
	    end;
	end;
	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

    if self.isMotorStarted and (Input.isKeyPressed(Input.KEY_a) or Input.isKeyPressed(Input.KEY_d)) then
        if not self.steerHydPlaying then
            playSample(self.steerHydSoundId, 0, 1, 0);
            self.steerHydPlaying = true;
        end;
    else
        if self.steerHydPlaying then
            stopSample(self.steerHydSoundId);
            self.steerHydPlaying = false;
        end;
    end;
	
    if self.isMotorStarted and Input.isKeyPressed(Input.KEY_pageup) then
        if not self.HydPlaying then
            playSample(self.HydSoundId, 0, 1, 0);
            self.HydPlaying = true;
        end;
    else
        if self.HydPlaying then
            stopSample(self.HydSoundId);
            self.HydPlaying = false;
        end;
    end;
	
	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;	

	setVisibility(self.halogenyprzod, self.halogenyprzodActive);
	setVisibility(self.halogenytyl, self.halogenytylActive);
	setVisibility(self.kierunek, self.kierunekActive);
	setVisibility(self.kierunek2, self.kierunek2Active);
	if self.isEntered then
	if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, true);
		end;
		if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, false);
		end;
		if self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, true);
		end;
		if not self.attachedTrailer or self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, false);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, false);
		end;
		
		if not self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, false);
		end;
	end;
	if self.isMotorStarted then
	if self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, true);
		end;
		if not self.attachedTrailer or not self.motor.speedLevel == 0 or self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems2, false);
		end;
		if self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, true);
		end;
		if not self.attachedTrailer or self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems3, false);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 > 2 and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 2 or self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems4, false);
		end;
		
		if not self.attachedTrailer and self.lastSpeed*3600 > 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, true);
		end;
		if not self.attachedTrailer and self.lastSpeed*3600 < 10 then
			Utils.setEmittingState(self.exhaustParticleSystems5, false);
		end;
	end;
end;	

function ursus:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function ursus:setLightState(state)
	if self.currentLight == state  then
		state = 0;
	end;
	if state >= 0 and state <= table.getn(self.lightsSource) then
		self:setLightsVisibility(state > 0);		
		if self.currentLight > 0 then
			setVisibility(self.lightsSource[self.currentLight], false);
		end;
		if state > 0 then
			setVisibility(self.lightsSource[state], true);
		end;
		self.currentLight = state;		
	else
		print("Error: given light state not available");
	end;
end;

function ursus:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function ursus:draw()
    if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("Zndung"), InputBinding.ZUENDUNG);
	end;
if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Obroty: +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Obroty: +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
   if self.hudrenaultOverlay ~= nil then
       if self.bcActive then
        self.hudrenaultOverlay:render();
       end;  
   end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Przycisk 0: Wylacz ekran pomocy");
		else
			g_currentMission:addExtraPrintText("Przycisk 0: Wlacz ekran pomocy");
		end;
end;

function ursus:onEnter()
    self.rotationMaxporte = true;
end;

function ursus:onLeave()
    if self.deactivateLightsOnLeave then
        self:setLightState(0);
    end;
	if not self.deactivateOnLeave then
	    self.allowedZuendung = false;
	    self.zuendungKey = true; 
    else
	    self.allowedZuendung = false;
	    self.zuendungKey = false;
	end;
	Utils.setEmittingState(self.exhaustParticleSystems2, false);
	Utils.setEmittingState(self.exhaustParticleSystems3, false);
	Utils.setEmittingState(self.exhaustParticleSystems4, false);
	Utils.setEmittingState(self.exhaustParticleSystems5, false);
end;
