OverrideWeightStation = {};
addModEventListener(OverrideWeightStation);

local currentModDirectory = g_currentModDirectory;

function OverrideWeightStation:loadMap(name)
	for id,object in pairs(g_currentMission.onCreateLoadedObjects) do
		if string.find(object.className, "Waage") ~= nil then
			print("mrWeightStations: Converting weight station (object " .. id .. ") to MR");
			object.triggerCallback = OverrideWeightStation.triggerCallback;
		end;
	end;
end;

function OverrideWeightStation:deleteMap() end;
function OverrideWeightStation:update(dt) end;
function OverrideWeightStation:mouseEvent(posX, posY, isDown, isUp, button) end;
function OverrideWeightStation:keyEvent(unicode, sym, modifier, isDown) end;
function OverrideWeightStation:draw() end;

function OverrideWeightStation:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		local totalMass = 0;
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil and self.WaageVehicles[vehicle] == nil then
			local mass = 0;
			if vehicle.isRealistic then
				for i,_ in pairs(vehicle.components) do
					mass = mass + vehicle.components[i].realMassWanted;
				end;
				if vehicle.realBallastMode ~= nil then
					mass = mass + vehicle.realBallastMode.currentMass;
				end;
				if vehicle.wheelsSwitchMode ~= nil then
					mass = mass + vehicle.wheelsSwitchMode.currentMass;
				end;
			else
				for i,_ in pairs(vehicle.components) do
					mass = mass + getMass(vehicle.components[i].node);
				end;
			end;
			self.WaageVehicles[vehicle] = mass;
			totalMass = totalMass + mass;
		end;
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and self.WaageTrailer[trailer] == nil then
			local mass = 0;
			if trailer.isRealistic then
				if trailer.realFillVolume ~= nil and trailer.realFillVolume > 0 then
					local found, density, pricePerKg = RealisticUtils.getFillTypeInfosV2(fillTypeName);
					local fx = 0.001 * density;
					mass = trailer.realFillVolume * fx;
				end;
			else
				if trailer.fillLevel ~= nil and (trailer.fillLevel/1000) ~= 0 then
					mass = trailer.fillLevel/1000;
				end;
			end;
			self.WaageTrailer[trailer] = mass;
			totalMass = totalMass + mass;
		end;
		self.masse = self.masse + totalMass;
	elseif onLeave then
		local totalMass = 0;
		local vehicle = g_currentMission.nodeToVehicle[otherId];
		if vehicle ~= nil and self.WaageVehicles[vehicle] ~= nil then
			totalMass = totalMass + self.WaageVehicles[vehicle];
			self.WaageVehicles[vehicle] = nil;
		end;
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer ~= nil and self.WaageTrailer[trailer] ~= nil then
			totalMass = totalMass + self.WaageTrailer[trailer];
			self.WaageTrailer[trailer] = nil;
		end;
		self.masse = self.masse - totalMass;
	end;
end;
