--
--

LiftAxis = {};

function LiftAxis.prerequisitesPresent(specializations)
    return true;
end;

function LiftAxis:load(xmlFile)

	--<liftAxis jointIdx="1" transMin="0 0.56857 -1.34398" transMax="0 0.56857 -1.34398" rotMin="0 0 0" rotMax="10 0 0" duration="2000"/>

	self.la = {};
	
	self.la.d = getXMLFloat(xmlFile, "vehicle.liftAxis#duration");
	
	self.la.tMin = Utils.getVectorNFromString( getXMLString(xmlFile, "vehicle.liftAxis#transMin"), 3 );
	self.la.tCur = Utils.getVectorNFromString( getXMLString(xmlFile, "vehicle.liftAxis#transMin"), 3 );
	self.la.tMax = Utils.getVectorNFromString( getXMLString(xmlFile, "vehicle.liftAxis#transMax"), 3 );
	
	self.la.jntIndex = getXMLInt(xmlFile, "vehicle.liftAxis#jointIdx");
	self.la.jntNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.liftAxis#jointNode"));
	
	self.la.moveDownFL = getXMLFloat(xmlFile, "vehicle.liftAxis#moveDownAboveFillLevel");
	
	self.la.moveUp = false;
	self.la.isUp = false;
	self.la.isDown = true;
	
	self.moveAxis = SpecializationUtil.callSpecializationsFunction("moveAxis");	
	
end;

function LiftAxis:delete()
end;

function LiftAxis:readStream(streamId, connection)
	self.la.moveUp = streamReadBool(streamId);
end;

function LiftAxis:writeStream(streamId, connection)
	streamWriteBool(streamId, self.la.moveUp);
end;


function LiftAxis:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LiftAxis:keyEvent(unicode, sym, modifier, isDown)
end;

function LiftAxis:update(dt)		

	--#
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.LIFTAXIS_UPDOWN) then
				if self.attacherVehicleCopy ~= nil then
					self.attacherVehicleSteer = self.attacherVehicleCopy;
					while self.attacherVehicleSteer.attacherVehicle ~= nil do
						self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
					end;
				end;		
				if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then
					self:moveAxis(not self.la.moveUp);
				end;
			end
		end
	end;

	--#
	if self.isServer then
		if self.la.d ~= nil then
			if (self.la.isDown == false and self.la.moveUp == false) or 
				(self.la.isUp == false and self.la.moveUp == true)	then
				self.la.isUp = false;
				self.la.isDown = false;
				
				self.la.tCur = Utils.getMovedLimitedValues(self.la.tCur, self.la.tMin, self.la.tMax, 3, self.la.d, dt, self.la.moveUp);

				if self.isServer then 
					setTranslation(self.la.jntNode, self.la.tCur[1], self.la.tCur[2], self.la.tCur[3]);
					setJointFrame(self.componentJoints[self.la.jntIndex].jointIndex, 0, self.componentJoints[self.la.jntIndex].jointNode);
				end;
				
				if self.la.tCur[1] == self.la.tMin[1] and self.la.tCur[2] == self.la.tMin[2] and self.la.tCur[3] == self.la.tMin[3] then
					self.la.isDown = true;
				elseif self.la.tCur[1] == self.la.tMax[1] and self.la.tCur[2] == self.la.tMax[2] and self.la.tCur[3] == self.la.tMax[3] then
					self.la.isUp = true;
				end;
			end;
			
			if self.la.moveDownFL < self.fillLevel then
				self:moveAxis(false);
			end;
			
		end;
	end;	
	
end;


function LiftAxis:draw()
	if self.la.moveUp then
		g_currentMission:addHelpButtonText( g_i18n:getText("LIFTAXIS_DOWN"), InputBinding.LIFTAXIS_UPDOWN);
	else
		g_currentMission:addHelpButtonText( g_i18n:getText("LIFTAXIS_UP"), InputBinding.LIFTAXIS_UPDOWN);
	end;
end;


function LiftAxis:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	self.attacherVehicleSteer = self.attacherVehicleCopy;
	while self.attacherVehicleSteer.attacherVehicle ~= nil do
		self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
	end;
end;

function LiftAxis:onDetach()	
	self.attacherVehicleSteer = nil;
end;

function LiftAxis:moveAxis(value, noEventSend)
	MoveAxisEvent.sendEvent(self, value, noEventSend);
	self.la.moveUp = value;
end;



--
--
--
--
--
MoveAxisEvent = {};
MoveAxisEvent_mt = Class(MoveAxisEvent, Event);

InitEventClass(MoveAxisEvent, "MoveAxisEvent");

function MoveAxisEvent:emptyNew()
    local self = Event:new(MoveAxisEvent_mt);
    self.className="MoveAxisEvent";
    return self;
end;

function MoveAxisEvent:new(vehicle, state)
    local self = MoveAxisEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function MoveAxisEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MoveAxisEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function MoveAxisEvent:run(connection)
	self.vehicle:moveAxis(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(MoveAxisEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function MoveAxisEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MoveAxisEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MoveAxisEvent:new(vehicle, state));
		end;
	end;
end;
	