--
--

ManureDocking = {};

function ManureDocking.prerequisitesPresent(specializations)
    return true;
end;

function ManureDocking:load(xmlFile)
	self.triggerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trigger#index"));
	self.needsHose = Utils.getNoNil( getXMLBool(xmlFile, "vehicle.trigger#needsHose"), true );
	self.triggerCallback = ManureDocking.triggerCallback;
	addTrigger(self.triggerNode, "triggerCallback", self);
	
	self.fillType = Fillable.FILLTYPE_LIQUIDMANURE;
	
	self.getIsActivatable = ManureDocking.getIsActivatable;
	self.fillSprayer = ManureDocking.fillSprayer;
	
end;

function ManureDocking:delete()
	removeTrigger( self.triggerNode );
end;

function ManureDocking:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureDocking:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureDocking:update(dt)		
end;

function ManureDocking:draw()
end;


function ManureDocking:onAttach(attacherVehicle)

end;

function ManureDocking:onDetach()	

end;


function ManureDocking:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
--print("function ManureDocking:triggerCallback("..tostring(triggerId)..", "..tostring(otherActorId)..", "..tostring(onEnter)..", "..tostring(onLeave)..", "..tostring(onStay)..", "..tostring(otherShapeId)..")");
	--
	if onEnter then
		local veh = g_currentMission.nodeToVehicle[otherActorId];
		
		if veh ~= nil and self.spreader == nil and veh ~= self then --and trailer:allowFillType(self.fillType, true) then
			if SpecializationUtil.hasSpecialization(Sprayer, veh.specializations) then
				self.spreader = veh;
				--veh:addSprayerFillTrigger(self);
				veh:addSprayerFillTrigger(self);
				--print("triggeR added!");
			elseif veh.isFrontDock then
				--veh:addSprayerFillTrigger(self);
				if veh.attTra ~= nil then
					if SpecializationUtil.hasSpecialization(Sprayer, veh.attTra.specializations) then
						self.spreader = veh.attTra;
						veh.attTra:addSprayerFillTrigger(self);
						--print("triggeR added! (fd)");
					end;
				end;
			end
		end; 
	elseif onLeave then
		if self.spreader ~= nil then
			if self.spreader.lastSprayerFillTrigger ~= nil then
				self.spreader.lastSprayerFillTrigger = nil;
			end;
			--self.spreader:removeSprayerFillTrigger(self);
			self.spreader:removeSprayerFillTrigger(self);
			--print("triggeR removed!");
			self.spreader = nil;
		end;
	end
	
end

function ManureDocking:getIsActivatable(fillable)
--print("function ManureDocking:getIsActivatable("..tostring(fillable));
	local available = false;
	self.veh2 = nil;
	if self.hoseRef ~= nil then
		if self.needsHose then
			if self.hoseRef.refs[1] ~= nil then
				if self.hoseRef.refs[1].isUsed and self.hoseRef.refs[1].hose ~= 0 then
					local sId;
					
					local ref = self.hoseRef.refs[1];
					if ref.hose.ctors[1].veh == self then
						sId = 1;
					elseif ref.hose.ctors[2].veh == self then
						sId = 2;
					end;
			
					
					if sId ~= nil then			
					
						-- vehicle 
						local veh = self.hoseRef.refs[1].hose.ctors[sId].veh;
						local veh2;
						if sId == 1 then
							veh2 = self.hoseRef.refs[1].hose.ctors[2].veh;
						else
							veh2 = self.hoseRef.refs[1].hose.ctors[1].veh;
						end;
						
						if veh2 ~= nil then
							if string.find( type(veh2), 'table' ) then
								local hs = SpecializationUtil.hasSpecialization(Fillable, veh2.specializations);
								if hs then 
									available = veh2.fillLevel > 0;
								end
							else
								-- check for station
								local station;
								if sId == 1 then
									veh2 = self.hoseRef.refs[1].hose.ctors[2].station;
								else
									veh2 = self.hoseRef.refs[1].hose.ctors[1].station;
								end;		
								if veh2 ~= 0 then
									if veh2.ref1 ~= nil and veh2.ref2 ~= nil then
										if veh2.manureTriggerRef ~= nil then
											available = true;
										end;
									end;							
								end;
							end
						end;
						self.veh2 = veh2;
					end;
				end
			end
		else
			local hs = SpecializationUtil.hasSpecialization(Fillable, self.specializations);
			available = hs;
		end
	end
	if not available and not fillable:allowFillType(self.fillType, false) or (self.isSiloTrigger and g_currentMission:getSiloAmount(self.fillType) <= 0) then
		return false;
	end;
	return true;
end;

function ManureDocking:fillSprayer(obj, fillLevel)

	local nl = obj.fillLevel+fillLevel;
	local isSprayer = SpecializationUtil.hasSpecialization(Sprayer,  obj.specializations);
	if obj.sprayerFillTrigger ~= nil then
		if self.needsHose then
			local sId;
			local ref = obj.sprayerFillTrigger.hoseRef.refs[1];
			if ref.isUsed == false then
				if isSprayer then
					obj:setIsSprayerFilling(false);
				end;
				return obj.fillLevel;
			end;
			
			local sId;
			local ref = self.hoseRef.refs[1];
			if ref.hose.ctors[1].veh == self then
				sId = 1;
			elseif ref.hose.ctors[2].veh == self then
				sId = 2;
			end;			
			
			if sId ~= nil then			
				local veh;
				local veh2;
				if sId == 1 then
					veh2 = ref.hose.ctors[2].veh;
				else
					veh2 = ref.hose.ctors[1].veh;
				end;
				
				if veh2 ~= nil and veh2 ~= 0 then
					
					if string.find( type(veh2), 'table' ) then
				
						local delta = math.min(veh2.fillLevel, fillLevel);
						if delta == 0 or (obj.fillLevel == obj.capacity) then
							if isSprayer then
								--veh:setIsSprayerFilling(false);
								obj:setIsSprayerFilling(false);
							end;
						else
							veh2.setFillLevel(veh2, veh2.fillLevel-delta, self.fillType);
							nl = obj.fillLevel+delta;
							obj.setFillLevel(obj, nl, self.fillType);
						end;
					end;
				
				else				
				
					if sId == 1 then
						veh2 = self.hoseRef.refs[1].hose.ctors[2].station;
					else
						veh2 = self.hoseRef.refs[1].hose.ctors[1].station;
					end;							
					
					if veh2 ~= nil and veh2 ~= 0 then
						local delta = math.min(veh2.manureTriggerRef.fillLevel, fillLevel);
						if delta == 0 or (obj.fillLevel == obj.capacity) then
							--print("delta == 0 or (obj.fillLevel == obj.capacity)");
							if isSprayer then
								obj:setIsSprayerFilling(false);
							end;							
						else
							veh2.manureTriggerRef.setFillLevel(veh2.manureTriggerRef, veh2.manureTriggerRef.fillLevel-fillLevel, self.fillType);
							obj.setFillLevel(obj, nl, self.fillType);						
						end;
							
					end;
					
				end;

			end;

		else
			local delta = math.min(self.fillLevel, fillLevel);
			if delta == 0 or (obj.fillLevel == obj.capacity) then
				if isSprayer then
					--veh:setIsSprayerFilling(false);
					obj:setIsSprayerFilling(false);
				end;
			else
				self.setFillLevel(self, self.fillLevel-fillLevel, self.fillType);
				obj.setFillLevel(obj, nl, self.fillType);
			end;			
		end;
	else
		obj.setFillLevel(obj, nl, self.fillType);
	end
	return nl;
end;
