--
--

Kotte = {};

function Kotte.prerequisitesPresent(specializations)
    return true;
end;

function Kotte:load(xmlFile)
	self.ma = {};
	self.ma.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveAxis#index"));
	self.ma.rotMin = { math.rad( getXMLFloat(xmlFile, "vehicle.moveAxis#minRot") ) };
	self.ma.rotMax = { math.rad( getXMLFloat(xmlFile, "vehicle.moveAxis#maxRot") ) };
	self.ma.rotCur = { 0 };
	self.ma.rotCurOld = { 0 };
	self.setAxisRot = SpecializationUtil.callSpecializationsFunction("setAxisRot");
	
	self.supportAnimationBU = self.supportAnimation;
	self.supportAnimation2 = getXMLString(xmlFile, "vehicle.support2#animationName");
	
end;

function Kotte:delete()
end;

function Kotte:readStream(streamId, connection)
	self.ma.rotCur[1] = streamReadFloat32(streamId);
end;

function Kotte:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.ma.rotCur[1]);
end;

function Kotte:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kotte:keyEvent(unicode, sym, modifier, isDown)
end;

function Kotte:update(dt)		

	--#
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.isPressed(InputBinding.KOTTE_AXIS_UP) then
				while self.attacherVehicleSteer.attacherVehicle ~= nil do
					self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
				end;					
				if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then
					local nv = math.min(self.ma.rotMax[1], math.max(self.ma.rotMin[1], self.ma.rotCur[1] + dt/10000));
					self:setAxisRot(nv);
				end;
			elseif InputBinding.isPressed(InputBinding.KOTTE_AXIS_DOWN) then
				while self.attacherVehicleSteer.attacherVehicle ~= nil do
					self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
				end;					
				if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then
					local nv = math.min(self.ma.rotMax[1], math.max(self.ma.rotMin[1], self.ma.rotCur[1] - dt/10000));
					self:setAxisRot(nv);
				end;
			end
		end
	end;
	
	--#
	if (self.ma.rotCurOld[1] ~= self.ma.rotCur[1]) or self.forceUpdate == true then
		self.ma.rotCurOld[1] = self.ma.rotCur[1];
		setRotation(self.ma.node, self.ma.rotCur[1], 0, 0);
		if self.isServer then 
			setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);
		end;
		if self.ma.rotCur[1] > 0 then 
			self.supportAnimation = self.supportAnimation2;
		else
			self.supportAnimation = self.supportAnimationBU;
		end;
	end;

	--#
	if self.isServer then
		if self.ma.rotCur[1] > 0 and self.attVeh == nil then 
			if self.downForce ~= 0 then 
				local worldX,worldY,worldZ = localDirectionToWorld(self.components[1].node, 0, -self.downForce*1*dt/1000, 0);
				addForce(self.components[1].node, worldX, worldY, worldZ, 0, 0, 0, true);
			end;
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, 5, 0);
			end;
		end;		
	end;	
	
end;


function Kotte:draw()
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			g_currentMission:addHelpButtonText(g_i18n:getText("KOTTE_AXIS_UP"), InputBinding.KOTTE_AXIS_UP);
			g_currentMission:addHelpButtonText(g_i18n:getText("KOTTE_AXIS_DOWN"), InputBinding.KOTTE_AXIS_DOWN);			
		end;
	end;
end;


function Kotte:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	self.ma.rotCur[1] = Utils.getNoNil( getXMLFloat(xmlFile, key.."#axisRot"), 0 );
	setRotation(self.ma.node, self.ma.rotCur[1], 0, 0);
	self.forceUpdate = true;
	if self.isServer then 
		setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);
	end;	
	
	if self.ma.rotCur[1] > 0 then 
		self.supportAnimation = self.supportAnimation2;
	else
		self.supportAnimation = self.supportAnimationBU;
	end;	
	--self:setRealAnimationTime( self.supportAnimation, 600 );
	self:setAnimationTime( self.supportAnimation, 1 );
	
    return BaseMission.VEHICLE_LOAD_OK;	
end;

function Kotte:getSaveAttributesAndNodes(nodeIdent)
    local attributes = ' axisRot="'..tostring(self.ma.rotCur[1])..'"'; 
    return attributes, nil;
end;

function Kotte:onAttach(attacherVehicle)
	self.attVeh = attacherVehicle;
	self.attacherVehicleSteer = attacherVehicle;
	while self.attacherVehicleSteer.attacherVehicle ~= nil do
		self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
	end;	
end;

function Kotte:onDetach()	
	self.attVeh = nil;
	if self.ma.rotCur[1] > 0 then 
		if self.isServer then
			local cuttingAreasSend = {};
			for k, cuttingArea in pairs(self.cuttingAreas) do
				if self:getIsAreaActive(cuttingArea) then
					local x,y,z = getWorldTranslation(cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
					table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
				end;
			end;
			if table.getn(cuttingAreasSend) > 0 then
				LanesEvent.runLocally(cuttingAreasSend, limitToField);
				g_server:broadcastEvent(LanesEvent:new(cuttingAreasSend, limitToField));
			end;
		end;
	end;
	self.attacherVehicleSteer = nil;
end;

function Kotte:setAxisRot(value, noEventSend)
	SetAxisRotEvent.sendEvent(self, value, noEventSend);
	self.ma.rotCur = {value};
end;



--
--
--
--
--
SetAxisRotEvent = {};
SetAxisRotEvent_mt = Class(SetAxisRotEvent, Event);

InitEventClass(SetAxisRotEvent, "SetAxisRotEvent");

function SetAxisRotEvent:emptyNew()
    local self = Event:new(SetAxisRotEvent_mt);
    self.className="SetAxisRotEvent";
    return self;
end;

function SetAxisRotEvent:new(vehicle, state)
    local self = SetAxisRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetAxisRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAxisRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteFloat32(streamId, self.state);
end;

function SetAxisRotEvent:run(connection)
	self.vehicle:setAxisRot(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetAxisRotEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;

function SetAxisRotEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAxisRotEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAxisRotEvent:new(vehicle, state));
		end;
	end;
end;
	
	
--
--
--
-- Lanes Event-class
LanesEvent = {};
LanesEvent_mt = Class(LanesEvent, Event);

InitEventClass(LanesEvent, "LanesEvent");

 function LanesEvent:emptyNew()
     local self = Event:new(LanesEvent_mt);
     self.className="LanesEvent";
     return self;
end;

function LanesEvent:new(cuttingAreas, limitToField)
    local self = LanesEvent:emptyNew()
    assert(table.getn(cuttingAreas) > 0);
    self.cuttingAreas = cuttingAreas;
    self.limitToField = limitToField;
    return self;
end;

function LanesEvent:readStream(streamId, connection)
    local limitToField = streamReadBool(streamId);
    local numAreas = streamReadUIntN(streamId, 4);

    local refX = streamReadFloat32(streamId);
    local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
    for i=1,numAreas do
        local vi = i-1;
		local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;

		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, 0, 3, 2.0);
    end;
end;


function LanesEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteBool(streamId, self.limitToField);
    streamWriteUIntN(streamId, numAreas, 4);

    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
            streamWriteFloat32(streamId, d[1]);
            streamWriteFloat32(streamId, d[2]);
       else
            table.insert(values, {x=d[1], y=d[2]});
       end;
       table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
   end;
    assert(table.getn(values) == numAreas*3 - 1);
    Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
end;

function LanesEvent:run(connection)
    print("Error: Do not run LanesEvent locally");
end;

function LanesEvent.runLocally(cuttingAreas, limitToField)

    local numAreas = table.getn(cuttingAreas);

    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = cuttingAreas[i];
       if i==1 then
            refX = d[1];
           refY = d[2];
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);

    local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);

    for i=1, numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
		local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;

		local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
		setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, 0, 3, 2.0);
    end;
end;