-- Zunhammer18500pu
-- 
--
-- author: fruktor
-- www.eifok-team.de
-- 

Zunhammer18500pu = {};

local moddir = g_currentModDirectory;

function Zunhammer18500pu.prerequisitesPresent(specializations)
    return true;
end;

function Zunhammer18500pu:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;

function Zunhammer18500pu:load(xmlFile)	

	self.getIsTurnedOnAllowed = Zunhammer18500pu.getIsTurnedOnAllowed;

	--#
	self.fm = {};
	self.fm.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillmeter#index") );
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillmeter#minRot"));
	local x1, y1, z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillmeter#maxRot"));
	self.fm.minRot = {Utils.degToRad(x),Utils.degToRad(y),Utils.degToRad(z)};
	self.fm.curRot = {Utils.degToRad(x),Utils.degToRad(y),Utils.degToRad(z)};
	self.fm.maxRot = {Utils.degToRad(x1),Utils.degToRad(y1),Utils.degToRad(z1)};
	self.fm.lastFillLevel = 0;
	self.fm.fillLevelChanged = 0;
	
	--#
	for _,sprayValve in pairs(self.sprayValves) do
		for _, v in ipairs(sprayValve.particleSystems) do
			v.originalLifespan = getParticleSystemLifespan(v.geometry);
		end;
	end;


	--#
	self.toolsFillRef = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.toolsFillRef#index") );
	self.stdSprayer = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.stdSprayer#index") );
	
	--#
    self.setVehicleIncreaseRpm = SpecializationUtil.callSpecializationsFunction("setVehicleIncreaseRpm");
    self.saveMinimumRpm = 0;	
	self.rpmInc = {};
	self.rpmInc.drawbar = 0;	
	self.rpmInc.turnOn = 0;
	self.rpmInc.turnOnDefault = 1000;				
	self.rpmInc.fillarm = 0;
	self.attacherVehicleMinRpm = 0;
	
	--##
	self.fSteer = {};
	self.fSteer.lIdx = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.steering#leftIndex"));
	self.fSteer.ldIdx = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.steering#leftDirIndex"));
	self.fSteer.rIdx = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.steering#rightIndex"));
	self.fSteer.rdIdx = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.steering#rightDirIndex"));
	
	self.setForcedSteering = SpecializationUtil.callSpecializationsFunction("setForcedSteering");
	self.isForcedSteering = true;	

	--##
	self.drawbar = {};
	self.drawbar.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.drawbar#index"));
	self.drawbar.rotMin = math.rad( getXMLFloat(xmlFile, "vehicle.zunhammer18500pu.drawbar#rotMin") );
	self.drawbar.rotCur = math.rad( getXMLFloat(xmlFile, "vehicle.zunhammer18500pu.drawbar#rotMin") );
	self.drawbar.rotMax = math.rad( getXMLFloat(xmlFile, "vehicle.zunhammer18500pu.drawbar#rotMax") );
	self.drawbar.rotSpeed = 0.00005;
	self.drawbar.duration = 5000;
	self.setDrawbar = SpecializationUtil.callSpecializationsFunction("setDrawbar");

	--## 
	self.toparm = {};
	self.toparm.rotIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.toparm#rotIndex"));
	self.toparm.pushIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.toparm#pushIndex"));
	self.toparm.refIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.toparm#refIndex"));
	local rx,ry,rz = getWorldTranslation(self.toparm.refIndex);
	local  x, y, z = getWorldTranslation(self.toparm.rotIndex);
	self.toparm.refLength = Utils.vector3Length( rx-x, ry-y, rz-z );
	local px,py,pz = getWorldTranslation(self.toparm.pushIndex);
	self.toparm.pushOffset = Utils.vector3Length( px-x, py-y, pz-z );
	local r,y,z = getRotation(self.toparm.rotIndex);
	self.toparm.origRot = r;

	
	--# !!! This is to be executed last (bone-mesh changes indices, when linked! - few lines later) !!!
	self.setFillarm = SpecializationUtil.callSpecializationsFunction("setFillarm");
	
	self.fillarm = {};
	self.fillarm.jnt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillarm.joint#index"));
	self.fillarm.msh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillarm.mesh#index"));
	
	link( getRootNode(), self.fillarm.msh );
	setTranslation( self.fillarm.msh, 0, 0, 0 );
	setRotation( self.fillarm.msh, 0, 0, 0 );	
	
	self.fillarm.anim = {};
	self.fillarm.anim.idx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillarm.anim#index"));
	self.fillarm.anim.charset = getAnimCharacterSet(self.fillarm.anim.idx);
	self.fillarm.anim.clipIdx = getAnimClipIndex(self.fillarm.anim.charset, getXMLString(xmlFile, "vehicle.zunhammer18500pu.fillarm.anim#clip"));	
	assignAnimTrackClip(self.fillarm.anim.charset, 0, self.fillarm.anim.clipIdx);
	setAnimTrackLoopState(self.fillarm.anim.charset, 0, false);
	setAnimTrackTime(self.fillarm.anim.charset, 0, 0.0, true);
	self.fillarm.anim.duration = getAnimClipDuration(self.fillarm.anim.charset, self.fillarm.anim.clipIdx);	
	self.fillarm.anim.curTime = 0;
	self.fillarm.anim.speed = 0.7;
	self.fillarm.bOpen = false;
	self.fillarm.bIsOpen = false;
	self.fillarm.bIsClosed = true;	
	
	self.allowFillFromAir = true;	 -- ?

	--#
	self.vogelTA = {};
	self.vogelTA.leftNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.vogelTopArm#leftIndex"));
	self.vogelTA.rightNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.vogelTopArm#rightIndex"));
	self.vogelTA.heNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zunhammer18500pu.vogelTopArm#hoseEndIndex"));

	--# 
	self.printTable = Zunhammer18500pu.printTable;

	
	self.draw = Utils.overwrittenFunction(self.draw, Zunhammer18500pu.draw);
	self.lastFillLevel_draw = 0;
	
	--##
	--print("---------------------self.hoseRef---------------------");
	--self:printTable( self.hoseRef, "->", 0, 8 );
	
	--print("---------------------Fillable---------------------");
	--self:printTable( Fillable, "->", 0, 8 );
	
	--# cylinder sound
	self.cylinderedHydraulicSoundEnabled2 = false;
	
	--self.delete = Utils.overwrittenFunction(self.delete, Zunhammer18500pu.delete);
	
	--# inc.rpm by MR
	self.realWorkingPowerConsumption_extra = 0;
	
end;

function Zunhammer18500pu:delete()
	if self.fillarm.msh ~= nil then
		delete(self.fillarm.msh);
	end;
end;


function Zunhammer18500pu:readStream(streamId, connection)
--print("function Zunhammer18500pu:readStream(streamId, connection)");
	self.fillarm.anim.curTime = streamReadFloat32(streamId);
	self.drawbar.rotCur = streamReadFloat32(streamId);
end;

function Zunhammer18500pu:writeStream(streamId, connection)	
--print("function Zunhammer18500pu:writeStream(streamId, connection)	");
	streamWriteFloat32(streamId, self.fillarm.anim.curTime);
	streamWriteFloat32(streamId, self.drawbar.rotCur);
end;

function Zunhammer18500pu:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Zunhammer18500pu:keyEvent(unicode, sym, modifier, isDown)

end;

function Zunhammer18500pu:update(dt)

	--#
	local playCylSound = false;

	
	--###
	if self.attacherVehicle ~= nil and self.attacherVehicle.isMotorStarted and self:getIsActive() and self.fm.fillLevelChanged <= 0 then
		
		--# fillarm
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if InputBinding.isPressed(InputBinding.ZH18500PU_ARM_UP) then
				local v = math.min( self.fillarm.anim.curTime + dt*self.fillarm.anim.speed, self.fillarm.anim.duration );
				self:setFillarm(v);
			elseif InputBinding.isPressed(InputBinding.ZH18500PU_ARM_DOWN) then
				local v = math.max( self.fillarm.anim.curTime - dt*self.fillarm.anim.speed, 0 );
				self:setFillarm(v);
			end			
		end

		if self.fillarm.anim.curTimeOld ~= self.fillarm.anim.curTime then
			self.fillarm.anim.curTimeOld = self.fillarm.anim.curTime;
			enableAnimTrack(self.fillarm.anim.charset, 0);
			setAnimTrackTime(self.fillarm.anim.charset, 0, self.fillarm.anim.curTime, true);
			disableAnimTrack(self.fillarm.anim.charset, 0);
			if self.isClient then
				playCylSound = true;
			end;
			if self.fillarm.anim.curTime == self.fillarm.anim.duration then
				self.fillarm.bIsOpen = true;
			else
				self.fillarm.bIsOpen = false;
			end;			
			if self.isServer then
				setJointFrame(self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode);
			end
		end			
	end

	--###
	if self.isClient then 
	
		local steeringAxleAngle = 0;
		if self.attacherVehicle ~= nil and self.isForcedSteering == true then
			local x,y,z = worldDirectionToLocal(self.steeringAxleNode, localDirectionToWorld(self.attacherVehicle.steeringAxleNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x > 0 then
				angle = -angle;
			end;
			steeringAxleAngle = -angle*0.6;
		end;
		self.steeringAxleAngle = steeringAxleAngle;	
		
		--###
		if self:getIsActive() and self.isForcedSteering == true and self.attacherVehicle ~= nil then
			local x,y,z = worldDirectionToLocal(self.rootNode, localDirectionToWorld(self.attacherVehicle.rootNode, 0, 0, 1));
			local dot = z;
			dot = dot / Utils.vector2Length(x,z);
			local angle = math.acos(dot);
			if x < 0 then
				angle = -angle;
			end;
			setRotation(self.fSteer.lIdx, 0, angle, 0);
			setRotation(self.fSteer.rIdx, 0, angle, 0);

			if self.leftFixPoint ~= nil then
				local ax, ay, az = getWorldTranslation(self.fSteer.ldIdx);
				local bx, by, bz = getWorldTranslation(self.leftFixPoint);
				local x, y, z = worldDirectionToLocal(getParent(self.fSteer.ldIdx), bx-ax, by-ay, bz-az);
				setDirection(self.fSteer.ldIdx, x, y, z, 0, 1, 0);
			end;

			if self.rightFixPoint ~= nil then
				local ax, ay, az = getWorldTranslation(self.fSteer.rdIdx);
				local bx, by, bz = getWorldTranslation(self.rightFixPoint);
				local x, y, z = worldDirectionToLocal(getParent(self.fSteer.rdIdx), bx-ax, by-ay, bz-az);
				setDirection(self.fSteer.rdIdx, x, y, z, 0, 1, 0);
			end;

		end;	
	end;
	
	--###
	if self.attacherVehicle ~= nil and self.attacherVehicle.isMotorStarted then
	
		if self:getIsActive() then
		
			if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
				if InputBinding.isPressed(InputBinding.ZH18500PU_DRAWBAR_DOWN) then
					local v = math.min( self.drawbar.rotCur + dt*self.drawbar.rotSpeed, self.drawbar.rotMax );
					self:setDrawbar(v);
				elseif InputBinding.isPressed(InputBinding.ZH18500PU_DRAWBAR_UP) then
					local v = math.max( self.drawbar.rotCur - dt*self.drawbar.rotSpeed, self.drawbar.rotMin );
					self:setDrawbar(v);
				end
			end
			
		end;

		if self.searchJoint == true then --self.isServer and self.searchJoint == true then
		
			local attacherVehicle = self.attacherVehicle;
			while true do
				if attacherVehicle.attacherVehicle ~= nil then
					attacherVehicle = attacherVehicle.attacherVehicle;
					if SpecializationUtil.hasSpecialization(Steerable, attacherVehicle.specializations) then
						break;
					end;
				else
					break;
				end;
			end;
			if attacherVehicle ~= nil and self.searchJoint then
				for k, implement in pairs(attacherVehicle.attachedImplements) do
					if implement.object == self then
						self.attVehJoint = attacherVehicle.attacherJoints[implement.jointDescIndex];
						self.searchJoint = false;
						break;
					end;
				end;
			end;
			
		end;
		
		if self.attVehJoint ~= nil then
			if self.drawbar.rotCurOld ~= self.drawbar.rotCur then
				self.drawbar.rotCurOld = self.drawbar.rotCur;
				setRotation(self.drawbar.node, self.drawbar.rotCur,0,0);
				if self.isServer then
					setJointFrame(self.attVehJoint.jointIndex, 1, self.attacherJoint.node);
				end
				self.rpmInc.drawbar = 400;
				
				if self.isClient then
					playCylSound = true;				
				end;
			else
				self.rpmInc.drawbar = 0;	

			end;
		end;
			
	end;
	
	
	if self.isClient then
	
		if self.attacherJoints[1] ~= nil then
			if self.attacherJoints[1].moveDown == true then
				if math.abs( self.attacherJoints[1].moveAlpha - self.attacherJoints[1].lowerAlpha )  > 0.0001 then
					playCylSound = true;
				end
			elseif self.attacherJoints[1].moveDown == false then
				if math.abs( self.attacherJoints[1].moveAlpha - self.attacherJoints[1].upperAlpha ) > 0.0001 then
					playCylSound = true;
				end;
			end
		end;	
	
		if playCylSound == true and self.cylinderedHydraulicSoundEnabled2 == false and self:getIsActiveForSound() then
			playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
			self.cylinderedHydraulicSoundEnabled2 = true;
		else
			if playCylSound == false and self.cylinderedHydraulicSoundEnabled2 then 
				stopSample(self.cylinderedHydraulicSound);
				self.cylinderedHydraulicSoundEnabled2 = false;
			end;
		end;		
	end
	
	
	--
	--if self.isClient then
	--	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
	--		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1"), 0.07+0.022, 0.019+0.029);
	--	elseif self.showFieldNotOwnedWarning then
	--		g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
	--	end;	
	--end;
	
	
	--
	if self.isClient then
		--#	
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.motor ~= nil then
				local p = 0;
				
				if self.isTurnedOn == true then					
					p = 1;
					if self.pressureState ~= nil then
						p = math.sqrt(self.pressureState/self.pressureStateMax);
					end;									
				elseif self.fm.fillLevelChanged ~= 0 then
					p = 1;
				end				
				-- handled by MR
				--self.rpmInc.turnOn = 0; --p*self.rpmInc.turnOnDefault;	
				
				if self.fillarm.anim.curTimeOld2 ~= self.fillarm.anim.curTime then
					self.fillarm.anim.curTimeOld2 = self.fillarm.anim.curTime;
					self.rpmInc.fillarm = 400;
				else
					self.rpmInc.fillarm = 0;
				end;
				
				local pumpInc = 0;
				if self.pumpDir ~= 0 then
					pumpInc = 800;
				end;
				
				local totalInc = self.rpmInc.fillarm + self.rpmInc.drawbar + pumpInc;	--+ self.rpmInc.turnOn 

				--print("self.rpmInc.fillarm/turnOn/drawbar/pumpInc = "..self.rpmInc.fillarm.."/"..self.rpmInc.turnOn.."/"..self.rpmInc.drawbar.."/"..pumpInc.." => "..totalInc);

				if totalInc > 0 then
					--self:setVehicleIncreaseRpm(dt, totalInc, true);
					self.realWorkingPowerConsumption_extra = totalInc / 10;
				else
					--self:setVehicleIncreaseRpm(dt, 0, false);
					self.realWorkingPowerConsumption_extra = 0;
				end			
			
				
			end;
		end;	
	end;	
	

end;


function Zunhammer18500pu:updateTick(dt)

	self.realCurrentPowerConsumption = self.realCurrentPowerConsumption + self.realWorkingPowerConsumption_extra;
				
	--# 
	if self.isServer and not self.isActive then
		local rootVehicle = self:getRootAttacherVehicle();
		if rootVehicle ~= nil and rootVehicle.realIsMotorized then
			if not rootVehicle.isActive then
				if self.realCurrentPowerConsumption == 0 then
					rootVehicle.realMotorLoad = 0;
				else
					rootVehicle.realMotorLoad = 0.9;
				end;
			end;
		end;
	end;		
	
	
	--if self:getIsActive() then
		if self.isTurnedOn and self.allowsSpraying then
			if self.isClient then
				if self:doCheckSpeedLimit() and self.lastSpeed*3600 > 17 then
					self.speedViolationTimer = self.speedViolationTimer - dt;
				else
					self.speedViolationTimer = self.speedViolationMaxTime;
				end;
			end;
		end;
	--end;

	--#
	if self.isClient then
	
		local psChanged = false;
		if self.pressureState ~= nil then
			if self.lastPressureState ~= self.pressureState then
				self.lastPressureState = self.pressureState;
				psChanged = true;
			end;
		end;
		
		--#
		if self.fm.lastFillLevel ~= self.fillLevel then
			self.fm.fillLevelChanged = self.fillLevel - self.fm.lastFillLevel;
			self.fm.lastFillLevel = self.fillLevel;
			local newRot = Utils.getMovedLimitedValues(self.fm.minRot, self.fm.minRot, self.fm.maxRot, 3, self.capacity, self.fillLevel, true);
			setRotation(self.fm.node, newRot[1],newRot[2],newRot[3]);
		else
			self.fm.fillLevelChanged = 0;
		end;		
		
		--#	
		if self.fillarm.bIsOpen then
			self.allowFillFromAir = true;
			if self.lastSprayerFillTrigger ~= nil then
				--print("trigger re-added!");
				self:addSprayerFillTrigger(self.lastSprayerFillTrigger);
				self.lastSprayerFillTrigger = nil;
			end;
		else
			self.allowFillFromAir = false;
			if table.getn(self.sprayerFillTriggers) > 0 then
				for i,j in pairs(self.sprayerFillTriggers) do
					local fdt = getUserAttribute(j.triggerNode, "isFrontDockTrigger");
					if fdt ~= true then 
						--print("trigger removed!");
						self.lastSprayerFillTrigger = j;
						self:removeSprayerFillTrigger(j);
					end;
				end;
			end
		end;
		
	end;


end;



function Zunhammer18500pu:draw()


	if self.isClient then

		if self.attacherVehicle ~= nil and self.attacherVehicle.isMotorStarted then --and self:getIsActive() then
			
			if self:getIsActiveForInput(true) then
				if not self:getIsTurnedOnAllowed(true) and self.fillLevel <= 0 then
					g_currentMission:addExtraPrintText(g_i18n:getText("FirstFillTheTool"));
				end;

				if self.allowsSpraying then
					if self.isTurnedOn then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
					end;
				end
			end

			if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
				g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "1"), 0.07+0.022, 0.019+0.029);
			elseif self.showFieldNotOwnedWarning then
				g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
			end;	
			
			--#
			--local changedFL = 0;
			--if self.lastFillLevel_draw ~= self.fillLevel then
			--	changedFL = self.fillLevel - self.lastFillLevel_draw;
			--	self.lastFillLevel_draw = self.fillLevel;
			--end;

			if self:getIsActiveForInput(true) then
			
				g_currentMission:addHelpButtonText( g_i18n:getText("ZH18500PU_DRAWBAR_UP"), InputBinding.ZH18500PU_DRAWBAR_UP );	
				g_currentMission:addHelpButtonText( g_i18n:getText("ZH18500PU_DRAWBAR_DOWN"), InputBinding.ZH18500PU_DRAWBAR_DOWN );	
			
				--if self.fm.fillLevelChanged <= 0 then
				--if changedFL == 0 and self.pumpDir == 0 then
				if self.fm.fillLevelChanged and self.pumpDir == 0 then
					--# fillarm
					if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
						g_currentMission:addHelpButtonText( g_i18n:getText("ZH18500PU_ARM_UP"), InputBinding.ZH18500PU_ARM_UP );	
						g_currentMission:addHelpButtonText( g_i18n:getText("ZH18500PU_ARM_DOWN"), InputBinding.ZH18500PU_ARM_DOWN );	
					end			
				end;
			
			end;
			
		end;
		
		if self.isEntered or self.selectedImplement == nil then
			for k,v in pairs(self.specializations) do
				if v.setFillarm == nil and v.setIsSprayerFilling == nil then
					v.draw(self);
				end;
			end;
		end;

		if self.selectedImplement ~= nil then
			self.selectedImplement.object:draw();
		end;		
		
	end;
	
end;


function Zunhammer18500pu:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
    return BaseMission.VEHICLE_LOAD_OK;	
end;

function Zunhammer18500pu:getSaveAttributesAndNodes(nodeIdent)
    local attributes = ''; 
    return attributes, nil;
end;


--#
function Zunhammer18500pu:onAttach(attacherVehicle)
	self.searchJoint = true;
	self.attacherVehicle = attacherVehicle;
	if self.attacherVehicleCopy1 == nil then
		self.attacherVehicleCopy1 = self.attacherVehicle;
	end;
	if self.attacherVehicle.motor ~= nil then
		self.saveMinimumRpm = self.attacherVehicle.motor.minRpm;
		self.attacherVehicleMinRpm = self.attacherVehicle.motor.minRpm;
	else
		if self.attacherVehicle.saveMinRpm ~= nil then
			self.saveMinimumRpm = self.attacherVehicle.saveMinimumRpm;
		else
			self.attacherVehicle.saveMinimumRpm  = 100;
		end;
	end;
end;

--###
function Zunhammer18500pu:onDetach()
	self.searchJoint = false;
	self.attVehJoint = nil;
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy1 == steerable then
			steerable.motor.minRpm = self.saveMinimumRpm;
			if steerable.motor.rpmIncByImplement ~= nil then
				if steerable.motor.rpmIncByImplement[self] ~= nil then
					steerable.motor.rpmIncByImplement[self] = 0;
				end;
			end;
			self.attacherVehicleCopy1 = nil;
		end;
	end;
end;

function Zunhammer18500pu:attachImplement(implement)
	self.attachedImplement = implement.object;
end;

function Zunhammer18500pu:detachImplement()
	self.attachedImplement = nil;
	setRotation(self.toparm.rotIndex, self.toparm.origRot, 0, 0);
	setTranslation(self.toparm.pushIndex, 0,0,self.toparm.pushOffset);
end


--###
function Zunhammer18500pu:getIsTurnedOnAllowed(isTurnedOn)
	if self.PTOId then
		return false;
	else
		if not isTurnedOn or self.fillLevel > 0 or self.capacity == 0 or self:getIsHired() then
			return true;
		end;
	end;
	return false;
end;

--###
function Zunhammer18500pu:setVehicleIncreaseRpm(dt, increase, isActive)
--print("function Zunhammer18500pu:setVehicleIncreaseRpm("..tostring(dt)..", "..tostring(increase)..", "..tostring(isActive));
	
	if self.attacherVehicle ~= nil and self.saveMinimumRpm ~= 0 and self.attacherVehicle.motor ~= nil then
	
		if dt ~= nil then
			if isActive == true then
				--self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-(dt*2), -increase);
				self.attacherVehicleMinRpm = math.max(self.attacherVehicleMinRpm-(dt*2), -increase);
			else
				--self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+(dt*5), self.saveMinimumRpm);
				self.attacherVehicleMinRpm = math.min(self.attacherVehicleMinRpm+(dt*4), self.saveMinimumRpm);
			end;
		else
			--self.attacherVehicle.motor.minRpm = self.saveMinimumRpm;
			self.attacherVehicleMinRpm = self.saveMinimumRpm;
		end;
		self.attacherVehicle.motor.minRpm = self.attacherVehicleMinRpm;
		--print("self.attacherVehicle.motor.minRpm="..tostring(self.attacherVehicle.motor.minRpm));
		
		if self.attacherVehicle.motor.rpmIncByImplement == nil then
			self.attacherVehicle.motor.rpmIncByImplement = {};
			self.attacherVehicle.motor.rpmIncByImplement[self] = 2*math.abs(self.attacherVehicle.motor.minRpm);
		else
			self.attacherVehicle.motor.rpmIncByImplement[self] = 2*math.abs(self.attacherVehicle.motor.minRpm);
		end;
		
		if self.attacherVehicle.isMotorStarted then
			local fuelUsed = 0.0000012*math.abs(self.attacherVehicle.motor.minRpm);
			self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

--###
function Zunhammer18500pu:setFillarm(val, noEventSend)
	SetFillarmEvent.sendEvent(self, val, noEventSend);
	self.fillarm.anim.curTime = val;
end;

--###
function Zunhammer18500pu:setForcedSteering(state, noEventSend)
	SetForcedSteeringEvent.sendEvent(self, state, noEventSend);
	self.isForcedSteering = state;
end;

--###
function Zunhammer18500pu:setDrawbar(val, noEventSend)
	SetDrawbarEvent.sendEvent(self, val, noEventSend);
	self.drawbar.rotCur = val;
end;