--
--

local mod_directory = g_currentModDirectory;
--source(Utils.getFilename("scripts/StaticParticleSystem.lua", mod_directory));

local moddir = g_currentModDirectory;

Vogelsang = {};

function Vogelsang.prerequisitesPresent(specializations)
    return true;
end;


function Vogelsang:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;


function Vogelsang:load(xmlFile)
	self.printTable = Vogelsang.printTable;

	
	
	self.su = {};
	
	--<meshes rootIdx="0>7" meshCount="6" />
	self.su.meshes = {};
	self.su.mshCnt = getXMLInt(xmlFile, "vehicle.vogelsang#meshCount");
	self.su.rootIdx = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vogelsang#meshRootIdx"));
	for i=1,self.su.mshCnt do 
		local msh = getChildAt(self.su.rootIdx, 0);
		if msh ~= nil then
			table.insert(self.su.meshes, msh);
			link( getRootNode(), msh );
			setTranslation( msh, 0, 0, 0 );
			setRotation( msh, 0, 0, 0 );		
		else
			print("[ERROR:Volgelsang] Wrong numbers of meshes!");
			break;
		end;
	end;
	
	self.animTimeForDetach = getXMLInt(xmlFile, "vehicle.vogelsang#animTimeForDetach");
	
	
	--###
	self.setFoldingDir = SpecializationUtil.callSpecializationsFunction("setFoldingDir");	
	self.setUnfold = false;
	self.isFold = false;
	self.isUnfold = true;
	
	--
	self.setParking = SpecializationUtil.callSpecializationsFunction("setParking");
	self.setPark = true;
	self.isPark = false;
	self.isTrans = true;



	self.foldParts = {};
	local r=0;
	while true do 
		local baseName = string.format("vehicle.vogelsang.foldingParts.foldingPart(%d)", r);
		local part = {};
		part.animCharSet = 0;
		local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode"));
		if rootNode ~= nil then
			local animCharSet = getAnimCharacterSet(rootNode);
			if animCharSet ~= 0 then
				local clip = getAnimClipIndex(animCharSet, getXMLString(xmlFile, baseName.."#animationClip"));
				if clip >= 0 then
					local speed = getXMLFloat(xmlFile, baseName.."#speedScale");
					part.animCharSet = animCharSet;
					part.speed = speed;
					assignAnimTrackClip(part.animCharSet, 0, clip);
					setAnimTrackLoopState(part.animCharSet, 0, false);
					part.animDuration = getAnimClipDuration(part.animCharSet, clip);
					setAnimTrackTime(part.animCharSet, 0, part.animDuration, true);
					--setAnimTrackTime(part.animCharSet, 0, self.animTimeForDetach);
				else
					print("[ERROR:Vogelesang] clip for foldingPart " .. r .. " is "..tostring(clip));
				end
			else
				print("[ERROR:Vogelesang] animCharSet for foldingPart " .. r .. " is "..tostring(animCharSet));
			end
		else
			break;
		end
		
		part.cmpJnts = {};
		part.anchorAct = {};
		local nrJnts = getXMLInt(xmlFile, baseName.."#componentJointCount");
		local jntIds = Utils.getVectorNFromString( getXMLString(xmlFile, baseName.. "#componentJointIndex"), nrJnts );
		local anchorAct = Utils.getVectorNFromString( getXMLString(xmlFile, baseName.. "#anchorActor"), nrJnts );
		for i,j in pairs(jntIds) do
			local componentJoint = self.componentJoints[j];
			table.insert(part.cmpJnts, componentJoint);
			table.insert(part.anchorAct, anchorAct[i]);
		end;
		
		table.insert(self.foldParts, part);
		r = r + 1;
	end;
	for i,part in pairs(self.foldParts) do		
		if self.isServer then 
			for i,jnt in pairs(part.cmpJnts) do
				setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
			end;
		end;		
	end;
	
	--###	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	self.cuttingAreas = {}
	for i=1, numCuttingAreas do
		self.cuttingAreas[i] = {};
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.cuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.cuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
		self.cuttingAreas[i].foldMinLimit = 0;
		self.cuttingAreas[i].foldMaxLimit = 1;
	end;		
	
	
	--###
	self.sprayValves = {};
	
	self.pressureStateSprayValves = {};
	self.pressureStateSprayValves[1] = {};
	
	if self.isClient then
		local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystem#file");
		if psFile ~= nil then
			local i=0;
			while true do
				local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
				local node = getXMLString(xmlFile, baseName.. "#index");
				if node == nil then
					break;
				end;
				node = Utils.indexToObject(self.components, node);
				if node ~= nil then
					local sprayValve = {};
					sprayValve.particleSystems = {};
					Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, moddir); --self.baseDirectory);
					--Utils.loadParticleSystem(xmlFile, ps.ps, "vehicle.moescha.sprayer.staticSprayParticleSystem", ps.node, false, "noPS", moddir);
					--StaticParticleSystem.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, moddir);	
					
					sprayValve.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMinLimit"), 0);
					sprayValve.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMaxLimit"), 1);

					--table.insert(self.sprayValves, sprayValve);
					table.insert(self.pressureStateSprayValves[1], sprayValve);
				end;
				i = i+1;
			end;
		end;
	end;
 	for _,sprayValve in pairs(self.sprayValves) do
		for _, v in ipairs(sprayValve.particleSystems) do
			v.originalLifespan = getParticleSystemLifespan(v.geometry);
		end;
	end;	
	
	--# cylinder sound
	self.cylinderedHydraulicSoundEnabled2 = false;		
	
	
	--#
	-- <topArm leftIndex="0>2|1" rightIndex="0>2|2" leftRefIndex="0>2|3"/ rightRefIndex="0>2|4" />
	self.toparm = {};
	self.toparm.left = {};
	self.toparm.left.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vogelsang.topArm#leftIndex"));
	local x,y,z = getTranslation(self.toparm.left.node);
	self.toparm.left.nodePos = {x,y,z}; 
	self.toparm.left.push = getChildAt(self.toparm.left.node, 0); 
	self.toparm.left.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vogelsang.topArm#leftRefIndex"));
	local x1,y1,z1 = getWorldTranslation(self.toparm.left.push);
	local x2,y2,z2 = getWorldTranslation(self.toparm.left.ref);
	self.toparm.left.pushLength = Utils.vector3Length(x1-x2, y1-y2, z1-z2);
	
	self.toparm.right = {};
	self.toparm.right.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vogelsang.topArm#rightIndex"));
	local x,y,z = getTranslation(self.toparm.right.node);
	self.toparm.right.nodePos = {x,y,z}; 
	self.toparm.right.push = getChildAt(self.toparm.right.node, 0); 
	self.toparm.right.ref = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.vogelsang.topArm#rightRefIndex"));
	local x1,y1,z1 = getWorldTranslation(self.toparm.right.push);
	local x2,y2,z2 = getWorldTranslation(self.toparm.right.ref);
	self.toparm.right.pushLength = Utils.vector3Length(x1-x2, y1-y2, z1-z2);	
	
	--#
	
	--#
	self.alternateSprayValves = {};
	self.alternatePressureStateSprayValves = {};
	self.alternatePressureStateSprayValves[1] = {};
	if self.isClient then
		local psFile = getXMLString(xmlFile, "vehicle.alternateSprayParticleSystem#file");
		if psFile ~= nil then
			local i=0;
			while true do
				local baseName = string.format("vehicle.alternateSprayValves.sprayValve(%d)", i);
				local node = getXMLString(xmlFile, baseName.. "#index");
				if node == nil then
					break;
				end;
				node = Utils.indexToObject(self.components, node);
				if node ~= nil then
					local sprayValve = {};
					sprayValve.particleSystems = {};
					
					Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.alternateSprayParticleSystem", node, false, nil, moddir); --self.baseDirectory);
					--StaticParticleSystem.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.alternateSprayParticleSystem", node, false, nil, moddir);				
					
					sprayValve.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMinLimit"), 0);
					sprayValve.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMaxLimit"), 1);

					--table.insert(self.alternateSprayValves, sprayValve);
					table.insert(self.alternatePressureStateSprayValves[1], sprayValve);
				end;
				i = i+1;
			end;
		end;
	end;
 	for _,sprayValve in pairs(self.alternateSprayValves) do
		for _, v in ipairs(sprayValve.particleSystems) do
			v.originalLifespan = getParticleSystemLifespan(v.geometry);
		end;
	end;	
	
	
	--###	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.alternateCuttingAreas#count"), 0);
	self.alternateCuttingAreas = {}
	for i=1, numCuttingAreas do
		self.alternateCuttingAreas[i] = {};
		local areanamei = string.format("vehicle.alternateCuttingAreas.cuttingArea%d", i);
		self.alternateCuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.alternateCuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.alternateCuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
		self.alternateCuttingAreas[i].foldMinLimit = 0;
		self.alternateCuttingAreas[i].foldMaxLimit = 1;
	end;	
	local caCnt = Utils.getNoNil( getXMLInt(xmlFile, "vehicle.alternateCuttingAreas#count"), 1 );
	for i=1,caCnt do
		self.alternateCuttingAreas[i].pressureStates = {};
		local j=1;
		while true do
			local lps = getXMLInt(xmlFile, string.format("vehicle.alternateCuttingAreas.cuttingArea%d.pressureState%d#litersPerSecond",i,j));
			if lps == nil then 
				break;
			end;
			
			local e={};
			e.lps = lps;
			e.startPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.alternateCuttingAreas.cuttingArea%d.pressureState%d#startPos",i,j)), 3 );
			e.widthPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.alternateCuttingAreas.cuttingArea%d.pressureState%d#widthPos",i,j)), 3 );
			e.heightPos = Utils.getVectorNFromString( getXMLString(xmlFile, string.format("vehicle.alternateCuttingAreas.cuttingArea%d.pressureState%d#heightPos",i,j)), 3 );
			table.insert(self.alternateCuttingAreas[i].pressureStates, e);
			self.hasPressureStates = true;

			j=j+1;
		end;
		self.pressureStateMax = j - 1;
	end; 	
	
	
end;


function Vogelsang:delete()
--print("function Vogelsang:delete()");
	for i,j in pairs(self.su.meshes) do
		delete(j);
	end;
	for i,sprayValves in pairs(self.alternatePressureStateSprayValves) do
		for j,valve in pairs(sprayValves) do
			if valve.particleSystems ~= nil then
				Utils.deleteParticleSystem(valve.particleSystems);	
			end;
		end;
	end;
end;

function Vogelsang:readStream(streamId, connection)
	--print("function Vogelsang:readStream(streamId, connection)")
	self.setPark = streamReadBool(streamId);
	self.isPark = streamReadBool(streamId);
	self.isTrans = streamReadBool(streamId);
	self.setUnfold = streamReadBool(streamId);
	self.isFold = streamReadBool(streamId);
	self.isUnfold = streamReadBool(streamId);
	for i,part in pairs(self.foldParts) do	
		local t = streamReadFloat32(streamId);
		part.timeToLoad = t;
		enableAnimTrack(part.animCharSet, 0);
		setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
		setAnimTrackTime(part.animCharSet, 0, t, true);
		disableAnimTrack(part.animCharSet, 0);
		for i,jnt in pairs(part.cmpJnts) do
			setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
		end;			
	end;	
	
	if self.setUnfold and self.isUnfold == true then
		if self.attacherVehicleCopy ~= nil then
			self.attacherVehicleCopy.sprayValves = self.sprayValves;
			self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;
		end;
	elseif self.setUnfold == false and self.isFold == true then
		if self.attacherVehicleCopy ~= nil then
			self.attacherVehicleCopy.sprayValves = self.alternateSprayValves;
			self.attacherVehicleCopy.cuttingAreas = self.alternateCuttingAreas;					
		end;
	end;
end;

function Vogelsang:writeStream(streamId, connection)
	--print("function Vogelsang:writeStream(streamId, connection)");
	streamWriteBool(streamId, self.setPark);
	streamWriteBool(streamId, self.isPark);
	streamWriteBool(streamId, self.isTrans);
	streamWriteBool(streamId, self.setUnfold);
	streamWriteBool(streamId, self.isFold);
	streamWriteBool(streamId, self.isUnfold);
	for i,part in pairs(self.foldParts) do	
		local animTime = getAnimTrackTime(part.animCharSet, 0);	
		streamWriteFloat32(streamId, animTime);
	end;
end;

function Vogelsang:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.setPark = getXMLBool(xmlFile, key.."#setPark");
		self.isPark = getXMLBool(xmlFile, key.."#isPark");
		self.isTrans = getXMLBool(xmlFile, key.."#isTrans");
		self.setUnfold = getXMLBool(xmlFile, key.."#setUnfold");
		self.isFold = getXMLBool(xmlFile, key.."#isFold");
		self.isUnfold = getXMLBool(xmlFile, key.."#isUnfold");
		for i,part in pairs(self.foldParts) do	
			local t = getXMLFloat(xmlFile, key.."#animTimePart"..i);
			part.timeToLoad = t;
			enableAnimTrack(part.animCharSet, 0);
			setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
			setAnimTrackTime(part.animCharSet, 0, t, true);
			disableAnimTrack(part.animCharSet, 0);
			for i,jnt in pairs(part.cmpJnts) do
				setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
			end;			
		end;
		self.loadPartTimes = true;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function Vogelsang:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'setPark="'..tostring(self.setPark)..'" setUnfold="'..tostring(self.setUnfold)..'" ';	
	mystring = mystring .. ' isPark="'..tostring(self.isPark)..'" isTrans="'..tostring(self.isTrans)..'" ';	
	mystring = mystring .. ' isFold="'..tostring(self.isFold)..'" isUnfold="'..tostring(self.isUnfold)..'" ';	
	attributes = attributes .. mystring;
	mystring = '';
	for i,part in pairs(self.foldParts) do				
		local animTime = getAnimTrackTime(part.animCharSet, 0);
		mystring = mystring .. ' animTimePart'..i..'="'..animTime..'"';
	end;
	attributes = attributes .. mystring;
    local node = nil;
	return attributes, node;
end;

function Vogelsang:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Vogelsang:keyEvent(unicode, sym, modifier, isDown)
end;

function Vogelsang:update(dt)	

	--#
	local playCylSound = false;

	--
	--[[
	if self.loadPartTimes == true then
		for i,part in pairs(self.foldParts) do	
			enableAnimTrack(part.animCharSet, 0);
			setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
			setAnimTrackTime(part.animCharSet, 0, part.timeToLoad);
			disableAnimTrack(part.animCharSet, 0);
			if self.isServer then 
				for i,jnt in pairs(part.cmpJnts) do
					setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
				end;
			end;				
		end;	
		self.loadPartTimes = false;
	end; 
	]]--

	--
	if self.doJointSearch then
		for i=1, table.getn(self.attacherVehicleCopy.attachedImplements) do
			if self.attacherVehicleCopy.attachedImplements[i].object == self then			
				local index = self.attacherVehicleCopy.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicleCopy.attacherJoints[index];	
				self.attacherVehicleJoint = joint;
				self.attacherVehicleJointIndex = index;
			end;
		end;
		self.doJointSearch = false;
	end;	
	
	if self.attacherVehicleJoint ~= nil then
		if self.isPark then -- and self.setPark then				
			--if self.attacherVehicleJoint.moveDown == false then
			--	self.attacherVehicleCopy:setJointMoveDown(self.attacherVehicleJointIndex, true);
			--end;
		else
			if self.attacherVehicleJoint.moveDown == true then 
				self.attacherVehicleCopy:setJointMoveDown(self.attacherVehicleJointIndex, false);
			end;
		end;
	end;
	
	--#
	if self:getIsActive() and self.isClient then
		if self.toparm.left.node ~= nil and self.toparm.right.node ~=nil then
			if self.attacherVehicleJoint ~= nil then
				if self.attacherVehicleCopy.vogelTA ~= nil then
					local wx,wy,wz = getWorldTranslation(self.attacherVehicleCopy.vogelTA.leftNode);
					local lx,ly,lz = worldToLocal(getParent(self.toparm.left.node), wx,wy,wz);
					setTranslation(self.toparm.left.node, lx,ly,lz);
					
					local wx2,wy2,wz2 = getWorldTranslation(self.toparm.left.ref);
					local dx,dy,dz = worldDirectionToLocal(getParent(self.toparm.left.node), wx2-wx,wy2-wy,wz2-wz);
					setDirection(self.toparm.left.node, dx,dy,dz, 0,1,0);
					
					local dr = Utils.vector3Length( wx2-wx, wy2-wy, wz2-wz );
					setTranslation(self.toparm.left.push, 0, 0, (dr - self.toparm.left.pushLength));
					
					--
					local wx,wy,wz = getWorldTranslation(self.attacherVehicleCopy.vogelTA.rightNode);
					local lx,ly,lz = worldToLocal(getParent(self.toparm.right.node), wx,wy,wz);
					setTranslation(self.toparm.right.node, lx,ly,lz);
					
					local wx2,wy2,wz2 = getWorldTranslation(self.toparm.right.ref);
					local dx,dy,dz = worldDirectionToLocal(getParent(self.toparm.right.node), wx2-wx,wy2-wy,wz2-wz);
					setDirection(self.toparm.right.node, dx,dy,dz, 0,1,0);
					
					local dr = Utils.vector3Length( wx2-wx, wy2-wy, wz2-wz );
					setTranslation(self.toparm.right.push, 0, 0, (dr - self.toparm.right.pushLength));				
				end;
			else
				
			end;
		end;
	end;
	

	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then		
			if self.attacherVehicleCopy ~= nil and self.attacherVehicleSteer.isMotorStarted and self.attacherVehicleCopy.allowsSpraying then 
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					if (self.isUnfold == true or self.isFold == true) and self.isTrans then
						if self.attacherVehicleCopy.setIsTurnedOn ~= nil then
							if self.attacherVehicleCopy.isTurnedOn == false then
								self.attacherVehicleCopy:setIsTurnedOn(true);
							else
								self.attacherVehicleCopy:setIsTurnedOn(false);
							end;
						end;
					end;
				end;
			end;
		end;
	end;
	
	--
	if self.attacherVehicleCopy ~= nil then
		if (self.isUnfold == false and self.isFold == false) or self.isTrans == false then
			if self.attacherVehicleCopy.isTurnedOn == true then
				--print("turning off (2)");
				self.attacherVehicleCopy:setIsTurnedOn(false);
			end;	
		end;
	end;	
	
	if self:getIsActive() then
	
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if self.isTrans then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					if self.attacherVehicleSteer ~= nil then
						while self.attacherVehicleSteer.attacherVehicle ~= nil do
							self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
						end;						
						if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then
							self:setFoldingDir( not self.setUnfold );
						end;
					end;
				end;
			end;
			
			if self.isFold then
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
					if self.attacherVehicleSteer ~= nil then
						while self.attacherVehicleSteer.attacherVehicle ~= nil do
							self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
						end;						
						if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted then				
							self:setParking( not self.setPark );
						end;
					end;
				end;
			end;
			
		end;
		
	end;

	
	if self.isTrans then
		if (self.setUnfold == false and self.isFold == false) or
			(self.setUnfold == true and self.isUnfold == false) then 

			if self.isClient then
				playCylSound = true;				
			end;	
			
			self.isFold = false;
			self.isUnfold = false;	
		
			local chk = 0;
			for i,part in pairs(self.foldParts) do
				
				enableAnimTrack(part.animCharSet, 0);
				local animTime = getAnimTrackTime(part.animCharSet, 0);
				
				local speed = -part.speed;
				if self.setUnfold == false then
					speed = part.speed;
				end;			
				
				setAnimTrackSpeedScale(part.animCharSet, 0, speed);		
				
				if self.isServer then 
					for i,jnt in pairs(part.cmpJnts) do
						setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
					end;
				end;
				
				
				if self.setUnfold == false and animTime >= part.animDuration then
					chk = chk + 1;
					setAnimTrackTime(part.animCharSet, 0, part.animDuration);
					disableAnimTrack(part.animCharSet, 0);
					--print("disabled");
				elseif self.setUnfold == true and animTime <= 0 then
					chk = chk + 1;
					setAnimTrackTime(part.animCharSet, 0, 0.0);
					disableAnimTrack(part.animCharSet, 0);
					--print("disabled");
				end;

			end;
			
			if chk == 2 then
				if self.setUnfold then
					self.isUnfold = true;
					if self.attacherVehicleCopy ~= nil then
						--self.attacherVehicleCopy.sprayValves = self.sprayValves;
						self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;
						self.attacherVehicleCopy.pressureStateSprayValves = self.pressureStateSprayValves;
						self.attacherVehicleCopy:setPressureState(1,true);
					end;
				else
					self.isFold = true;
					if self.attacherVehicleCopy ~= nil then
						--self.attacherVehicleCopy.sprayValves = self.alternateSprayValves;
						self.attacherVehicleCopy.cuttingAreas = self.alternateCuttingAreas;					
						self.attacherVehicleCopy.pressureStateSprayValves = self.alternatePressureStateSprayValves;
						self.attacherVehicleCopy:setPressureState(1,true);
					end;
				end;
			end;
			
		end;
	end;
	
	--#
	if self.isFold then 
		if (self.setPark == false and self.isTrans == false) or
			(self.setPark == true and self.isPark == false) then		
			
			if self.isClient then
				playCylSound = true;				
			end;			
			
			self.isPark = false;
			self.isTrans = false;	
			self.allowsDetaching = false;	
		
			local cont = true;
			if self.setPark == false then
				cont = false;
				if self.attacherVehicleJoint.moveDown == true then
					self.attacherVehicleCopy:setJointMoveDown(self.attacherVehicleJointIndex, false);					
				end;
				if( self.attacherVehicleJoint.moveAlpha == self.attacherVehicleJoint.upperAlpha ) then
					cont = true;
				end;
			end;		
			
			if cont then 
		
				local chk = 0;
				for i,part in pairs(self.foldParts) do
					
					enableAnimTrack(part.animCharSet, 0);
					local animTime = getAnimTrackTime(part.animCharSet, 0);
					
					local speed = part.speed;
					if self.setPark == true then
						speed = -part.speed;
					end;
					setAnimTrackSpeedScale(part.animCharSet, 0, speed);		
					
					if self.isServer then 
						for i,jnt in pairs(part.cmpJnts) do
							setJointFrame(jnt.jointIndex, part.anchorAct[i], jnt.jointNode);
						end;
					end;
					
					if self.setPark == false and animTime >= part.animDuration then
						setAnimTrackTime(part.animCharSet, 0, part.animDuration);
						disableAnimTrack(part.animCharSet, 0);
						--print("disabled");
						if( self.attacherVehicleJoint.moveAlpha == self.attacherVehicleJoint.upperAlpha ) then
							chk = chk + 1;
						end;
						
					elseif self.setPark == true and animTime <= self.animTimeForDetach then
						setAnimTrackTime(part.animCharSet, 0, self.animTimeForDetach);
						setAnimTrackSpeedScale(part.animCharSet, 0, 0);		
						disableAnimTrack(part.animCharSet, 0);

						if self.attacherVehicleJoint ~= nil then
							if self.attacherVehicleJoint.moveDown == false then
								self.attacherVehicleCopy:setJointMoveDown(self.attacherVehicleJointIndex, true);					
							end;
							if( self.attacherVehicleJoint.moveAlpha == self.attacherVehicleJoint.lowerAlpha ) then
								chk = chk + 1;
							end;
						else
							chk = chk + 1;
						end;
					end;

				end;
				
				if chk == 2 then
					if self.setPark then
						self.isPark = true;
						self.allowsDetaching = true;
					else
						self.isTrans = true;
					end;
				end;
				
			end;
			
		end;	
	end;
	
	self.allowsDetaching = self.isPark;

		
	--###
	if self.isClient then
		if playCylSound == true and self.cylinderedHydraulicSoundEnabled2 == false and self:getIsActiveForSound() then
			playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
			self.cylinderedHydraulicSoundEnabled2 = true;
		else
			if playCylSound == false and self.cylinderedHydraulicSoundEnabled2 then 
				stopSample(self.cylinderedHydraulicSound);
				self.cylinderedHydraulicSoundEnabled2 = false;
			end;
		end;		
	end		

end;

function Vogelsang:updateTick(dt)
	if self.attacherVehicleCopy ~= nil then
		self.attacherVehicleSteer = self.attacherVehicleCopy;
		while self.attacherVehicleSteer.attacherVehicle ~= nil do
			self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
		end;
	end;
end;

function Vogelsang:draw()
	if self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted and self:getIsActive() then 		
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			if self.isTrans then 
				g_currentMission:addHelpButtonText( g_i18n:getText("VOGELSANG_FOLD"), InputBinding.IMPLEMENT_EXTRA2 );	
			end;
			if self.isFold then 
				g_currentMission:addHelpButtonText( g_i18n:getText("VOGELSANG_PARK"), InputBinding.IMPLEMENT_EXTRA3 );	
			end;
		end;
	end;
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then		
			if self.attacherVehicleCopy ~= nil and self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted and self.attacherVehicleCopy.allowsSpraying then 
				if (self.isUnfold == true or self.isFold == true) and self.isTrans then
					if self.attacherVehicleCopy.isTurnedOn then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.attacherVehicleCopy.typeDesc), InputBinding.IMPLEMENT_EXTRA);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.attacherVehicleCopy.typeDesc), InputBinding.IMPLEMENT_EXTRA);
					end;				
				end;
			end;
		end;
	end;	
end;


function Vogelsang:onAttach(attacherVehicle)
	self.doJointSearch = true;
	self.attacherVehicleCopy = attacherVehicle;
	if self.attacherVehicleCopy.isTurnedOn  == true then
		self.attacherVehicleCopy:setIsTurnedOn(false);
	end;
		
	self.attacherVehicleSteer = self.attacherVehicleCopy;
	while self.attacherVehicleSteer.attacherVehicle ~= nil do
		self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
	end;

	self.attacherVehicleCopy.cuttingAreasBackUp = self.attacherVehicleCopy.cuttingAreas;
	--self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;
	
	--self.attacherVehicleCopy.sprayValvesBackUp = self.attacherVehicleCopy.sprayValves;
	--self.attacherVehicleCopy.sprayValves = self.sprayValves;
	
	--self.attacherVehicleCopy.origSprayValvesBackUp = self.attacherVehicleCopy.origSprayValves;
	--self.attacherVehicleCopy.origSprayValves = self.sprayValves;	
	
	self.attacherVehicleCopy.pressureStateSprayValvesBackUp = self.attacherVehicleCopy.pressureStateSprayValves;
	

	if self.isUnfold == true then
		if self.attacherVehicleCopy ~= nil then
			--self.attacherVehicleCopy.sprayValves = self.sprayValves;
			self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;
			--self.attacherVehicleCopy.origSprayValves = self.sprayValves;
			self.attacherVehicleCopy.pressureStateSprayValves = self.pressureStateSprayValves;
		end;
	elseif self.isFold == true then
		if self.attacherVehicleCopy ~= nil then
			--self.attacherVehicleCopy.sprayValves = self.alternateSprayValves;
			self.attacherVehicleCopy.cuttingAreas = self.alternateCuttingAreas;					
			--self.attacherVehicleCopy.origSprayValves = self.sprayValves;
			self.attacherVehicleCopy.pressureStateSprayValves = self.alternatePressureStateSprayValves;			
		end;
	end;
	
	if attacherVehicle.toolsFillRef ~= nil then
		if attacherVehicle.stdSprayer ~= nil then
			setVisibility(attacherVehicle.stdSprayer, false);
		end
	end;	
	
	if attacherVehicle.vogelTA ~= nil then
		if attacherVehicle.vogelTA.heNode ~= nil then
			setVisibility(attacherVehicle.vogelTA.heNode, true);
		end;
	end;
	
	for i,c1 in pairs( self.attacherVehicleCopy.components ) do
		for i,c2 in pairs( self.components ) do
			setPairCollision( c1.node, c2.node, false );
		end;
	end;
end;

function Vogelsang:onDetach()	
	--
	setTranslation(self.toparm.left.node, self.toparm.left.nodePos[1],self.toparm.left.nodePos[2],self.toparm.left.nodePos[3]);
	
	local wx,wy,wz = getWorldTranslation(self.toparm.left.node);
	local wx2,wy2,wz2 = getWorldTranslation(self.toparm.left.ref);
	local dx,dy,dz = worldDirectionToLocal(getParent(self.toparm.left.node), wx2-wx,wy2-wy,wz2-wz);
	setDirection(self.toparm.left.node, dx,dy,dz, 0,1,0);
	
	local dr = Utils.vector3Length( wx2-wx, wy2-wy, wz2-wz );
	setTranslation(self.toparm.left.push, 0, 0, (dr - self.toparm.left.pushLength));				
	
	setTranslation(self.toparm.right.node, self.toparm.right.nodePos[1],self.toparm.right.nodePos[2],self.toparm.right.nodePos[3]);
	local wx2,wy2,wz2 = getWorldTranslation(self.toparm.right.ref);
	local dx,dy,dz = worldDirectionToLocal(getParent(self.toparm.right.node), wx2-wx,wy2-wy,wz2-wz);
	setDirection(self.toparm.right.node, dx,dy,dz, 0,1,0);
	
	local dr = Utils.vector3Length( wx2-wx, wy2-wy, wz2-wz );
	setTranslation(self.toparm.right.push, 0, 0, (dr - self.toparm.right.pushLength));	
				
	--
	if self.attacherVehicleCopy.vogelTA ~= nil then
		if self.attacherVehicleCopy.vogelTA.heNode ~= nil then
			setVisibility(self.attacherVehicleCopy.vogelTA.heNode, false);
		end;
	end;

	self.attacherVehicleSteer = nil;
	self.doJointSearch = false;
	self.attacherVehicleJoint = nil;
	if self.attacherVehicleCopy ~= nil then
		
		if self.attacherVehicleCopy.isTurnedOn  == true then
			self.attacherVehicleCopy:setIsTurnedOn(false);
		end;		
		
		self.attacherVehicleCopy.cuttingAreas = self.attacherVehicleCopy.cuttingAreasBackUp;
		--self.attacherVehicleCopy.sprayValves = self.attacherVehicleCopy.sprayValvesBackUp;
		--self.attacherVehicleCopy.origSprayValves = self.attacherVehicleCopy.origSprayValvesBackUp;
		self.attacherVehicleCopy.pressureStateSprayValves = self.attacherVehicleCopy.pressureStateSprayValvesBackUp;
		
		if self.attacherVehicleCopy.toolsFillRef ~= nil then
			if self.attacherVehicleCopy.stdSprayer ~= nil then
				setVisibility(self.attacherVehicleCopy.stdSprayer, true);
			end
		end;		
		
	end;
	self.attacherVehicleCopy = nil;
end;

function Vogelsang:setFoldingDir(state, noEventSend)
--print("function Vogelsang:setFoldingDir("..tostring(state)..", "..tostring(noEventSend));
	SetFoldingDirEvent.sendEvent(self, state, noEventSend);
	self.setUnfold = state;
end;


function Vogelsang:setParking(state, noEventSend)
--print("function Vogelsang:setParking("..tostring(state)..", "..tostring(noEventSend));
	SetParkingEvent.sendEvent(self, state, noEventSend);
	self.setPark = state;
end;


--
--
--
--
--
SetFoldingDirEvent = {};
SetFoldingDirEvent_mt = Class(SetFoldingDirEvent, Event);

InitEventClass(SetFoldingDirEvent, "SetFoldingDirEvent");

function SetFoldingDirEvent:emptyNew()
    local self = Event:new(SetFoldingDirEvent_mt);
    self.className="SetFoldingDirEvent";
    return self;
end;

function SetFoldingDirEvent:new(vehicle, state)
    local self = SetFoldingDirEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetFoldingDirEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetFoldingDirEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetFoldingDirEvent:run(connection)
	self.vehicle:setFoldingDir(self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(SetFoldingDirEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;


function SetFoldingDirEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFoldingDirEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFoldingDirEvent:new(vehicle, state));
		end;
	end;
end;

--
--
--
--
--
SetParkingEvent = {};
SetParkingEvent_mt = Class(SetParkingEvent, Event);

InitEventClass(SetParkingEvent, "SetParkingEvent");

function SetParkingEvent:emptyNew()
    local self = Event:new(SetParkingEvent_mt);
    self.className="SetParkingEvent";
    return self;
end;

function SetParkingEvent:new(vehicle, state)
    local self = SetParkingEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetParkingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetParkingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetParkingEvent:run(connection)
	self.vehicle:setParking(self.state, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(SetParkingEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
	end;
end;


function SetParkingEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetParkingEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetParkingEvent:new(vehicle, state));
		end;
	end;
end;