--
-- ToolCamera, modified for usage with fastCoupler
--

ToolCamera = {};

function ToolCamera.prerequisitesPresent(specializations)
    return true;
end;

function ToolCamera:load(xmlFile)
	self.setToolCameraState = SpecializationUtil.callSpecializationsFunction("setToolCameraState");	
	self.numCameras = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cameras#count"), 0);
    self.cameras = {};
	for i=1, self.numCameras do
		local cameranamei = string.format("vehicle.cameras.camera%d", i);
		local camera = VehicleCamera:new(self);
		if camera:loadFromXML(xmlFile, cameranamei) then
			table.insert(self.cameras, camera);
		end;
	end;
	self.toolCameraActive = false;
end;

function ToolCamera:delete()
end;

function ToolCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ToolCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function ToolCamera:update(dt)		

end;

function ToolCamera:draw()
end;


function ToolCamera:onAttach(attacherVehicle)
	if attacherVehicle.attacherVehicle ~= nil then
		self.attacherVehicleCopy = attacherVehicle.attacherVehicle;
		table.insert(self.attacherVehicleCopy.cameras, self.cameras[1]);
		self.attacherVehicleCopy.numCameras = table.getn(self.attacherVehicleCopy.cameras);
		self.cameraInsertNum = self.attacherVehicleCopy.numCameras;
		self.saveMinCameraDistance = self.attacherVehicleCopy.characterCameraMinDistance;
	end;
end;

function ToolCamera:onDetach()	
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			self.saveMinCameraDistance = nil;
			if self.toolCameraActive then
				steerable.cameras[self.cameraInsertNum]:onDeactivate();
				steerable.camIndex = 1;
			end;
			table.remove(steerable.cameras, self.cameraInsertNum);
			steerable.numCameras = steerable.numCameras-1;
			self.cameraInsertNum = nil;
			if self.toolCameraActive then
				steerable.cameras[steerable.camIndex]:onActivate();
				self:setToolCameraState(false);
			end;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function ToolCamera:setToolCameraState(cameraState, noEventSend)
	--ToolCameraState.sendEvent(self, cameraState, noEventSend);
	self.toolCameraActive = cameraState;
end;