StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
	--print("function StaticParticleSystem.loadParticleSystem("..tostring(_func)..", "..tostring(xmlFile)..", "..tostring(particleSystemTable)..", "..tostring(baseString)..", "..tostring(component)..", "..tostring(currentEmittingState)..", "..tostring(defaultParticleSystem)..", "..tostring(directory));
	local defaultLinkNode = component;
	local isStatic = Utils.getNoNil(isStaticParticle, false);
	local posStr = getXMLString(xmlFile, baseString .. "#position");
    local rotStr = getXMLString(xmlFile, baseString .. "#rotation");
	if type(component) == "table" then
		defaultLinkNode = component[1].node;
	end;
	local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
	local psFile = getXMLString(xmlFile, baseString .. "#file");
	if psFile == nil then
		psFile = defaultParticleSystem;
	end
	if psFile == nil then
		return;
	end
	psFile = Utils.getFilename(psFile, directory);
	local rootNode = loadI3DFile(psFile); --Utils.loadSharedI3DFile(psFile); --loadI3DFile(psFile);
	if rootNode == 0 then
		print("Error: failed to load particle system ".. psFile);
		return;
	end
	link(linkNode, rootNode);
	if posStr ~= nil and rotStr ~= nil then
		local posX, posY, posZ = Utils.getVectorFromString(posStr);
		local rotX, rotY, rotZ = Utils.getVectorFromString(rotStr);
		if posStr ~= nil and rotStr ~= nil then
			rotX = Utils.degToRad(rotX);
			rotY = Utils.degToRad(rotY);
			rotZ = Utils.degToRad(rotZ);
			setTranslation(rootNode, posX, posY, posZ);
			setRotation(rootNode, rotX, rotY, rotZ);
		end;
	end;
	for i=0, getNumOfChildren(rootNode)-1 do
		local child = getChildAt(rootNode, i);
		if getClassName(child) == "Shape" then
			local geometry = getGeometry(child);
			if geometry ~= 0 then
				if getClassName(geometry) == "ParticleSystem" then
					table.insert(particleSystemTable, {geometry = geometry, shape = child});
					if currentEmittingState ~= nil then
						setEmittingState(geometry, currentEmittingState);
					end;
				end;
			end;
		end;
	end;
	return rootNode;
end;