SetForcedSteeringEvent = {};
SetForcedSteeringEvent_mt = Class(SetForcedSteeringEvent, Event);

InitEventClass(SetForcedSteeringEvent, "SetForcedSteeringEvent");

function SetForcedSteeringEvent:emptyNew()
    local self = Event:new(SetForcedSteeringEvent_mt);
    self.className="SetForcedSteeringEvent";
    return self;
end;

function SetForcedSteeringEvent:new(object, active)
    local self = SetForcedSteeringEvent:emptyNew()
    self.object = object;
	self.active = active;
    return self;
end;

function SetForcedSteeringEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.active = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetForcedSteeringEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.active);
end;

function SetForcedSteeringEvent:run(connection)
    self.object:setForcedSteering(self.active, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetForcedSteeringEvent:new(self.object, self.active), nil, connection, self.object);
    end;
end;

function SetForcedSteeringEvent.sendEvent(vehicle, active, noEventSend)
    if active ~= vehicle.isForcedSteering then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(SetForcedSteeringEvent:new(vehicle, active), nil, nil, vehicle);
            else
				g_client:getServerConnection():sendEvent(SetForcedSteeringEvent:new(vehicle, active));
            end;
        end;
    end;
end;

