SetFillarmEvent = {};
SetFillarmEvent_mt = Class(SetFillarmEvent, Event);

InitEventClass(SetFillarmEvent, "SetFillarmEvent");

function SetFillarmEvent:emptyNew()
    local self = Event:new(SetFillarmEvent_mt);
    self.className="SetFillarmEvent";
    return self;
end;

function SetFillarmEvent:new(vehicle, val)
    local self = SetFillarmEvent:emptyNew()
    self.vehicle = vehicle;
	self.val = val;
	return self;
end;

function SetFillarmEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.val = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetFillarmEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteFloat32(streamId, self.val);
end;

function SetFillarmEvent:run(connection)
	self.vehicle:setFillarm(self.val, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetFillarmEvent:new(self.vehicle, self.val), nil, connection, self.vehicle);
	end;
end;

function SetFillarmEvent.sendEvent(vehicle, val, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFillarmEvent:new(vehicle, val), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFillarmEvent:new(vehicle, val));
		end;
	end;
end;