SetDrawbarEvent = {};
SetDrawbarEvent_mt = Class(SetDrawbarEvent, Event);

InitEventClass(SetDrawbarEvent, "SetDrawbarEvent");

function SetDrawbarEvent:emptyNew()
    local self = Event:new(SetDrawbarEvent_mt);
    self.className="SetDrawbarEvent";
    return self;
end;

function SetDrawbarEvent:new(vehicle, val)
    local self = SetDrawbarEvent:emptyNew()
    self.vehicle = vehicle;
	self.val = val;
	return self;
end;

function SetDrawbarEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.val = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetDrawbarEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteFloat32(streamId, self.val);
end;

function SetDrawbarEvent:run(connection)
	self.vehicle:setDrawbar(self.val, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetDrawbarEvent:new(self.vehicle, self.val), nil, connection, self.vehicle);
	end;
end;

function SetDrawbarEvent.sendEvent(vehicle, val, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetDrawbarEvent:new(vehicle, val), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetDrawbarEvent:new(vehicle, val));
		end;
	end;
end;