--
--
local moddir = g_currentModDirectory;

Moescha = {};

function Moescha.prerequisitesPresent(specializations)
    return true;
end;


function Moescha:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;


function Moescha:load(xmlFile)
	self.printTable = Moescha.printTable;
	self.updateMesh = Moescha.updateMesh;

	self.moescha = {};
	
	self.moescha.msh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moescha.mesh#index"));
	-- is linked last
	
	self.moescha.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moescha.adapter#index"));
	local x,y,z = getTranslation(self.moescha.adapter);
	self.moescha.adapterPos = {x=x, y=y, z=z};
	
	self.moescha.jnts = {};
	local tmpRoot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moescha.jntsRoot#index"));
	self.moescha.jnts.root = tmpRoot;
	for i=1,9 do 
		local c = getChildAt(tmpRoot, i-1);	
		table.insert( self.moescha.jnts, c );
	end;
	
	self.moescha.ref = {};
	local ref1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moescha.jntsRef1#index"));
	local ref2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moescha.jntsRef2#index"));
	table.insert( self.moescha.ref, ref1 );
	table.insert( self.moescha.ref, ref2 );

	
	--###
	--<sprayer>
	--	<staticSprayParticleSystem file="particlesystems/moeschaPS.i3d" position="0 0 0" rotation="0 0 0"/>
	--	<left rotIndex="0>1|0" rotMin="-12" rotMax="40" psIndex="0>1|0|0" areaStartIndex="0>1|0|1" areaWitdhIndex="0>1|0|1|0" areaHeightIndex="0>1|0|1|0|0" />
	--	<right rotIndex="0>1|1" rotMin="-40" rotMax="12" psIndex="0>1|1|0" areaStartIndex="0>1|1|1" areaWitdhIndex="0>1|1|1|0" areaHeightIndex="0>1|1|1|0|0" />
	--</sprayer>
	
	self.sprayer = {};
	
	for i,j in pairs( {'left', 'right'} ) do
		
		local rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.moescha.sprayer.%s#rotIndex",j)));		
		local rotMax = math.rad( getXMLFloat(xmlFile, string.format("vehicle.moescha.sprayer.%s#rotMax",j)) );
		local rotMin = -math.rad( getXMLFloat(xmlFile, string.format("vehicle.moescha.sprayer.%s#rotMin",j)) );

		local e = {};
		e.ps = ps;
		e.rotNode = rotNode;
		e.rotMax = rotMax;
		e.rotMin = rotMin;
		e.rotCur = 0;
		e.rotDir = 1;
		--e.area = area;
		table.insert(self.sprayer, e);
		
	end;
	
	
	local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
	self.cuttingAreas = {}
	for i=1, numCuttingAreas do
		self.cuttingAreas[i] = {};
		local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
		self.cuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.cuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
		self.cuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
		self.cuttingAreas[i].foldMinLimit = 0;
		self.cuttingAreas[i].foldMaxLimit = 1;
	end;	
	
	--[[
	self.sprayValves = {};
	if self.isClient then
		local psFile = getXMLString(xmlFile, "vehicle.sprayParticleSystem#file");
		if psFile ~= nil then
			local i=0;
			while true do
				local baseName = string.format("vehicle.sprayValves.sprayValve(%d)", i);
				local node = getXMLString(xmlFile, baseName.. "#index");
				if node == nil then
					break;
				end;
				node = Utils.indexToObject(self.components, node);
				if node ~= nil then
					local sprayValve = {};
					sprayValve.particleSystems = {};
					Utils.loadParticleSystem(xmlFile, sprayValve.particleSystems, "vehicle.sprayParticleSystem", node, false, nil, moddir); --self.baseDirectory);
					--Utils.loadParticleSystem(xmlFile, ps.ps, "vehicle.moescha.sprayer.staticSprayParticleSystem", ps.node, false, "noPS", moddir);

					sprayValve.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMinLimit"), 0);
					sprayValve.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#foldMaxLimit"), 1);

					table.insert(self.sprayValves, sprayValve);
				end;
				i = i+1;
			end;
		end;
	end;
 	for _,sprayValve in pairs(self.sprayValves) do
		for _, v in ipairs(sprayValve.particleSystems) do
			v.originalLifespan = getParticleSystemLifespan(v.geometry);
		end;
	end;
	]]--
	
	-- ! last !
	link( getRootNode(), self.moescha.msh );
	setTranslation( self.moescha.msh, 0, 0, 0 );
	setRotation( self.moescha.msh, 0, 0, 0 );	

	self.forceUpdates = 10;
	
end;

function Moescha:delete()
	if self.moescha.msh ~= nil then
		delete(self.moescha.msh);
	end;	
	--[[for i,v in pairs(self.sprayValves) do
		if v.particleSystems ~= nil then
			print("v.del="..tostring(v.del));		
			if v.del ~= true then
				print("delete");
				Utils.deleteParticleSystem(v.particleSystems);
			end;
		end;
	end;]]--
end;

function Moescha:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Moescha:keyEvent(unicode, sym, modifier, isDown)
end;

function Moescha:update(dt)	

	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then		
			if self.attacherVehicleCopy ~= nil and self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted and self.attacherVehicleCopy.allowsSpraying then 
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
					if self.attacherVehicleCopy.setIsTurnedOn ~= nil then
						if self.attacherVehicleCopy.isTurnedOn == false then
							self.attacherVehicleCopy:setIsTurnedOn(true);
						else
							self.attacherVehicleCopy:setIsTurnedOn(false);
						end;
					end;
				end;
			end;
		end;
	end;

	--###
	if self.isClient then	
		local a = false;
		if self.attacherVehicleCopy ~= nil then 
			if self.attacherVehicleCopy.toolsFillRef ~= nil then
				if self.attacherVehicleCopy.isTurnedOn == true then 
					a = true;
				end
			end;
		end;

		if a == true then
			local fac = 0.004;
			for i=1,2 do
				self.sprayer[i].rotCur = self.sprayer[i].rotCur + dt*fac*self.sprayer[i].rotDir;
				if self.sprayer[i].rotCur > self.sprayer[i].rotMax then
					self.sprayer[i].rotDir = -1;
					self.sprayer[i].rotCur = self.sprayer[i].rotMax;
				elseif self.sprayer[i].rotCur < -self.sprayer[i].rotMin then
					self.sprayer[i].rotDir = 1;
					self.sprayer[i].rotCur = -self.sprayer[i].rotMin;
				end;
				setRotation(self.sprayer[i].rotNode, 0,self.sprayer[i].rotCur,0);
				--setRotation(self.sprayer[i].rotNode, 0,self.sprayer[i].rotCur,0);
			end
		end
	end;
			
	
	--###
	if self.isClient then
		if self:getIsActive() then
			self:updateMesh();
		elseif self.forceUpdates > 0 then
			self:updateMesh();
			self.forceUpdates = self.forceUpdates - 1;
		end;
	end;


end;

function Moescha:updateTick(dt)	
	if self.attacherVehicleCopy ~= nil then
		self.attacherVehicleSteer = self.attacherVehicleCopy;
		while self.attacherVehicleSteer.attacherVehicle ~= nil do
			self.attacherVehicleSteer = self.attacherVehicleSteer.attacherVehicle;
		end;
	end;
end;

function Moescha:draw()
	if self:getIsActive() then
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then		
			if self.attacherVehicleCopy ~= nil and self.attacherVehicleSteer ~= nil and self.attacherVehicleSteer.isMotorStarted and self.attacherVehicleCopy.allowsSpraying then 
				if self.attacherVehicleCopy.isTurnedOn then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.attacherVehicleCopy.typeDesc), InputBinding.IMPLEMENT_EXTRA);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.attacherVehicleCopy.typeDesc), InputBinding.IMPLEMENT_EXTRA);
				end;				
			end;
		end;
	end;
end;


function Moescha:onAttach(attacherVehicle)
	self.attacherVehicleCopy = attacherVehicle;
	if self.attacherVehicleCopy.isTurnedOn  == true then
		self.attacherVehicleCopy:setIsTurnedOn(false);
	end;

	self.attacherVehicleCopy.cuttingAreasBackUp = self.attacherVehicleCopy.cuttingAreas;
	self.attacherVehicleCopy.cuttingAreas = self.cuttingAreas;

	self.attacherVehicleCopy.pressureStateSprayValvesBackUp = self.attacherVehicleCopy.pressureStateSprayValves;
	self.attacherVehicleCopy.pressureStateSprayValves = self.pressureStateSprayValves;
	
	if attacherVehicle.toolsFillRef ~= nil then
		--
		unlink(self.moescha.adapter);
		link( attacherVehicle.toolsFillRef, self.moescha.adapter );
		setTranslation(self.moescha.adapter, 0,0,0);
		if attacherVehicle.stdSprayer ~= nil then
			setVisibility(attacherVehicle.stdSprayer, false);
		end
	end;
end;

function Moescha:onDetach()	
	if self.attacherVehicleCopy ~= nil then
		
		if self.attacherVehicleCopy.isTurnedOn  == true then
			self.attacherVehicleCopy:setIsTurnedOn(false);
		end;			
		
		self.attacherVehicleCopy.cuttingAreas = self.attacherVehicleCopy.cuttingAreasBackUp;
		self.attacherVehicleCopy.pressureStateSprayValves = self.attacherVehicleCopy.pressureStateSprayValvesBackUp;
		
		if self.attacherVehicleCopy.toolsFillRef ~= nil then
			unlink(self.moescha.adapter);
			link( self.rootNode, self.moescha.adapter );
			setTranslation(self.moescha.adapter, self.moescha.adapterPos.x,self.moescha.adapterPos.y,self.moescha.adapterPos.z);
		end;
		if self.attacherVehicleCopy.stdSprayer ~= nil then
			setVisibility(self.attacherVehicleCopy.stdSprayer, true);
		end
	end;
	self.attacherVehicleCopy = nil;
	self.forceUpdates = 10;
end;


function Moescha:updateMesh()	
	--### catmull rom spline
	
	local xc1,yc1,zc1 = getWorldTranslation(self.moescha.ref[1]); 
	local xc2,yc2,zc2 = getWorldTranslation(self.moescha.ref[2]); 
	--local xc3,yc3,zc3 = getWorldTranslation(self.components[3].node); 

	--print("1: x/y/z "..tostring(xc1).."/"..tostring(yc1).."/"..tostring(zc1));
	--print("2: x/y/z "..tostring(xc2).."/"..tostring(yc2).."/"..tostring(zc2));
	
	local x1,y1,z1 = localToWorld( self.moescha.ref[1], 0,-3,0.7 );
	--local d1 	= {x=x1, y=y1, z=z1};
	local x2,y2,z2 = localToWorld( self.moescha.ref[1], 0,-0.1,0 );
	--local d2 	= {x=x2, y=y2, z=z2};
	local x3,y3,z3 = localToWorld( self.moescha.ref[2], 0,0,0.01 );
	--local d3 	= {x=x, y=y, z=z};
	local x4,y4,z4 = localToWorld( self.moescha.ref[2], 0,0, 1 );
	--local d4 	= {x=x, y=y, z=z};	
	
	
	--# 1)
	--local pts = {};
	--table.insert( pts, {x=d1.x,	y=d1.y, z=d1.z} );
	--table.insert( pts, {x=d2.x,	y=d2.y, z=d2.z} ); --xc1,	y=yc1,	z=zc1} ); 
	--table.insert( pts, {x=d3.x,	y=d3.y, z=d3.z} ); --xc2, 	y=yc2,	z=zc2} ); 
	--table.insert( pts, {x=d4.x, y=d4.y,	z=d4.z} );

	--local x,y,z = worldToLocal( self.jntsRef, d1.x,d1.y,d1.z );
	--setTranslation( self.jnts[1], x,y,z );	
	for i=1,9 do 
		local t = (i-1)/8;

		--local xc = 0.5 *((2 * pts[2].x) + (-pts[1].x + pts[3].x) * t + (2*pts[1].x - 5*pts[2].x + 4*pts[3].x - pts[4].x) * t^2 + (-pts[1].x + 3*pts[2].x - 3*pts[3].x + pts[4].x) * t^3);
		--local yc = 0.5 *((2 * pts[2].y) + (-pts[1].y + pts[3].y) * t + (2*pts[1].y - 5*pts[2].y + 4*pts[3].y - pts[4].y) * t^2 + (-pts[1].y + 3*pts[2].y - 3*pts[3].y + pts[4].y) * t^3);
		--local zc = 0.5 *((2 * pts[2].z) + (-pts[1].z + pts[3].z) * t + (2*pts[1].z - 5*pts[2].z + 4*pts[3].z - pts[4].z) * t^2 + (-pts[1].z + 3*pts[2].z - 3*pts[3].z + pts[4].z) * t^3);
		
		local xc = 0.5 *((2 * x2) + (-x1 + x3) * t + (2*x1 - 5*x2 + 4*x3 - x4) * t^2 + (-x1 + 3*x2 - 3*x3 + x4) * t^3);
		local yc = 0.5 *((2 * y2) + (-y1 + y3) * t + (2*y1 - 5*y2 + 4*y3 - y4) * t^2 + (-y1 + 3*y2 - 3*y3 + y4) * t^3);
		local zc = 0.5 *((2 * z2) + (-z1 + z3) * t + (2*z1 - 5*z2 + 4*z3 - z4) * t^2 + (-z1 + 3*z2 - 3*z3 + z4) * t^3);

		local x,y,z = worldToLocal( self.moescha.jnts.root, xc,yc,zc );
		setTranslation( self.moescha.jnts[i], x,y,z );		
		
		--drawDebugPoint( xc,yc,zc, 1,i/9,0,1 );
	end
	
	--# 2)
	for i=1,8 do
		local bx,by,bz = getWorldTranslation(self.moescha.jnts[i+1]);
		local ax,ay,az = getWorldTranslation(self.moescha.jnts[i]);
		local dx,dy,dz = worldDirectionToLocal( self.moescha.jnts.root, bx-ax, by-ay, bz-az );
		setDirection( self.moescha.jnts[i], dx,dy,dz );		
	end
	local bx,by,bz = localToWorld( self.moescha.ref[2], 0,0,1 );
	local ax,ay,az = getWorldTranslation(self.moescha.jnts[9]);
	local dx,dy,dz = worldDirectionToLocal( self.moescha.jnts.root, bx-ax, by-ay, bz-az );
	setDirection( self.moescha.jnts[9], dx,dy,dz );	
end;

