--
-- ManualHydraulics
-- Specialization for ManualHydraulics
--
--	author:	fruktor (www.eifok-team.de)
--

ManualHydraulics = {};

function ManualHydraulics.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function ManualHydraulics:load(xmlFile)
	self.setRotOffsetFirst = SpecializationUtil.callSpecializationsFunction("setRotOffsetFirst");
	self.setRotOffsetSecond = SpecializationUtil.callSpecializationsFunction("setRotOffsetSecond");
	self.updateAttacherJoint = SpecializationUtil.callSpecializationsFunction("updateAttacherJoint");
	
	self.rotOffsetFirst = 0.0;
	self.rotOffsetSecond = 0.0;
	
end;

function ManualHydraulics:delete()
end;

function ManualHydraulics:readStream(streamId, connection)
	local f = streamReadFloat32(streamId);
	local s = streamReadFloat32(streamId);
	self.rotOffsetFirst = f;
	self.rotOffsetSecond = s;
	self.hasBeenAttached = streamReadBool(streamId);
end;

function ManualHydraulics:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.rotOffsetFirst);
	streamWriteFloat32(streamId, self.rotOffsetSecond);
	streamWriteBool(streamId, self.hasBeenAttached);
end;

function ManualHydraulics:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManualHydraulics:keyEvent(unicode, sym, modifier, isDown)
end;

function ManualHydraulics:update(dt)
	
	if self.attacherVehicleJoint ~= nil then
		self.attacherVehicleJoint.allowsLowering = false;
		
		--[[
		if self.hasBeenAttached == true then
			self.attacherVehicleJoint.allowsLowering = true;
			if self.attacherVehicleJoint.moveAlpha == 0 then
				self.hasBeenAttached = false;
				self.attacherVehicleJoint.allowsLowering = false;
			end;
		else ]]--
			if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then	
				if InputBinding.isPressed(InputBinding.MANHYD_fp) then
					self:setRotOffsetFirst( self.rotOffsetFirst + dt/10000 );
				elseif InputBinding.isPressed(InputBinding.MANHYD_fn) then
					self:setRotOffsetFirst( self.rotOffsetFirst - dt/10000 );
				end;
				if InputBinding.isPressed(InputBinding.MANHYD_sp) then
					self:setRotOffsetSecond( self.rotOffsetSecond + dt/10000 );
				elseif InputBinding.isPressed(InputBinding.MANHYD_sn) then
					self:setRotOffsetSecond( self.rotOffsetSecond - dt/10000 );
				end;
			end;
			--self:updateAttacherJoint();
			
			--if self.rotOffsetFirst_toLoad ~= nil and self.rotOffsetSecond_toLoad ~= nil then
			--	self:setRotOffsetFirst( self.rotOffsetFirst_toLoad, true );
			--	self:setRotOffsetSecond( self.rotOffsetSecond_toLoad, true );
			--	self:updateAttacherJoint();
			--end;
		--end;
	end;
	
end;

function ManualHydraulics:updateTick(dt)

	if self.searchAttJoint then
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.attacherVehicle ~= nil then
				for i=1, table.getn(self.attacherVehicle.attacherVehicle.attachedImplements) do
					if self.attacherVehicle.attacherVehicle.attachedImplements[i].object.attachedImplements ~= nil then
						for j, impl in pairs(self.attacherVehicle.attacherVehicle.attachedImplements[i].object.attachedImplements) do
							if impl.object == self then			
								
								local index = self.attacherVehicle.attacherVehicle.attachedImplements[i].jointDescIndex; --.object.attachedImplements[j].jointDescIndex;
								self.attacherVehicleImplement = self.attacherVehicle.attacherVehicle.attachedImplements[i]; --self.attacherVehicle.attacherVehicle.attachedImplements[i].attachedImplements[j];
								self.attacherVehicleJoint = self.attacherVehicle.attacherVehicle.attacherJoints[index]; --attachedImplements[i].object.attacherJoints[index];	
								
								self.hasBeenAttached = true;
								self.attacherVehicleJoint.moveDown = false;			-- !!
								self.attacherVehicleJoint.allowsLowering = true;	
								self.searchAttJoint = false;			
						
								break;					
							end;
						end;
					end;
					if self.attacherVehicleImplement ~= nil then
						break;
					end;
					--[[
					if self.attacherVehicle.attachedImplements[i].object == self then			
						local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
						self.attacherVehicleImplement = self.attacherVehicle.attachedImplements[i];
						self.attacherVehicleJoint = self.attacherVehicle.attacherJoints[index];	
						self.hasBeenAttached = true;
						self.attacherVehicleJoint.moveDown = false;			-- !!
						self.attacherVehicleJoint.allowsLowering = true;	
						self.searchAttJoint = false;				
						break;
					end;
					]]--
				end;
			end;
		end;
	end;

end;

function ManualHydraulics:draw()
	
	g_currentMission:addExtraPrintText( string.format(g_i18n:getText("MANHYD_first"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MANHYD_fp), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MANHYD_fn)) );
	g_currentMission:addExtraPrintText( string.format(g_i18n:getText("MANHYD_second"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MANHYD_sp), InputBinding.getKeyNamesOfDigitalAction(InputBinding.MANHYD_sn)) );
	
end;


function ManualHydraulics:onAttach(attacherVehicle)
	self.searchAttJoint = true;
end;

function ManualHydraulics:onDetach()
	self.attacherVehicleImplement = nil;
	if self.attacherVehicleJoint ~= nil then
		self.attacherVehicleJoint.allowsLowering = true;
		self.attacherVehicleJoint = nil;
	end;
	self.rotOffsetFirst = 0.0;
	self.rotOffsetSecond = 0.0;	
end;

function ManualHydraulics:setRotOffsetFirst(value, noEventSend)
	SetRotOffsetFirstEvent.sendEvent(self, value, noEventSend);
	self.rotOffsetFirst = value;
	self:updateAttacherJoint();
end;

function ManualHydraulics:setRotOffsetSecond(value, noEventSend)
	SetRotOffsetSecondEvent.sendEvent(self, value, noEventSend);
	self.rotOffsetSecond = value;
	self:updateAttacherJoint();
end;

function ManualHydraulics:updateAttacherJoint()
--print("function ManualHydraulics:updateAttacherJoint() "..tostring(self.rotOffsetFirst).." "..tostring(self.rotOffsetSecond));

	local offset = {self.rotOffsetFirst, 0, 0};
	local offset2 = {self.rotOffsetSecond, 0, 0};

	
	local jointDesc = self.attacherVehicleJoint;	
	
	local rotMax = {0, 0, 0};
	local rotMax2 = {0, 0, 0};
	for i=1,3 do 
		rotMax[i] = jointDesc.minRot[i] + offset[i];
		rotMax2[i] = jointDesc.minRot2[i] + offset2[i];
		--print("1: "..tostring(rotMax[i]).." "..tostring(jointDesc.minRot[i]).." "..tostring(offset[i]));
		--print("2: "..tostring(rotMax2[i]).." "..tostring(jointDesc.minRot2[i]).." "..tostring(offset2[i]));
	end;

	if jointDesc.rotationNode ~= nil then
		setRotation(jointDesc.rotationNode, unpack(rotMax)); --Utils.vector3ArrayLerp(rotMax, rotMax, jointDesc.moveAlpha));
	end
	if jointDesc.rotationNode2 ~= nil then
		setRotation(jointDesc.rotationNode2, unpack(rotMax2)); --Utils.vector3ArrayLerp(rotMax2, rotMax2, jointDesc.moveAlpha));
	end
	setJointFrame(jointDesc.jointIndex, 0, jointDesc.jointTransform);
	
	--self.attacherVehicle:updateAttacherJointRotation(jointDesc, self);

	if self.isServer then
		
		for i=1,3 do
			local newRotLimit = Utils.lerp(jointDesc.minRotLimit[i], jointDesc.maxRotLimit[i], 0);--jointDesc.moveAlpha);
			if math.abs(newRotLimit - self.attacherVehicleImplement.jointRotLimit[i]) > 0.0005 then
				setJointRotationLimit(jointDesc.jointIndex, i-1, true, -newRotLimit, newRotLimit);
				self.attacherVehicleImplement.jointRotLimit[i] = newRotLimit;
			end;
		end;		
		for i=1, 3 do
			local newTransLimit = Utils.lerp(jointDesc.minTransLimit[i], jointDesc.maxTransLimit[i],  0);--jointDesc.moveAlpha);
			if math.abs(newTransLimit - self.attacherVehicleImplement.jointTransLimit[i]) > 0.0005 then
				setJointTranslationLimit(jointDesc.jointIndex, i-1, true, -newTransLimit, newTransLimit);
				self.attacherVehicleImplement.jointTransLimit[i] = newTransLimit;
			end;
		end;						
			
	end;
end;


--
--
--	SetRotOffsetFirstEvent
--
--
SetRotOffsetFirstEvent = {};
SetRotOffsetFirstEvent_mt = Class(SetRotOffsetFirstEvent, Event);

InitEventClass(SetRotOffsetFirstEvent, "SetRotOffsetFirstEvent");

function SetRotOffsetFirstEvent:emptyNew()
    local self = Event:new(SetRotOffsetFirstEvent_mt);
    self.className = "SetRotOffsetFirstEvent";
    return self;
end;

function SetRotOffsetFirstEvent:new(object, state)
    local self = SetRotOffsetFirstEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetRotOffsetFirstEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetRotOffsetFirstEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.state);
end;

function SetRotOffsetFirstEvent:run(connection)
	self.object:setRotOffsetFirst(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRotOffsetFirstEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetRotOffsetFirstEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRotOffsetFirstEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRotOffsetFirstEvent:new(vehicle, state));
		end;
	end;
end;


--
--
--	SetRotOffsetSecondEvent
--
--
SetRotOffsetSecondEvent = {};
SetRotOffsetSecondEvent_mt = Class(SetRotOffsetSecondEvent, Event);

InitEventClass(SetRotOffsetSecondEvent, "SetRotOffsetSecondEvent");

function SetRotOffsetSecondEvent:emptyNew()
    local self = Event:new(SetRotOffsetSecondEvent_mt);
    self.className = "SetRotOffsetSecondEvent";
    return self;
end;

function SetRotOffsetSecondEvent:new(object, state)
    local self = SetRotOffsetSecondEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetRotOffsetSecondEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetRotOffsetSecondEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.state);
end;

function SetRotOffsetSecondEvent:run(connection)
	self.object:setRotOffsetSecond(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetRotOffsetSecondEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetRotOffsetSecondEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRotOffsetSecondEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRotOffsetSecondEvent:new(vehicle, state));
		end;
	end;
end;