Hose_SetVehicleAndRefIdxEvent = {};
Hose_SetVehicleAndRefIdxEvent_mt = Class(Hose_SetVehicleAndRefIdxEvent, Event);

InitEventClass(Hose_SetVehicleAndRefIdxEvent, "Hose_SetVehicleAndRefIdxEvent");

function Hose_SetVehicleAndRefIdxEvent:emptyNew()
    local self = Event:new(Hose_SetVehicleAndRefIdxEvent_mt);
    self.className="Hose_SetVehicleAndRefIdxEvent";
    return self;
end;

function Hose_SetVehicleAndRefIdxEvent:new(vehicle, veh, rId)
    local self = Hose_SetVehicleAndRefIdxEvent:emptyNew()
    self.vehicle = vehicle;
	self.veh = veh;
	self.rId = rId;
	return self;
end;

function Hose_SetVehicleAndRefIdxEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    local id2 = streamReadInt32(streamId);
	if id2 ~= 0 then
		self.veh = networkGetObject(id2);
	else
		self.veh = 0;
	end;
	self.rId = streamReadInt32(streamId);
    self:run(connection);
end;

function Hose_SetVehicleAndRefIdxEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	if self.veh ~= 0 then
		streamWriteInt32(streamId, networkGetObjectId(self.veh));	
	else
		streamWriteInt32(streamId, 0);	
	end;
	streamWriteInt32(streamId, self.rId);
end;

function Hose_SetVehicleAndRefIdxEvent:run(connection)
	self.vehicle:setVehicleAndHoseRefIdxInRange(self.veh, self.rId, true);
	if not connection:getIsServer() then			
		g_server:broadcastEvent(Hose_SetVehicleAndRefIdxEvent:new(self.vehicle, self.veh, self.rId), nil, connection, self.vehicle);
	end;
end;


function Hose_SetVehicleAndRefIdxEvent.sendEvent(vehicle, veh, rId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetVehicleAndRefIdxEvent:new(vehicle, veh, rId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetVehicleAndRefIdxEvent:new(vehicle, veh, rId));
		end;
	end;
end;