Hose_SetReleaseEvent = {};
Hose_SetReleaseEvent_mt = Class(Hose_SetReleaseEvent, Event);

InitEventClass(Hose_SetReleaseEvent, "Hose_SetReleaseEvent");

function Hose_SetReleaseEvent:emptyNew()
    local self = Event:new(Hose_SetReleaseEvent_mt);
    self.className="Hose_SetReleaseEvent";
    return self;
end;

function Hose_SetReleaseEvent:new(vehicle, veh, sId, refId)
    local self = Hose_SetReleaseEvent:emptyNew()
    self.vehicle = vehicle;
	self.veh = veh;
	self.sId = sId;
	self.refId = refId;
	return self;
end;

function Hose_SetReleaseEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    local id2 = streamReadInt32(streamId);
	self.veh = networkGetObject(id2);
	self.sId = streamReadInt32(streamId);
	self.refId = streamReadInt32(streamId);
    self:run(connection);
end;

function Hose_SetReleaseEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, networkGetObjectId(self.veh));
	streamWriteInt32(streamId, self.sId);
	streamWriteInt32(streamId, self.refId);
end;

function Hose_SetReleaseEvent:run(connection)
	self.vehicle:setRelease(self.veh, self.sId, self.refId, true);
	if not connection:getIsServer() then			
		g_server:broadcastEvent(Hose_SetReleaseEvent:new(self.vehicle, self.veh, self.sId, self.refId), nil, connection, self.vehicle);
	end;
end;


function Hose_SetReleaseEvent.sendEvent(vehicle, veh, sId, refId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetReleaseEvent:new(vehicle, veh, sId, refId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetReleaseEvent:new(vehicle, veh, sId, refId));
		end;
	end;
end;