Hose_SetAttachStationEvent = {};
Hose_SetAttachStationEvent_mt = Class(Hose_SetAttachStationEvent, Event);

InitEventClass(Hose_SetAttachStationEvent, "Hose_SetAttachStationEvent");

function Hose_SetAttachStationEvent:emptyNew()
    local self = Event:new(Hose_SetAttachStationEvent_mt);
    self.className="Hose_SetAttachStationEvent";
    return self;
end;

function Hose_SetAttachStationEvent:new(vehicle, station, sId)
    local self = Hose_SetAttachStationEvent:emptyNew()
    self.vehicle = vehicle;
	self.station = station;
	self.sId = sId;
	return self;
end;

function Hose_SetAttachStationEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
    local id2 = streamReadInt32(streamId);
	self.station = networkGetObject(id2);
	self.sId = streamReadInt32(streamId);
    self:run(connection);
end;

function Hose_SetAttachStationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt32(streamId, networkGetObjectId(self.station));
	streamWriteInt32(streamId, self.sId);
end;

function Hose_SetAttachStationEvent:run(connection)
	self.vehicle:setAttachStation(self.station, self.sId, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(Hose_SetAttachStationEvent:new(self.vehicle, self.station, self.sId), nil, connection, self.vehicle);
	end;
end;

function Hose_SetAttachStationEvent.sendEvent(vehicle, station, sId, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Hose_SetAttachStationEvent:new(vehicle, station, sId), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Hose_SetAttachStationEvent:new(vehicle, station, sId));
		end;
	end;
end;