--
--
local moddir = g_currentModDirectory;

FrontDock = {};

function FrontDock:printTable( _tbl, _str, _dpth, _mdpth )
	if _dpth >= _mdpth then
		return;
	end;
	for i,j in pairs( _tbl ) do
		print(_dpth.._str.." "..tostring(i).." "..tostring(j));
		if string.match( type(j), "table" ) then
			self:printTable(j, _str.." >", _dpth+1, _mdpth);
		end
	end
end;

function FrontDock.prerequisitesPresent(specializations)
    Vehicle.registerJointType("FastCoupling");
	return true;
end;

function FrontDock:load(xmlFile)
	self.printTable = FrontDock.printTable;
	self.updateMesh_f = FrontDock.updateMesh_f;
	self.updateMesh_b = FrontDock.updateMesh_b;
	
	self.attacherJoint.jointType = Vehicle.JOINTTYPE_FASTCOUPLING;

	--[[
	<frontDock>
		<arm index="" minRot="" maxRot="" rotSpeed="" jntIdx1="2" jntIdx2="3" />
		<meshArm index="0>11" />
		<meshFront index="0>9|0|1" jntRoot="0>9|0|0" jntCount="6"/>
		<meshBack index="0>9|2|1" jntRoot="0>9|2|0" jntCount="8" refNode="0>9|3|0|0" />
		<partTrailer index="0>9|3|0" />
		<partVehicle index="0>9|1|0" indexPush="0>9|1|0|0" indexRef="0>9|1|0|0|0" />
	</frontDock>	
	]]--
	
	self.isFrontDock = true;
	
	self.arm = {};
	self.arm.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.arm#index"));
	self.arm.rotDown = math.rad( getXMLFloat(xmlFile, "vehicle.frontDock.arm#rotDown") );
	self.arm.rotUp = math.rad( getXMLFloat(xmlFile, "vehicle.frontDock.arm#rotUp") );
	self.arm.targetRot = 0;
	self.arm.curRot = 0;
	self.arm.rotSpeed = getXMLFloat(xmlFile, "vehicle.frontDock.arm#rotSpeed");
	self.arm.dynRotSpeed = self.arm.rotSpeed/60;
	self.arm.jntIdcs = {};
	local r=1;
	while true do
		local idx = getXMLInt(xmlFile, string.format("vehicle.frontDock.arm#jointIndex%d", r));
		if idx == nil then
			break;
		end;
		table.insert(self.arm.jntIdcs, idx);
		r=r+1;
	end
	self.setArmRot = SpecializationUtil.callSpecializationsFunction("setArmRot");
	
	self.mshA = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshArm#index"));
	
	self.mshF = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshFront#index"));
	self.jntsF = {};
	self.jntsFroot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshFront#jntRoot"));
	local c = getXMLInt(xmlFile, "vehicle.frontDock.meshFront#jntCount");
	for i=1,c do 
		local n = getChildAt(self.jntsFroot, i-1);
		table.insert(self.jntsF, n);
	end;
	self.jntsFcnt = table.getn(self.jntsF);
	self.mshFtarget = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshFront#indexTarget"));
	self.refMshF = nil; 
	self.distF = 0;
	self.lastdxF = 0;
	
	self.mshB = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshBack#index"));
	self.jntsB = {};
	self.jntsBroot = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshBack#jntRoot"));
	local c = getXMLInt(xmlFile, "vehicle.frontDock.meshBack#jntCount");
	for i=1,c do 
		local n = getChildAt(self.jntsBroot, i-1);
		table.insert(self.jntsB, n);
	end;
	self.jntsBcnt = table.getn(self.jntsB);
	self.refMshB = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.meshBack#refNode"));
	self.distB = 0;
	self.lastdxB = 0;
	
	self.partT = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.partTrailer#index"));
	self.partTp = getParent(self.partT);
	--self.refPartT = nil; -- always nil
	
	self.partV = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.partVehicle#index"));
	self.partVnewpos = {};
	self.partVroot = getParent(self.partV);
	self.partVp = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.partVehicle#indexPush"));
	self.partVr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontDock.partVehicle#indexRef"));
	local bx,by,bz = getWorldTranslation(self.partVr);
	local ax,ay,az = getWorldTranslation(self.partV);
	self.partVl = Utils.vector3Length( bx-ax, by-ay, bz-az );
	self.partVpOrigPos = { getTranslation(self.partVp); };
	self.refPartV = nil;
	
	self.attVeh = nil;
	self.attVehImplCnt = 0;
	
	-- ! last !
	link( getRootNode(), self.mshA );
	setTranslation( self.mshA, 0, 0, 0 );
	setRotation( self.mshA, 0, 0, 0 );		

	link( getRootNode(), self.mshF );
	setTranslation( self.mshF, 0, 0, 0 );
	setRotation( self.mshF, 0, 0, 0 );		

	link( getRootNode(), self.mshB );
	setTranslation( self.mshB, 0, 0, 0 );
	setRotation( self.mshB, 0, 0, 0 );		
	
	
	--set hoses invisible!
	setVisibility( self.mshA, false );
	setVisibility( self.mshF, false );
	setVisibility( self.mshB, false );
	setVisibility( self.partV, false );	
	setVisibility( self.partT, false );
	
	--# cylinder sound
	self.cylinderedHydraulicSoundEnabled2 = false;			
	self.playCylSound = false;
	
end;

function FrontDock:delete()
	if self.mshA ~= nil then
		delete(self.mshA);
	end;	
	if self.mshF ~= nil then
		delete(self.mshF);
	end;	
	if self.mshB ~= nil then
		delete(self.mshB);
	end;	
end;

function FrontDock:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FrontDock:keyEvent(unicode, sym, modifier, isDown)
end;

function FrontDock:update(dt)	

	
	--#
	self.arm.dynRotSpeed = math.max(0, self.arm.dynRotSpeed - self.arm.rotSpeed/300);
	
	if self.attVehSteer ~= nil and self.attVehSteer.isMotorStarted and self:getIsActive() then 		
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			local inp = false;
			if InputBinding.isPressed(InputBinding.FRONTDOCK_ARM_UP) then
				local nv = math.max( self.arm.rotUp, self.arm.curRot - dt*self.arm.dynRotSpeed );
				self:setArmRot(nv);
				inp = true;
			elseif InputBinding.isPressed(InputBinding.FRONTDOCK_ARM_DOWN) then
				local nv = math.min( self.arm.rotDown, self.arm.curRot + dt*self.arm.dynRotSpeed );
				self:setArmRot(nv);
				inp = true;
			end;
			if inp then 
				self.arm.dynRotSpeed = math.min(self.arm.rotSpeed, self.arm.dynRotSpeed + 2*self.arm.rotSpeed/300);
			else
				self.arm.dynRotSpeed = 0;
			end;			
		end;		
	end;
	
	if self.arm.curRot == self.arm.rotDown then
		self.allowsDetaching = true;
	else
		self.allowsDetaching = false;
	end;


	--#
	if self.attTraJnt ~= nil and self.attVehJnt ~= nil then 
		
		if self.partVnewpos ~= nil then
			local wx,wy,wz = localToWorld( self.attTraJnt.jointTransform, unpack(self.partVnewpos));
			local lx,ly,lz = worldToLocal( getParent(self.partV),  wx,wy,wz);
			
			setTranslation( self.partV, lx,ly,lz );
		
		end;
		
		local bx,by,bz = getWorldTranslation(self.refMshF);
		local ax,ay,az = getWorldTranslation(self.partV);
		local dist = Utils.vector3Length( bx-ax, by-ay, bz-az );
		local dx,dy,dz = worldDirectionToLocal( getParent(self.partV), bx-ax, by-ay, bz-az );
		setDirection( self.partV, dx,dy,dz, 0,1,0 );
		setTranslation( self.partVp, 0,0,self.partVpOrigPos[3]+(dist-self.partVl) );
		--[[
		for i,impl in pairs(self.attVehSteer.attachedImplements) do
			if impl.object == self.attTra then		
				local jointDesc = self.attVehSteer.attacherJoints[impl.jointDescIndex];
				self.attTraJnt = jointDesc;
				local x,y,z = getWorldTranslation( self.attVehSteer.attacherJoints[impl.jointDescIndex].jointTransform );
				local lx,ly,lz = worldToLocal( getParent(self.partV), x, y, z );
				setTranslation( self.partV, lx, ly-0.2, lz+1.5 );
				
				local bx,by,bz = getWorldTranslation(self.refMshF);
				local ax,ay,az = getWorldTranslation(self.partV);				
				local dx,dy,dz = worldDirectionToLocal( getParent(self.partV), bx-ax, by-ay, bz-az );
				setDirection( self.partV, dx,dy,dz, 0,1,0 );
				setTranslation( self.partVp, 0,0,self.partVpOrigPos[3]+(dist-self.partVl) );
			end;
		end;
		]]--
	end;

	--###	
	if self.isClient then
		if self.refMshF ~= nil then
			self:updateMesh_f();
			self:updateMesh_b();		
		end;
	end;
	

	--###
	if self.isClient then
		if self.playCylSound == true and self.cylinderedHydraulicSoundEnabled2 == false and self:getIsActiveForSound() then
			playSample(self.cylinderedHydraulicSound, 0, self.cylinderedHydraulicSoundVolume, 0);
			self.cylinderedHydraulicSoundEnabled2 = true;
		else
			if self.playCylSound == false and self.cylinderedHydraulicSoundEnabled2 then 
				stopSample(self.cylinderedHydraulicSound);
				self.cylinderedHydraulicSoundEnabled2 = false;
			end;
		end;		
		self.playCylSound = false;				-- ?
	end		

	if self.attacherVehicle ~= nil then
		self.attacherVehicle.allowsDetaching = false;
	end;

end;

function FrontDock:updateTick(dt)	

	if self.attVehSteer ~= nil then
		while self.attVehSteer.attacherVehicle ~= nil do
			if SpecializationUtil.hasSpecialization(Steerable, self.attVehSteer.attacherVehicle.specializations) then
				self.attVehSteer = self.attVehSteer.attacherVehicle;
			end;
		end;
	end;
	
	--#
	local changed = false;
	if self.attVehSteer ~= nil then
		local cnt = table.getn(self.attVehSteer.attachedImplements);
		if cnt ~= self.attVehImplCnt then
			self.attVehImplCnt = cnt;
			self.attTra = nil;
			self.attTraJnt = nil;
			self.attVehJnt = nil;
			--self.refMshF = nil;			
			setVisibility( self.mshA, false );
			setVisibility( self.mshF, false );
			setVisibility( self.mshB, false );
			setVisibility( self.partV, false );
			setVisibility( self.partT, false );						
			changed = true;
		end;
	end;
	if self.justAttached == true then
		changed = true;
		self.justAttached = false;
	end;
	if self.justDettached == true then
		changed = true;
		self.justDettached = false;
	end;
	
	if true then --and changed then
		if self.attVehSteer ~= nil then
			
			if getParent(self.partT) == self.partTp then
				
				for i,impl in pairs(self.attVehSteer.attachedImplements) do
					if impl.object.hoseRef ~= nil then
						for k,ref in pairs(impl.object.hoseRef.refs) do
							if string.match(ref.rt, 'dock') then
								self.attTra = impl.object;
								
								--unlink(self.partT);
								--link(ref.node, self.partT);
								--setTranslation(self.partT, 0,0,0);
								--setRotation(self.partT, 0,0,0);								
								
								local wx,wy,wz = getWorldTranslation(ref.node);
								local lx,ly,lz = worldToLocal( getParent(self.partT), wx,wy,wz);
								setTranslation(self.partT, lx,ly,lz);
								
								local wrx,wry,wrz = localDirectionToWorld( ref.node, 0,0,1 );
								local  rx, ry, rz = worldDirectionToLocal( getParent(self.partT), wrx,wry,wrz);
								setDirection(self.partT, rx,ry,rz, 0,1,0 );
								
								self.forceMeshUpdate = true;
								
								break;
							end;
						end;
					end;

				end;
				
			end;
			
		end;

		if self.attTra ~= nil and self.attVehSteer ~= nil then
		
		
			if self.refMshF == nil then
		
				-- part under vehicle, front ref
				
				if getParent(self.refMshF) ~= self.attVehSteer.components[1].node then
				
					for i,impl in pairs(self.attVehSteer.attachedImplements) do
						if self.attVehSteer.attachedImplements[i].object.attachedImplements ~= nil then
							for k,impl2 in pairs(self.attVehSteer.attachedImplements[i].object.attachedImplements) do
								if impl2.object == self then
									local jointDesc = self.attVehSteer.attacherJoints[impl.jointDescIndex];
									self.attVehJnt = jointDesc;
									local x,y,z = getWorldTranslation( self.attVehSteer.attacherJoints[impl.jointDescIndex].jointTransform );
									local lx,ly,lz = worldToLocal( self.attVehSteer.components[1].node, x, y, z );
									self.refMshF = createTransformGroup('tmp');
									
									link( self.attVehSteer.components[1].node, self.refMshF );
									setTranslation( self.refMshF, lx, ly-0.4, lz-0.6 ) ; --ly-0.2, lz-0.6 );
									setRotation( self.refMshF, 0,0,0 );
									
									--local wx,wy,wz = localToWorld( self.attVehSteer.attacherJoints[impl.jointDescIndex].jointTransform, 0, -0.4, -0.6 );
									--local lx,ly,lz = worldToLocal( self.attVehSteer.components[1].node, wx,wy,wz );									
									--setTranslation( self.refMshF, lx, ly,lz ) ;
									--setRotation( self.refMshF, 0,0,0 );
									
									break;
								end;
							end;
						end;
						if self.refMshF ~= nil then
							break;
						end;
					end;
					
				end;
				
				setVisibility( self.mshF, true );
				setVisibility( self.mshA, true );
				setVisibility( self.mshB, true );
				setVisibility( self.partT, true );																
				setVisibility( self.partV, true );			
				
				-- part under vehicle, back ref
				
				for i,impl in pairs(self.attVehSteer.attachedImplements) do
					--for j,impl2 in pairs(impl.object.attachedImplements) do
						if impl.object == self.attTra then
							local jointDesc = self.attVehSteer.attacherJoints[impl.jointDescIndex];
							self.attTraJnt = jointDesc;
							--local x,y,z = getWorldTranslation( self.attVehSteer.attacherJoints[impl.jointDescIndex].jointTransform );
							
							--local x,y,z = localToWorld( self.attTraJnt.jointTransform, 0, -0.2, 1.5 );
							local x,y,z = localToWorld( self.attTraJnt.jointTransform, -1.5, 0.2, 0 );
							local lx,ly,lz = worldToLocal( self.attTraJnt.jointTransform, x, y, z );
							self.partVnewpos = {lx,ly,lz};
							
							--local wx,wy,wz = localToWorld( self.refMshF, 0, 0, 0 );
							--local lx,ly,lz = worldToLocal( self.attTraJnt.jointTransform, wx, wy, wz );
							--self.partVnewpos[2] = ly;
							
							
							--local lx,ly,lz = worldToLocal( getParent(self.partV), x, y, z );
							--setTranslation( self.partV, lx, ly-0.2, lz+1.5 );
													
							--local dx,dy,dz = localDirectionToWorld( self.attVehSteer.components[1].node, 0,0,1);
							--local ldx,ldy,ldz = worldDirectionToLocal( getParent(self.partV), dx, dy, dz );
							----setRotation( self.partV, 0,0,0 );
							--setDirection( self.partV, ldx,ldy,ldz );
							
							----print("lx/y/z="..tostring(lx).." "..tostring(ly).." "..tostring(lz));
							----print("lx/y/z="..tostring(ldx).." "..tostring(ldy).." "..tostring(ldz));
							
							----unlink( self.partVp );						
							----link( self.partV, self.partVp );
							--setTranslation( self.partVp, 0,0,self.partVpOrigPos[3] );
							--setRotation( self.partVp, 0,0,0 );
							break;
						end;
					--end;
				end;	
				
			end;		
		
		else
			
			local p = getParent(self.partT);
			if p ~= self.partTp then
				--unlink(self.partT);
				--link(self.partTp, self.partT);
				setTranslation(self.partT, 0,0,0);
				setRotation(self.partT, 0,0,0);
			end;	
			--local p = getParent(self.partV);
			if self.refMshF ~= nil then --self.partVroot then
				--unlink(self.partV);
				--link(self.partVroot, self.partV);
				setTranslation( self.partV, 0,0,0 );
				setRotation( self.partV, 0,0,0 );
				
				--unlink( self.partVp );						
				--link( self.partVroot, self.partVp );
				setTranslation( self.partVp, 0,0,0 );
				setRotation( self.partVp, 0,0,0 );
				
				unlink(self.refMshF);
				delete(self.refMshF);
				self.refMshF = nil;
			end;	
			
		end;
		
	end;
	
end;

function FrontDock:draw()
	if self.attVehSteer ~= nil and self.attVehSteer.isMotorStarted and self:getIsActive() then 		
		if self.isClient and self:getIsActiveForInput(true) and not self:hasInputConflictWithSelection() then
			g_currentMission:addExtraPrintText( string.format(g_i18n:getText("FRONTDOCK_MOVE"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.FRONTDOCK_ARM_UP), InputBinding.getKeyNamesOfDigitalAction(InputBinding.FRONTDOCK_ARM_DOWN)) );
		end;
	end;
end;


function FrontDock:onAttach(attacherVehicle)
	self.attVeh = attacherVehicle;	
	if attacherVehicle.attacherVehicle ~= nil then
		if SpecializationUtil.hasSpecialization(Steerable, attacherVehicle.attacherVehicle.specializations) then
			self.attVehSteer = attacherVehicle.attacherVehicle;
		end;
	end;
	self.justAttached = true;
end;

function FrontDock:onDetach()
	setVisibility( self.mshA, false );
	setVisibility( self.mshF, false );
	setVisibility( self.mshB, false );
	setVisibility( self.partV, false );
	setVisibility( self.partT, false );

	self.attVeh.allowsDetaching = true;	
	self.attVeh = nil;
	self.attVehSteer = nil;
	self.attTra = nil;
	self.attTraJnt = nil;
	self.attVehJnt = nil;
	--self.refMshF = nil;
	self.attVehImplCnt = 0;
	self.justDettached = true;
end;


function FrontDock:updateMesh_b()	
	
	local x1,y1,z1 = localToWorld( self.refMshB, 0,1,-1 );
	local x2,y2,z2 = localToWorld( self.refMshB, 0,0.07,0 );
	local x3,y3,z3 = localToWorld( self.partV, 0,0.07,0);
	local x4,y4,z4 = localToWorld( self.partV, 0,1,1 );
	
	local dist = Utils.vector3Length( x3-x2, y3-y2, z3-z2 );
	local dx,dy,dz = worldDirectionToLocal( self.jntsBroot, x2-x3,y2-y3,z2-z3 );
	--print(math.abs(self.distB - dist).."  "..math.abs(self.lastdxB - dx));
	
	if (math.abs(self.distB - dist) > 0.0001 or math.abs(self.lastdxB - dx) > 0.0001) or self.forceMeshUpdate == true then 
		self.distB = dist;
		self.lastdxB = dx;
		self.forceMeshUpdate = false;
		--print("+b");	

		--# 1)
		for i=1,self.jntsBcnt do 
			local t = (i-1)/(self.jntsBcnt-1);
			--local xc = 0.5 *((2 * pts[2].x) + (-pts[1].x + pts[3].x) * t + (2*pts[1].x - 5*pts[2].x + 4*pts[3].x - pts[4].x) * t^2 + (-pts[1].x + 3*pts[2].x - 3*pts[3].x + pts[4].x) * t^3);
			--local yc = 0.5 *((2 * pts[2].y) + (-pts[1].y + pts[3].y) * t + (2*pts[1].y - 5*pts[2].y + 4*pts[3].y - pts[4].y) * t^2 + (-pts[1].y + 3*pts[2].y - 3*pts[3].y + pts[4].y) * t^3);
			--local zc = 0.5 *((2 * pts[2].z) + (-pts[1].z + pts[3].z) * t + (2*pts[1].z - 5*pts[2].z + 4*pts[3].z - pts[4].z) * t^2 + (-pts[1].z + 3*pts[2].z - 3*pts[3].z + pts[4].z) * t^3);
			local xc = 0.5 *((2 * x2) + (-x1 + x3) * t + (2*x1 - 5*x2 + 4*x3 - x4) * t^2 + (-x1 + 3*x2 - 3*x3 + x4) * t^3);
			local yc = 0.5 *((2 * y2) + (-y1 + y3) * t + (2*y1 - 5*y2 + 4*y3 - y4) * t^2 + (-y1 + 3*y2 - 3*y3 + y4) * t^3);
			local zc = 0.5 *((2 * z2) + (-z1 + z3) * t + (2*z1 - 5*z2 + 4*z3 - z4) * t^2 + (-z1 + 3*z2 - 3*z3 + z4) * t^3);
				
			--local x,y,z = worldToLocal( self.jntsF[i], xc,yc,zc );
			local x,y,z = worldToLocal( self.jntsBroot, xc,yc,zc );
			setTranslation( self.jntsB[i], x,y,z );		
			
			--drawDebugPoint( xc,yc,zc, 1,i/9,0,1 );
		end
		
		--# 2)
		local wx,wy,wz = localToWorld( self.refMshB, 0,0,1 );
		local dx,dy,dz = worldDirectionToLocal( self.jntsBroot, wx-x2,wy-y2,wz-z2 );
		setDirection( self.jntsB[1], dx,dy,dz, 0,1,0 );
		
		for i=2,self.jntsBcnt-1 do
			local bx,by,bz = getWorldTranslation(self.jntsB[i+1]);
			local ax,ay,az = getWorldTranslation(self.jntsB[i]);
			local dx,dy,dz = worldDirectionToLocal( self.jntsBroot, bx-ax, by-ay, bz-az );
			setDirection( self.jntsB[i], dx,dy,dz, 0,1,0 );		
		end
		
		local wx,wy,wz = localToWorld( self.partV, 0,0,1 );
		local dx,dy,dz = worldDirectionToLocal( self.jntsBroot, wx-x3,wy-y3,wz-z3 );
		setDirection( self.jntsB[self.jntsBcnt], dx,dy,dz, 0,1,0 );	
		
	else
		--print("-b");
	end;
	
end;


function FrontDock:updateMesh_f()	
	
	local x1,y1,z1 = localToWorld( self.partVr, 0,0,-0.2 );
	--local d1 	= {x=x1, y=y1, z=z1};
	local x2,y2,z2 = localToWorld( self.partVr, 0,0,0 );
	--local d2 	= {x=x2, y=y2, z=z2};
	local x3,y3,z3 = localToWorld( self.mshFtarget, 0,0,0 );
	--local d3 	= {x=x3, y=y3, z=z3};
	local x4,y4,z4 = localToWorld( self.mshFtarget, 0,0,0.2 );
	--local d4 	= {x=x4, y=y4, z=z4};	

	local dist = Utils.vector3Length( x3-x2, y3-y2, z3-z2 );
	if math.abs(self.distF - dist) > 0.0001 then 
		self.distF = dist;
		
		--# 1)
		--local pts = {};
		--table.insert( pts, {x=d1.x,	y=d1.y, z=d1.z} );
		--table.insert( pts, {x=d2.x,	y=d2.y, z=d2.z} ); 
		--table.insert( pts, {x=d3.x,	y=d3.y, z=d3.z} );  
		--table.insert( pts, {x=d4.x, y=d4.y,	z=d4.z} );

		--local x,y,z = worldToLocal( self.jntsRef, d1.x,d1.y,d1.z );
		--setTranslation( self.jnts[1], x,y,z );	
		
		for i=1,self.jntsFcnt do 
			local t = (i-1)/(self.jntsFcnt-1);
			--local xc = 0.5 *((2 * pts[2].x) + (-pts[1].x + pts[3].x) * t + (2*pts[1].x - 5*pts[2].x + 4*pts[3].x - pts[4].x) * t^2 + (-pts[1].x + 3*pts[2].x - 3*pts[3].x + pts[4].x) * t^3);
			--local yc = 0.5 *((2 * pts[2].y) + (-pts[1].y + pts[3].y) * t + (2*pts[1].y - 5*pts[2].y + 4*pts[3].y - pts[4].y) * t^2 + (-pts[1].y + 3*pts[2].y - 3*pts[3].y + pts[4].y) * t^3);
			--local zc = 0.5 *((2 * pts[2].z) + (-pts[1].z + pts[3].z) * t + (2*pts[1].z - 5*pts[2].z + 4*pts[3].z - pts[4].z) * t^2 + (-pts[1].z + 3*pts[2].z - 3*pts[3].z + pts[4].z) * t^3);
			local xc = 0.5 *((2 * x2) + (-x1 + x3) * t + (2*x1 - 5*x2 + 4*x3 - x4) * t^2 + (-x1 + 3*x2 - 3*x3 + x4) * t^3);
			local yc = 0.5 *((2 * y2) + (-y1 + y3) * t + (2*y1 - 5*y2 + 4*y3 - y4) * t^2 + (-y1 + 3*y2 - 3*y3 + y4) * t^3);
			local zc = 0.5 *((2 * z2) + (-z1 + z3) * t + (2*z1 - 5*z2 + 4*z3 - z4) * t^2 + (-z1 + 3*z2 - 3*z3 + z4) * t^3);
			
			--local x,y,z = worldToLocal( self.jntsF[i], xc,yc,zc );
			local x,y,z = worldToLocal( self.jntsFroot, xc,yc,zc );
			setTranslation( self.jntsF[i], x,y,z );		
			
			--drawDebugPoint( xc,yc,zc, 1,i/9,0,1 );
		end
		
		--# 2)
		local wx,wy,wz = localToWorld( self.refMshF, 0,0,1 );
		local dx,dy,dz = worldDirectionToLocal( self.jntsFroot, wx-x2,wy-y2,wz-z2 );
		setDirection( self.jntsF[1], dx,dy,dz, 0,1,0 );
		
		for i=2,self.jntsFcnt-1 do
			local bx,by,bz = getWorldTranslation(self.jntsF[i+1]);
			local ax,ay,az = getWorldTranslation(self.jntsF[i]);
			local dx,dy,dz = worldDirectionToLocal( self.jntsFroot, bx-ax, by-ay, bz-az );
			setDirection( self.jntsF[i], dx,dy,dz, 0,1,0 );		
		end
		
		local wx,wy,wz = localToWorld( self.mshFtarget, 0,0,1 );
		local dx,dy,dz = worldDirectionToLocal( self.jntsFroot, wx-x3,wy-y3,wz-z3 );
		setDirection( self.jntsF[self.jntsFcnt], dx,dy,dz, 0,1,0 );	
		
	end;

end;

function FrontDock:setArmRot(rot, noEventSend)
	SetArmRotEvent.sendEvent(self, rot, noEventSend);
	self.arm.targetRot = rot;

	
	if self.arm.targetRot ~= self.arm.curRot then 
		self.arm.curRot = self.arm.targetRot;
		if self.isClient then
			setRotation(self.arm.node, self.arm.curRot,0,0 );
			self.playCylSound = true;
		end;
		if self.isServer then
			--for i,idx in pairs(self.arm.jntIdcs) do
				setJointFrame( self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode );
				setJointFrame( self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode );
			--end
		end;
	end;	
end;


--
--
--
--
--
SetArmRotEvent = {};
SetArmRotEvent_mt = Class(SetArmRotEvent, Event);

InitEventClass(SetArmRotEvent, "SetArmRotEvent");

function SetArmRotEvent:emptyNew()
    local self = Event:new(SetArmRotEvent_mt);
    self.className="SetArmRotEvent";
    return self;
end;

function SetArmRotEvent:new(vehicle, rot)
    local self = SetArmRotEvent:emptyNew()
    self.vehicle = vehicle;
	self.rot = rot;
	return self;
end;

function SetArmRotEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.rot = streamReadFloat32(streamId);
    self:run(connection);
end;

function SetArmRotEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteFloat32(streamId, self.rot);
end;

function SetArmRotEvent:run(connection)
	self.vehicle:setArmRot(self.rot, true);
	if not connection:getIsServer() then				
		g_server:broadcastEvent(SetArmRotEvent:new(self.vehicle, self.rot), nil, connection, self.vehicle);
	end;
end;


function SetArmRotEvent.sendEvent(vehicle, rot, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmRotEvent:new(vehicle, rot), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmRotEvent:new(vehicle, rot));
		end;
	end;
end;
