UnloadAP730Event = {};
UnloadAP730Event_mt = Class(UnloadAP730Event, Event);

InitEventClass(UnloadAP730Event, "UnloadAP730Event");

function UnloadAP730Event:emptyNew()
    local self = Event:new(UnloadAP730Event_mt);
    self.className="UnloadAP730Event";
    return self;
end;

function UnloadAP730Event:new(vehicle, mode)
    local self = UnloadAP730Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function UnloadAP730Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function UnloadAP730Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function UnloadAP730Event:run(connection)
	self.vehicle:UnloadAP730(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(UnloadAP730Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function UnloadAP730Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(UnloadAP730Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(UnloadAP730Event:new(vehicle, mode));
		end;
	end;
end;