EmptyAP730Event = {};
EmptyAP730Event_mt = Class(EmptyAP730Event, Event);

InitEventClass(EmptyAP730Event, "EmptyAP730Event");

function EmptyAP730Event:emptyNew()
    local self = Event:new(EmptyAP730Event_mt);
    self.className="EmptyAP730Event";
    return self;
end;

function EmptyAP730Event:new(vehicle, mode)
    local self = EmptyAP730Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function EmptyAP730Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function EmptyAP730Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function EmptyAP730Event:run(connection)
	self.vehicle:EmptyAP730(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(EmptyAP730Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function EmptyAP730Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(EmptyAP730Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(EmptyAP730Event:new(vehicle, mode));
		end;
	end;
end;