AP730Event = {};
AP730Event_mt = Class(AP730Event, Event);

InitEventClass(AP730Event, "AP730Event");

function AP730Event:emptyNew()
    local self = Event:new(AP730Event_mt);
    self.className="AP730Event";
    return self;
end;

function AP730Event:new(vehicle, mode, state)
    local self = AP730Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function AP730Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function AP730Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function AP730Event:run(connection)
	self.vehicle:MPCode(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(AP730Event:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function AP730Event.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AP730Event:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AP730Event:new(vehicle, mode, state));
		end;
	end;
end;