--Specjalizacja dla : Ursus 4011 By Marcello1942
--#Autor: marcello1942
--#data: 19/07/2012 r.
--Przy edycji nie zapomnij o oryginalnym autorze!
--

Ursus914 = {};

function Ursus914.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus914:load(xmlFile)

	local klapalewa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#lewe"));
	if klapalewa ~= nil then
		self.klapalewa = klapalewa;
	end;
		local klapaprawa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#prawe"));
	if klapaprawa ~= nil then
		self.klapaprawa = klapaprawa;
	end;
		local zaczep = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lok#zaczep"));
	if zaczep ~= nil then
		self.zaczep = zaczep;
	end;

      
  	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);
	self.hydraulics = {};
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
		self.hydraulics[i] = {};
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};

		local ax, ay, az;
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
    self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");


end;
 function Ursus914:delete()
end;
function Ursus914:keyEvent(unicode, sym, modifier, isDown)

   if isDown and sym == Input.KEY_0 then
		self.pomoc = not self.pomoc;
	end;
  
end;


function Ursus914:update(dt)

        local nearestDistance = 2.1;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		
		local px, py, pz = getWorldTranslation(self.klapalewa); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.przyklapiel = true; 
		else
			self.przyklapiel = false; 
		end;
		
		local rx, ry, rz = getWorldTranslation(self.klapaprawa); 
		local distance = Utils.vector3Length(rx-vx, ry-vy, rz-vz);	
		if distance < nearestDistance then
			self.przyklapiep = true; 
		else
			self.przyklapiep = false; 
		end; 
		
		local ax, ay, az = getWorldTranslation(self.zaczep); 
		local distance = Utils.vector3Length(ax-vx, ay-vy, az-vz);	
		if distance < nearestDistance then
			self.przyzaczepie = true; 
		else
			self.przyzaczepie = false; 
		end; 
--------drzwi----------------
	if self.przyklapiep or self.isEntered then
	if InputBinding.hasEvent(InputBinding.PRAWE) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
	end;
	if self.przyklapiel or self.isEntered then
	if InputBinding.hasEvent(InputBinding.LEWE) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
	end;
	--dach-	
	if self.isEntered then				
		if InputBinding.hasEvent(InputBinding.DACH) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;
	--szyba--
		if InputBinding.hasEvent(InputBinding.SZYBA) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
	--podnosnik
		if InputBinding.isPressed(InputBinding.PODW) then
               self:setAnimationTime(6, self.animationParts[6].currentPosition+(self.animationParts[6].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.PODN) then
               self:setAnimationTime(6, self.animationParts[6].currentPosition-(self.animationParts[6].offSet+dt), false);
        end;
       end;
	--zaczep--
	if self.przyzaczepie or self.isEntered then
	 	if InputBinding.isPressed(InputBinding.ZACZEPW) then
               self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet+dt), false);
           elseif InputBinding.isPressed(InputBinding.ZACZEPN) then
               self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet+dt), false);
        end;
        end;
	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(7, 1);
		else
			self:setAnimationTime(7, 0);
		end;
	end;
	  --napisy
		if self.przyzaczepie then
			g_currentMission:addExtraPrintText(string.format("%s: pompka Up", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ZACZEPW)));
			g_currentMission:addExtraPrintText(string.format("%s: pompka Down", InputBinding.getKeyNamesOfDigitalAction(InputBinding.ZACZEPN)));
		end;
		if self.przyklapiel then
	if self.animationParts[2].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LEWE)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.LEWE)));
		end;
		end;
		if self.przyklapiep then
	if self.animationParts[1].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: otworz Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.PRAWE)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: zamknij Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.PRAWE)));
		end;
		end

			if self:getIsActive() then
		self.setHydraulicTime = 30;
	end;


	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;

end;
function Ursus914:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ursus914:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
function Ursus914:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
function Ursus914:draw()

    if self.isEntered then
		if not self.pomoc then
			renderText(0.833, 0.175, 0.02, "Wcisnij 0: Pokaz pomoc");
		else
			renderText(0.833, 0.175, 0.02, "Wcisnij 0: Schowaj pomoc");
		end;
		if self.pomoc then
			renderText(0.72, 0.85, 0.025, "----->Ursus c 4011<-----");
			if not self.isMotorStarted then
			renderText(0.72, 0.825, 0.02, "Nacisnij Z: odpal 40-ke");
			else
			renderText(0.72, 0.825, 0.02, "Nacisnij Z: zgas 40-ke");
			end;
	
	
		    renderText(0.72, 0.8, 0.02, "Nacisnij Num 4: Drzwi na podejscie i ze srodka");
	
		
			renderText(0.72, 0.775, 0.02, "Nacisnij Num 6: Maska na podejscie i ze srodka");
	
		
			renderText(0.72, 0.75, 0.02, "Nacisnij Num 8: Dach");
         
           
			renderText(0.72, 0.725, 0.02, "Nacisnij Num 1/2/3: Kierunkowskazy");
	
		
			renderText(0.72, 0.7, 0.02, "Nacisnij PgUp: Tylny Podnosnik Gora");
			
		
			renderText(0.72, 0.675, 0.02, "Nacisnij PgDown: Tylny podnosnik Dol");
			
			
			renderText(0.72, 0.625, 0.022, "----->MARCELLO 1942<-----");

		end;
	end;
	
  
end;

