      -------------------------------
	  -- Scrypt do PILMET REX 2518 --
	  --       By maciusboss1      --
	  --         15.08.2011        --
	  --        Pomoc Burner       --
	  --       www.lsmodss.pl      --
	  -------------------------------
	  
	  	  
REX2518 = {};

function REX2518.prerequisitesPresent(specializations)
    return true;
end;

function REX2518:load(xmlFile)

	self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
	self.saveMinRpm = 0;

end;

function REX2518:update(dt)

	if self.isTurnedOn then
		self:setVehicleRpmUp(dt, true);
	else
		self:setVehicleRpmUp(dt, false);
	end;

	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.REX2518_PRAWE) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
			if self.animationParts[1].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REX2518_ZlozRamie")), InputBinding.REX2518_PRAWE);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REX2518_RozlozRamie")), InputBinding.REX2518_PRAWE);
		end;
		if InputBinding.hasEvent(InputBinding.REX2518_LEWE) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			else
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
			if self.animationParts[2].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REX2518_ZlozRamie")), InputBinding.REX2518_LEWE);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("REX2518_RozlozRamie")), InputBinding.REX2518_LEWE);
		end;
		if InputBinding.isPressed(InputBinding.REX2518_BELKADOWN) then
              self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.REX2518_BELKAUP) then
              self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet+dt), false);
		end;
    end;
end;

function REX2518:draw()

	g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.REX2518_BELKADOWN) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.REX2518_BELKAUP)..": "..g_i18n:getText("REX2518_BELKA")..""));

end;

function REX2518:validateAttacherJoint(implement, jointDesc, dt)
   return true;
end;

function REX2518:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, steerable in pairs(g_currentMission.steerables) do
		if steerable == attacherVehicle then
			self.saveMinRpm = attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = self.attacherVehicle;
			end;
		elseif steerable == attacherVehicle.attacherVehicle then
			self.saveMinRpm = attacherVehicle.attacherVehicle.motor.minRpm;
			if self.attacherVehicleCopy == nil then
				self.attacherVehicleCopy = attacherVehicle.attacherVehicle;
			end;
		end;
	end;
end; 

function REX2518:onDetach()
	for k, steerable in pairs(g_currentMission.steerables) do
		if self.attacherVehicleCopy == steerable then
			steerable.motor.minRpm = self.saveMinRpm;
			self.attacherVehicleCopy = nil;
		end;
	end;
end;

function REX2518:onDeactivate()
	self:setVehicleRpmUp(nil, false);
end;

function REX2518:setVehicleRpmUp(dt, isActive)
	if self.attacherVehicleCopy ~= nil and self.saveMinRpm ~= 0 then
		if dt ~= nil then
			if isActive == true then
				self.attacherVehicleCopy.motor.minRpm = math.max(self.attacherVehicleCopy.motor.minRpm-(dt*2), -1200);
			else
				self.attacherVehicleCopy.motor.minRpm = math.min(self.attacherVehicleCopy.motor.minRpm+(dt*5), self.saveMinRpm);
			end;
		else
			self.attacherVehicleCopy.motor.minRpm = self.saveMinRpm;
		end;
		if self.attacherVehicleCopy.isMotorStarted then
			local fuelUsed = 0.0000011*math.abs(self.attacherVehicleCopy.motor.minRpm);
			self.attacherVehicleCopy:setFuelFillLevel(self.attacherVehicleCopy.fuelFillLevel-fuelUsed);
			g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
			g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
		end;
	end;
end;

function REX2518:onEnter()
end;

function REX2518:onLeave()
end;

function REX2518:delete()
end;

function REX2518:mouseEvent(posX, posY, isDown, isUp, button)
end;

function REX2518:keyEvent(unicode, sym, modifier, isDown)
end;





