--[[
trafficVehicleSpeed
RPM adjustment for traffic vehicle speed

@author:	Jakob Tischler
@version:	v0.2
@date:		02 Jan 2014
@history:	v0.1 (01 Jan 2014) - initial specialization
			v0.2 (02 Jan 2014) - usage of appendedFunction instead of specialization
--]]


local maxSpeed = 40;
local onlyDefault = true;
local excludeMilkTruck = true;

local modDescPath = Utils.getFilename('modDesc.xml', g_currentModDirectory);
if fileExists(modDescPath) then
	local modDescFile = loadXMLFile('trafficVehicleSpeedModDesc', modDescPath);

	maxSpeed = math.max(Utils.getNoNil(getXMLInt(modDescFile, 'modDesc.trafficVehicleSpeed#max'), maxSpeed), 4);
	onlyDefault = Utils.getNoNil(getXMLBool(modDescFile, 'modDesc.trafficVehicleSpeed#onlyDefault'), onlyDefault);
	excludeMilkTruck = Utils.getNoNil(getXMLBool(modDescFile, 'modDesc.trafficVehicleSpeed#excludeMilkTruck'), excludeMilkTruck);

	delete(modDescFile);
end;

local pathVehicleLoad = function(self, xmlFile)
	local continue = true;
	if onlyDefault and not Utils.startsWith(self.configFileName, 'data/') then
		--print(string.format('%s [pathVehicleLoad()]: onlyDefault=true -> ignore this custom traffic vehicle', tostring(self.configFileName)));
		continue = false;
	end;
	if continue and excludeMilkTruck and Utils.endsWith(self.configFileName, 'milktruck.xml') then
		--print(string.format('%s [pathVehicleLoad()]: excludeMilkTruck=true -> ignore this traffic vehicle', tostring(self.configFileName)));
		continue = false;
	end;

	if continue then
		self.origMaxRpm = { [3] = self.motor.maxRpm[3]; };
		self.targetMaxRpm = self.motor.maxRpm[3] * maxSpeed / 30;
		self.motor.maxRpmOverride = self.targetMaxRpm;
		--print(string.format('%s [pathVehicleLoad()]: maxRpm[3]=%s, maxRpmOverride=%s (maxSpeed=%d)', tostring(self.configFileName), tostring(self.motor.maxRpm[3]), tostring(self.motor.maxRpmOverride), maxSpeed));
	end;
end;
PathVehicle.load = Utils.appendedFunction(PathVehicle.load, pathVehicleLoad);
