--
-- Henly20 (Ls_uk Modteam)
-- 20.11.2010
--
-- > www.LS-UK.info
--

steeringrack7000 = {};

function steeringrack7000.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function steeringrack7000:load(xmlFile)
	local rotationPartNode14 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart14#index"));
    if rotationPartNode14 ~= nil then
        self.rotationPart14 = {};
        self.rotationPart14.node = rotationPartNode14;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#minRot"));
        self.rotationPart14.minRot = {};
        self.rotationPart14.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart14#maxRot"));
        self.rotationPart14.maxRot = {};
        self.rotationPart14.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart14.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart14.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart14.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#rotTime"), 2)*1000;
        self.rotationPart14.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart14#touchRotLimit"), 10));
    end;
end;

function steeringrack7000:delete()
end;

function steeringrack7000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function steeringrack7000:keyEvent(unicode, sym, modifier, isDown)
end;

function steeringrack7000:update(dt)

		if self.rotationPart14 ~= nil then
			local x, y, z = getRotation(self.rotationPart14.node);
			x = (self.rotationPart14.maxRot[1] - self.rotationPart14.minRot[1]) * (self.rotatedTime/-1);
				setRotation(self.rotationPart14.node, x, y ,z);
		end;

end;

function steeringrack7000:draw()
end;
