OdpalanieMPStatsEvent = {};
OdpalanieMPStatsEvent_mt = Class(OdpalanieMPStatsEvent, Event);

InitEventClass(OdpalanieMPStatsEvent, "OdpalanieMPStatsEvent");

function OdpalanieMPStatsEvent:emptyNew()
    local self = Event:new(OdpalanieMPStatsEvent_mt);
    self.className="OdpalanieMPStatsEvent";
    return self;
end;

function OdpalanieMPStatsEvent:new(vehicle)
    local self = OdpalanieMPStatsEvent:emptyNew()
    self.vehicle = vehicle;
    return self;
end;

function OdpalanieMPStatsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);
	self.vehicle.fuelConsumption = streamReadFloat32(streamId);
	self.vehicle.distanceDriven = streamReadFloat32(streamId);
	self.vehicle.fuelUsed = streamReadFloat32(streamId);
	self.vehicle.runningTime = streamReadFloat32(streamId);
	if not connection:getIsServer() then
		g_server:broadcastEvent(OdpalanieMPStatsEvent:new(self.vehicle), nil, connection, self.vehicle);
	end;
end;

function OdpalanieMPStatsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.vehicle.fuelConsumption);
	streamWriteFloat32(streamId, self.vehicle.distanceDriven);
	streamWriteFloat32(streamId, self.vehicle.fuelUsed);
	streamWriteFloat32(streamId, self.vehicle.runningTime);
end;

function OdpalanieMPStatsEvent.sendEvent(vehicle, isTransport)
	if g_server ~= nil then
		g_server:broadcastEvent(OdpalanieMPStatsEvent:new(vehicle), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(OdpalanieMPStatsEvent:new(vehicle));
	end;
end;

