-- Script By Mihai94
AnimatiiPedale = {};

function AnimatiiPedale.prerequisitesPresent(specializations)
    return true;
end;

function AnimatiiPedale:load(xmlFile)	
      local rotationPartNodeEmbraiagem = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationEmbraiagem#index"));
    if rotationPartNodeEmbraiagem ~= nil then
        self.rotationEmbraiagem = {};
        self.rotationEmbraiagem.node = rotationPartNodeEmbraiagem;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#minRot"));
        self.rotationEmbraiagem.minRot = {};
        self.rotationEmbraiagem.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#maxRot"));
        self.rotationEmbraiagem.maxRot = {};
        self.rotationEmbraiagem.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEmbraiagem.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEmbraiagem.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEmbraiagem.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#rotTime"), 2)*1000;
        self.rotationEmbraiagem.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEmbraiagem#touchRotLimit"), 10));
    end;

	local rotationPartNodeAcelerador = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationAcelerador#index"));
    if rotationPartNodeAcelerador ~= nil then
        self.rotationAcelerador = {};
        self.rotationAcelerador.node = rotationPartNodeAcelerador;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#minRot"));
        self.rotationAcelerador.minRot = {};
        self.rotationAcelerador.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationAcelerador#maxRot"));
        self.rotationAcelerador.maxRot = {};
        self.rotationAcelerador.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationAcelerador.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationAcelerador.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationAcelerador.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#rotTime"), 2)*1000;
        self.rotationAcelerador.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationAcelerador#touchRotLimit"), 10));
    end;
	local rotationPartNodeTravoes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationTravoes#index"));
    if rotationPartNodeTravoes ~= nil then
        self.rotationTravoes = {};
        self.rotationTravoes.node = rotationPartNodeTravoes;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#minRot"));
        self.rotationTravoes.minRot = {};
        self.rotationTravoes.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTravoes#maxRot"));
        self.rotationTravoes.maxRot = {};
        self.rotationTravoes.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTravoes.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTravoes.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTravoes.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#rotTime"), 2)*1000;
        self.rotationTravoes.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTravoes#touchRotLimit"), 10));
    end;

        self.rotationMaxEmbraiagem = false;
        self.rotationMaxAcelerador = false;
        self.rotationMaxTravoes = false;



function AnimatiiPedale:delete()
end;

function AnimatiiPedale:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatiiPedale:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatiiPedale:update(dt)	
        if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxEmbraiagem = true;
          else
				self.rotationMaxEmbraiagem = false;
          end;
          if Input.isKeyPressed(Input.KEY_w) then
				self.rotationMaxAcelerador = true;
          else
				self.rotationMaxAcelerador = false;
          end;
          if Input.isKeyPressed(Input.KEY_s) then
				self.rotationMaxTravoes = true;
          else
				self.rotationMaxTravoes = false;
          end;
	
function AnimatiiPedale:updateTick(dt)
			if self.rotationEmbraiagem ~= nil then
				local x, y, z = getRotation(self.rotationEmbraiagem.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationEmbraiagem.maxRot, self.rotationEmbraiagem.minRot, 3, self.rotationEmbraiagem.rotTime, dt, not self.rotationMaxEmbraiagem);
				setRotation(self.rotationEmbraiagem.node, unpack(newRot));
			end;
			if self.rotationAcelerador ~= nil then
				local x, y, z = getRotation(self.rotationAcelerador.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationAcelerador.maxRot, self.rotationAcelerador.minRot, 3, self.rotationAcelerador.rotTime, dt, not self.rotationMaxAcelerador);
				setRotation(self.rotationAcelerador.node, unpack(newRot));
			end;
			if self.rotationTravoes ~= nil then
				local x, y, z = getRotation(self.rotationTravoes.node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotationTravoes.maxRot, self.rotationTravoes.minRot, 3, self.rotationTravoes.rotTime, dt, not self.rotationMaxTravoes);
				setRotation(self.rotationTravoes.node, unpack(newRot));
			end;
	end;		
end;
	

function AnimatiiPedale:draw()
end;


end;