-- Script By Mihai94
AnimatiiAceBord = {};

function AnimatiiAceBord.prerequisitesPresent(specializations)
    return true;
end;

function AnimatiiAceBord:load(xmlFile)
	  -- Ace bord
	local rotationPartNodeCarburant = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartCarburant#index"));
    if rotationPartNodeCarburant ~= nil then
        self.rotationPartCarburant = {};
        self.rotationPartCarburant.node = rotationPartNodeCarburant;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCarburant#minRot"));
        self.rotationPartCarburant.minRot = {};
        self.rotationPartCarburant.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCarburant.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCarburant.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartCarburant#maxRot"));
        self.rotationPartCarburant.maxRot = {};
        self.rotationPartCarburant.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartCarburant.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartCarburant.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartCarburant.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCarburant#rotTime"), 50);
        self.rotationPartCarburant.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartCarburant#touchRotLimit"), 10));
    end;
	
	local rotationPartNodePresiuneUlei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartPresiuneUlei#index"));
    if rotationPartNodePresiuneUlei ~= nil then
        self.rotationPartPresiuneUlei = {};
        self.rotationPartPresiuneUlei.node = rotationPartNodePresiuneUlei;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPresiuneUlei#minRot"));
        self.rotationPartPresiuneUlei.minRot = {};
        self.rotationPartPresiuneUlei.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPresiuneUlei.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPresiuneUlei.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartPresiuneUlei#maxRot"));
        self.rotationPartPresiuneUlei.maxRot = {};
        self.rotationPartPresiuneUlei.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPresiuneUlei.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPresiuneUlei.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPresiuneUlei.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPresiuneUlei#rotTime"), 50);
        self.rotationPartPresiuneUlei.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartPresiuneUlei#touchRotLimit"), 10));
    end;
	
	local rotationPartNodeTemperaturaApa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartTemperaturaApa#index"));
    if rotationPartNodeTemperaturaApa ~= nil then
        self.rotationPartTemperaturaApa = {};
        self.rotationPartTemperaturaApa.node = rotationPartNodeTemperaturaApa;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTemperaturaApa#minRot"));
        self.rotationPartTemperaturaApa.minRot = {};
        self.rotationPartTemperaturaApa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTemperaturaApa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTemperaturaApa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTemperaturaApa#maxRot"));
        self.rotationPartTemperaturaApa.maxRot = {};
        self.rotationPartTemperaturaApa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTemperaturaApa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTemperaturaApa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        
        self.rotationPartTemperaturaApa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTemperaturaApa#rotTime"), 200);
        self.rotationPartTemperaturaApa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTemperaturaApa#touchRotLimit"), 10));
    end;
      
      local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;



function AnimatiiAceBord:delete()
end;

function AnimatiiAceBord:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatiiAceBord:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatiiAceBord:update(dt)	
	 -- Ace bord
	if self.isMotorStarted then
		if self.rotationPartCarburant ~= nil then
			local x, y, z = getRotation(self.rotationPartCarburant.node);
			z = ((self.rotationPartCarburant.maxRot[3] - self.rotationPartCarburant.minRot[3]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartCarburant.minRot[3];
			setRotation(self.rotationPartCarburant.node, x, y ,z);
		end;
			
		if self.rotationPartPresiuneUlei ~= nil then
			setRotation(self.rotationPartPresiuneUlei.node, 0, 0, Utils.degToRad(-50));
		end; 
		
	if self.rotationPartTemperaturaApa ~= nil then
		local x, y, z = getRotation(self.rotationPartTemperaturaApa.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTemperaturaApa.minRot, self.rotationPartTemperaturaApa.maxRot, 3, self.rotationPartTemperaturaApa.rotTime, dt, 1);
		setRotation(self.rotationPartTemperaturaApa.node, unpack(newRot));
	end;		
		
	else
		setRotation(self.rotationPartCarburant.node, 0, 0 , 0);
		setRotation(self.rotationPartPresiuneUlei.node, 0, 0 , 0);
		setRotation(self.rotationPartTemperaturaApa.node, 0, 0 , 0);
	end;

     local maxrpmneedle = 900;
			if self.rotationPart1 ~= nil then
				local x, y, z = getRotation(self.rotationPart1.node);
				y = ((self.rotationPart1.maxRot[2] - self.rotationPart1.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm/2.2) + self.rotationPart1.minRot[2];
				setRotation(self.rotationPart1.node, x, y ,z);
			end;
		end;
	
	

function AnimatiiAceBord:draw()
end;