
-- TG10
-- by majster2009


TG10 = {};

function TG10.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function TG10:load(xmlFile)
	self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory);
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
        self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
        self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1);
    end;
	
	local ajtoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ajto#index"));
    if ajtoNode ~= nil then
        self.ajto = {};
        self.ajto.node = ajtoNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajto#minRot"));
        self.ajto.minRot = {};
        self.ajto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ajto#maxRot"));
        self.ajto.maxRot = {};
        self.ajto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ajto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ajto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.ajto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajto#rotTime"), 2)*1000;
        self.ajto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ajto#touchRotLimit"), 10));
    end;
	
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	-----------------------------ADAPTER----------------------------
	self.walek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek#index"));
	self.walek2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek2#index"));
	self.walek3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek3#index"));
	self.walek4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.walek4#index"));
	
	
	self.wom = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wom#index"));
	self.literPerSec = 0.01;
 end;

function TG10:update(dt)
	if self.ajto ~= nil then
        	local x, y, z = getRotation(self.ajto.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ajto.maxRot, self.ajto.minRot, 3, self.ajto.rotTime, dt, not self.ajtoMax);
        	setRotation(self.ajto.node, unpack(newRot));
	end;

	if self:getIsActive() then
		
		if self.fillLevel == 0 then
			self.turnOn = false; 
			self:lowerRmp();
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end; 
		
		
		if self.turnOn then
			if not self.backupRmp then
			self.backupRmp = self.attacherVehicle.motor.minRpm;
		end; 			
		if self.attacherVehicle.motor.minRpm >= -600 then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm - 10; 
			end; 
			local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			local deltaLevel = self.literPerSec * difficultyMultiplier * self.literPerSecond;
			self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			Utils.setEmittingState(self.dustParticleSystems, true)
			for k,cuttingArea in pairs(self.cuttingAreas) do
                local x,y,z = getWorldTranslation(cuttingArea.start);
                local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                Utils.updateSprayArea(x, z, x1, z1, x2, z2);
            end;
			if not self.workSoundEnabled and self:getIsActiveForSound() then
	            playSample(self.workSound, 0, self.workSoundVolume, 0);
	            setSamplePitch(self.workSound, self.workSoundPitchOffset);
	            self.workSoundEnabled = true;
	        end;

		elseif not self.turnOn then
			Utils.setEmittingState(self.dustParticleSystems, false)
			self:lowerRmp();
			if self.workSoundEnabled then
		        stopSample(self.workSound);
		        self.workSoundEnabled = false;
			end;
		end;
	end;	
			
 
	--------------------------ADAPTER-------------------------
	if self.turnOn and self.walek ~= nil then
		rotate(self.walek, dt*0.02, 0, 0);
	end;
	if self.turnOn and self.walek2 ~= nil then
		rotate(self.walek2, dt*0.02, 0,0);
	end;
	if self.turnOn and self.walek3 ~= nil then
		rotate(self.walek3, dt*0.02, 0, 0);
	end;
	if self.turnOn and self.walek4 ~= nil then
		rotate(self.walek4, dt*0.02, 0, 0);
	end;

	if self.turnOn and self.wom ~= nil then
		rotate(self.wom, 0, 0, dt*0.03);
	end;

end;

function TG10:delete()
	Utils.setEmittingState(self.dustParticleSystems, false)
	self:lowerRmp();
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
end;

function TG10:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TG10:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_b and self.fillLevel ~= 0 then
		self.turnOn = not self.turnOn;
	end;
	
	if isDown and sym == Input.KEY_5 and (self.fillLevel <= 0 or self.ajtoMax) then
		self.ajtoMax = not self.ajtoMax;
	end;
end;		

function TG10:draw()
    if self.fillLevel <= 0 then
		g_currentMission:addExtraPrintText("ures");
		if self.ajtoMax then
			g_currentMission:addExtraPrintText("L: Plato felcsuk");
		else
			g_currentMission:addExtraPrintText("L: Plato lenyit");
		end;  	
    else
	if self.ajtoMax then
		g_currentMission:addExtraPrintText("L: Plato felcsuk");
		end;
	if self.turnOn then
       		g_currentMission:addExtraPrintText("TG10");
	else 
       		g_currentMission:addExtraPrintText("TG10");
	end;
    end;
end;

function TG10:onAttach()
end; 	


function TG10:onDetach()
	self.turnOn = false;
	Utils.setEmittingState(self.dustParticleSystems, false)
	if self.workSoundEnabled then
		stopSample(self.workSound);
		self.workSoundEnabled = false;
	end;
	
end

function TG10:lowerRmp()
	if self.backupRmp and self.attacherVehicle then
		if self.attacherVehicle.motor.minRpm <= self.backupRmp then
			self.attacherVehicle.motor.minRpm = self.attacherVehicle.motor.minRpm + 10; 
		else
			self.attacherVehicle.motor.minRpm = self.backupRmp; 
			self.backupRmp = nil; 			
		end; 	
	end; 
end;

