--author: igor29381

Teleportation = {};
Teleportation.modDir = g_currentModDirectory;
function Teleportation:loadMap(name)
	self.mapMarkerHUD = createImageOverlay(Teleportation.modDir.."MapMarker.dds");
	self.active = false;
	self.IDs = {};
	self.currentId = 1;
	self.mousePos = {0.5, 0.5};
	self.hudsState = {};
end;
function Teleportation:deleteMap()
end;
function Teleportation:mouseEvent(posX, posY, isDown, isUp, button)
	if self.active then
		if isDown and button == 1 then
			local x,y;
			local mapSize = g_currentMission.terrainSize;
			if posX <= 0.5 then x = -(0.5 - posX)*mapSize; else x = (posX - 0.5)*mapSize; end;
			if posY <= 0.5 then z = (0.5 - posY)*mapSize; else z = -(posY - 0.5)*mapSize; end;
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z)+2;
			local vehicle = g_currentMission.nodeToVehicle[self.IDs[math.floor(self.currentId)]];
			if vehicle ~= nil then
				local vehicles = {vehicle};
				local axyz = {x, terrainHeight, z};
				local AXYZ = {axyz};
				local XYZ = {};
				if vehicle.attachedImplements ~= nil then
					for i=1, table.getn(vehicle.attachedImplements) do 
						table.insert(vehicles, vehicle.attachedImplements[i].object);
						if vehicle.attachedImplements[i].object.attachedImplements ~= nil then
							for k=table.getn(vehicle.attachedImplements[i].object.attachedImplements), 1, -1 do
								vehicle.attachedImplements[i].object:detachImplement(1, true);
							end;
						end;
					end;
					for i=1, #vehicles do
						if i > 1 then
							local mx, my, mz = getWorldTranslation(vehicles[i].rootNode);
							local tx, ty, tz = worldToLocal(vehicles[1].rootNode, mx, my, mz);
							local xyz = {tx, ty, tz};
							AXYZ[i] = xyz;
						end;
					end;
				end;
				for i=1, #vehicles do
					if #vehicles[i].components > 1 then
						for k=1, #vehicles[i].components do
							if k > 1 then
								local mx, my, mz = getWorldTranslation(vehicles[i].components[k].node);
								local tx, ty, tz = worldToLocal(vehicles[i].components[1].node, mx, my, mz);
								local xyz = {tx, ty, tz};
								XYZ[k] = xyz;
							end;
						end;
					end;
					for k=1, #vehicles[i].components do
						if k==1 then 
							setTranslation(vehicles[i].components[1].node, AXYZ[k][1], AXYZ[k][2], AXYZ[k][3]);
						else
							local tx, ty, tz = localToWorld(vehicles[i].components[1].node, XYZ[k][1], XYZ[k][2], XYZ[k][3]);
							setTranslation(vehicles[i].components[k].node, tx, ty, tz);
						end;
					end;
				end;
			else
				setTranslation(self.IDs[math.floor(self.currentId)], x, terrainHeight, z);
			end;
			self.active = false;
			Teleportation:forExit()
		end;
		if button == Input.MOUSE_BUTTON_WHEEL_UP then
			self.currentId = math.max(self.currentId - 0.5, 1);

		elseif button == Input.MOUSE_BUTTON_WHEEL_DOWN then
			self.currentId = math.min(self.currentId + 0.5, #self.IDs);

		end;
		self.mousePos[1] = posX;
		self.mousePos[2] = posY;
	end;
end;
function Teleportation:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_f12 then 
		self.active = not self.active;
		if self.active then
			InputBinding.setShowMouseCursor(true);
			self.IDs[1] = g_currentMission.player.rootNode;
			local vehicles = g_currentMission.vehicles;
			for k, vehicle in pairs(vehicles) do
				if not g_currentMission.nodeToVehicle[vehicle.rootNode].isPathVehicle then
					if getName(vehicle.rootNode) ~= "golfCart" then
						if vehicle.attacherVehicle == nil then
							table.insert(self.IDs, vehicle.rootNode);
							if vehicle.isEntered then 
								self.currentId = #self.IDs;
							end;
						end;
					end;
				end;
			end;
			self.hudsState[1] = g_currentMission.renderTime;
			self.hudsState[2] = g_currentMission.showHelpText;
			self.hudsState[3] = g_currentMission.showHudEnv;
			self.hudsState[4] = g_currentMission.showWeatherForecast;
			self.hudsState[5] = g_currentMission.missionPDA.showPDA;
			self.hudsState[6] = g_currentMission.showVehicleInfo;
			self.hudsState[7] = g_currentMission.showVehicleSchema;
			g_currentMission.renderTime = false;
			g_currentMission.showHelpText = false;
			g_currentMission.showHudEnv  = false;
			g_currentMission.showWeatherForecast = false;
			g_currentMission.missionPDA.showPDA = false;
			g_currentMission.showVehicleInfo = false;
			g_currentMission.showVehicleSchema = false;
		else
			Teleportation:forExit()
		end;
	end;
end;

function Teleportation:forExit()
	InputBinding.setShowMouseCursor(false);
	self.IDs = {};
	g_currentMission.renderTime = self.hudsState[1];
	g_currentMission.showHelpText = self.hudsState[2];
	g_currentMission.showHudEnv  = self.hudsState[3];
	g_currentMission.showWeatherForecast = self.hudsState[4];
	g_currentMission.missionPDA.showPDA = self.hudsState[5];
	g_currentMission.showVehicleInfo = self.hudsState[6];
	g_currentMission.showVehicleSchema = self.hudsState[7];
end;

function Teleportation:update(dt)
end;
function Teleportation:draw(dt)
	if self.active then
		renderOverlay(g_inGameMenu.mapImage.overlay, 0, 0, 1, 1);
		local px = 0.01;
		local py = 0.005;
		local name;
		if self.IDs[math.floor(self.currentId)] == g_currentMission.player.rootNode then
			name = "player";
		else
			local vehicle = g_currentMission.nodeToVehicle[self.IDs[math.floor(self.currentId)]];
			local VCFN = string.lower(vehicle.configFileName);
			local StoreItem = StoreItemsUtil.storeItemsByXMLFilename[VCFN];
			local storeImage = createImageOverlay(Utils.getFilename(StoreItem.imageActive));
			local y = 0.7;
			if self.mousePos[2] > 0.5 then y = 0.1; end;
			renderOverlay(storeImage, 0.1, y, 0.14, 0.14);
			name = StoreItem.name;
			if vehicle.attachedImplements ~= nil then
				for i=1, table.getn(vehicle.attachedImplements) do
					local VCFN = string.lower(vehicle.attachedImplements[i].object.configFileName);
					local StoreItem = StoreItemsUtil.storeItemsByXMLFilename[VCFN];
					local storeImage = createImageOverlay(Utils.getFilename(StoreItem.imageActive));
					local y = 0.7;
					if self.mousePos[2] > 0.5 then y = 0.1; end;
					renderOverlay(storeImage, 0.1+0.16*i, y, 0.14, 0.14);
					name = name.." + "..StoreItem.name;
				end;
			end;
		end;
		if self.mousePos[1] > 0.5 then px = -(string.len(name)*0.005)-0.03; end;
		if self.mousePos[2] > 0.5 then py = -0.04; end;
		renderText(self.mousePos[1]+px, self.mousePos[2]+py, 0.020, name);
		local x, _, z = getWorldTranslation(self.IDs[math.floor(self.currentId)]);
		local mapSize = g_currentMission.terrainSize;
		x = 0.5 + x/mapSize;
		z =-(z/mapSize - 0.5);
		renderOverlay(self.mapMarkerHUD, x-0.025, z, 0.05, 0.05);
	end;
end;
addModEventListener(Teleportation);