  --
  -- viconAcrobat_belt
  -- Class for all viconAcrobat_belts
  -- Note: the rotor animation is not perfectly synchronized, thus do not attach any gameplay relevant stuff to the rotor animation
  --
  -- @author  Stefan Geiger
  -- @date  11/05/08
  --
  -- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

viconAcrobat_belt = {};
  
function viconAcrobat_belt.prerequisitesPresent(specializations)
 	return SpecializationUtil.hasSpecialization(acrobatWindrow_belt, specializations);
end;
  
function viconAcrobat_belt:load(xmlFile)
  

      self.setIsTurnedOn = viconAcrobat_belt.setIsTurnedOn;


      self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.5);
      self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
      if self.groundReferenceNode == nil then
         self.groundReferenceNode = self.components[1].node;
      end;
  
	
	
	local rotarySound = getXMLString(xmlFile, "vehicle.rotarySound#file");
	if rotarySound ~= nil and rotarySound ~= "" then
		rotarySound = Utils.getFilename(rotarySound, self.baseDirectory);
		self.rotarySound = createSample("rotarySound");
		loadSample(self.rotarySound, rotarySound, false);
		self.rotarySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#pitchOffset"), 0);
		self.rotarySoundVolume = 0.0;
		self.rotarySoundVolumeMin = 0.0;
		self.rotarySoundVolumeMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.rotarySound#volume"), 1.0);
		self.rotarySoundEnabled = false;
	end;
  
 
      local numTedderDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.tedderDropAreas#count"), 0);
      if numTedderDropAreas ~= table.getn(self.cuttingAreas) then
          print("Warning: Number of cutting areas and drop areas should be equal");
      end;
      self.tedderDropAreas = {}
      for i=1, numTedderDropAreas do
          self.tedderDropAreas[i] = {};
          local areanamei = string.format("vehicle.tedderDropAreas.tedderDropArea%d", i);
          self.tedderDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
          self.tedderDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
          self.tedderDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
      end;
  
    self.accumulatedCuttingAreaValues = {}
    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0)
    for i = 1, numCuttingAreas do
      local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i)
      self.cuttingAreas[i].grassParticleSystemIndex = getXMLInt(xmlFile, areanamei .. "#particleSystemIndex")
      self.accumulatedCuttingAreaValues[i] = 0
    end	  
	  
	  self.onlyActiveWhenLowered = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.onlyActiveWhenLowered#value"), true);	 
	
  
      self.grassParticleSystems = {};
      local i=0;
      while true do
          local baseName = string.format("vehicle.grassParticleSystems.grassParticleSystem(%d)", i);
  
          local particleSystem = {};
          particleSystem.ps = {};
          local ps = Utils.loadParticleSystem(xmlFile, particleSystem.ps, baseName, self.components, false, nil, self.baseDirectory)
          if ps == nil then
              break;
          end;
          particleSystem.disableTime = 0;
          particleSystem.isEnabled = false;
          table.insert(self.grassParticleSystems, particleSystem);
          i = i+1;
      end;
  
      self.isTurnedOn = false;
      self.wasToFast = false;
      self.tedderParticleSystemFlag = self:getNextDirtyFlag();
end;
  
function viconAcrobat_belt:delete()
  
      for k,v in pairs(self.grassParticleSystems) do
          Utils.deleteParticleSystem(v.ps);
      end;
  
	if self.rotarySound ~= nil then
		delete(self.rotarySound);
	end;
  
end;
  
function viconAcrobat_belt:readStream(streamId, connection)
      local isTurnedOn = streamReadBool(streamId);
      local animTime = streamReadFloat32(streamId);
      -- viconAcrobat_belt.setRotorAnimTime(self, animTime);
      self:setIsTurnedOn(isTurnedOn, true);
end;
  
function viconAcrobat_belt:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isTurnedOn);
      streamWriteFloat32(streamId, self.animTime);
end;
  
function viconAcrobat_belt:readUpdateStream(streamId, timestamp, connection)
      if connection:getIsServer() then
          local hasUpdate = streamReadBool(streamId);
          if hasUpdate then
              for k,v in ipairs(self.grassParticleSystems) do
                  local enabled = streamReadBool(streamId);
                  Utils.setEmittingState(v.ps, enabled);
              end;
          end;
      end;
end;
  
function viconAcrobat_belt:writeUpdateStream(streamId, connection, dirtyMask)
      if not connection:getIsServer() then
          if bitAND(dirtyMask, self.tedderParticleSystemFlag) ~= 0 then
              streamWriteBool(streamId, true);
              for k,v in ipairs(self.grassParticleSystems) do
                  streamWriteBool(streamId, v.isEnabled);
              end;
          else
              streamWriteBool(streamId, false);
          end;
      end;
end;
  
function viconAcrobat_belt:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function viconAcrobat_belt:keyEvent(unicode, sym, modifier, isDown)
end;
 
function viconAcrobat_belt:update(dt)
  
      if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
              self:setIsTurnedOn(not self.isTurnedOn);

			end;
      end;

end;
  
function viconAcrobat_belt:updateTick(dt)
      self.wasToFast = false;

      if self:getIsActive() then

          local hasGroundContact = false;
          local x,y,z = getWorldTranslation(self.groundReferenceNode);
          local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
          if terrainHeight+self.groundReferenceThreshold >= y then
              hasGroundContact = true;
          end;
		  
		local volume = Utils.getMovedLimitedValues({self.rotarySoundVolume}, {self.rotarySoundVolumeMax}, {self.rotarySoundVolumeMin}, 1, 1200, dt, not self.isTurnedOn);
		self.rotarySoundVolume = volume[1];
			if self.isTurnedOn then
				if not self.rotarySoundEnabled and self:getIsActiveForSound() then
					playSample(self.rotarySound, 0, self.rotarySoundVolume, 0);
					setSamplePitch(self.rotarySound, self.rotarySoundPitchOffset);
					self.rotarySoundEnabled = true;
				end;
				if self.rotarySoundVolume < self.rotarySoundVolumeMax then
					setSampleVolume(self.rotarySound, self.rotarySoundVolume);
				end;
				else
				if self.rotarySoundEnabled then
					if self.rotarySoundVolume <= self.rotarySoundVolumeMin then
						stopSample(self.rotarySound);
						self.rotarySoundEnabled = false;
					else
						setSampleVolume(self.rotarySound, self.rotarySoundVolume);
					end;
				end;

			end;	
 		
          if self.isTurnedOn then	
              if hasGroundContact and not self.isWindrowOn then
			   if self.isServer and (not self.onlyActiveWhenLowered or self:isLowered(false)) then
                  local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 25;
                  if self.isServer then
                      local cuttingAreasSend = {};
                      if not toFast then
                          local numAreas = math.min(table.getn(self.tedderDropAreas), table.getn(self.cuttingAreas));
                          for i=1, numAreas do
                              local cuttingArea = self.cuttingAreas[i];
                              if self:getIsAreaActive(cuttingArea) then
                                  local x,y,z = getWorldTranslation(cuttingArea.start);
                                  local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                  local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
  
                                  local dropArea = self.tedderDropAreas[i];
                                  local dx,dy,dz = getWorldTranslation(dropArea.start);
                                  local dx1,dy1,dz1 = getWorldTranslation(dropArea.width);
                                  local dx2,dy2,dz2 = getWorldTranslation(dropArea.height);
  
                                  table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2,dx, dz, dx1, dz1, dx2, dz2, 0, i});
                              end;
                          end;
                          if (table.getn(cuttingAreasSend) > 0) then
                              local cuttingAreasSend, bitType = TedderAreaEvent.runLocally(cuttingAreasSend, self.accumulatedCuttingAreaValues)
                              if (table.getn(cuttingAreasSend) > 0) then
                                  for i=1, table.getn(cuttingAreasSend) do
                                      local cuttingArea = self.cuttingAreas[cuttingAreasSend[i][14] ];
  
                                      if cuttingArea.grassParticleSystemIndex ~= nil then
                                          local ps = self.grassParticleSystems[cuttingArea.grassParticleSystemIndex+1];
                                          if ps ~= nil then
                                              ps.disableTime = self.time + 300;
                                              if not ps.isEnabled then
                                                  ps.isEnabled = true;
                                                  self:raiseDirtyFlags(self.tedderParticleSystemFlag);
                                                  if self.isClient and self.Transport and self.lastSpeed*3600 > 1 then
                                                      Utils.setEmittingState(ps.ps, true);
                                                  end;
                                              end;
                                          end;
                                      end;
                                  end;
                                  g_server:broadcastEvent(TedderAreaEvent:new(cuttingAreasSend, bitType));
                              end;
                          end;
                      end;
                  end;

              end;
                  self.wasToFast = toFast;
              end;
            end;
			end;
          if self.isServer then
              for k,v in pairs(self.grassParticleSystems) do
                  if self.time > v.disableTime then
                      if v.isEnabled then
                          v.isEnabled = false;
                          self:raiseDirtyFlags(self.tedderParticleSystemFlag);
                          if self.isClient then
                              Utils.setEmittingState(v.ps, false);
                          end;
                      end;
                  end;
              end;
          end;
end;
  
function viconAcrobat_belt:draw()
      if self.isClient then
		if self.isTurnedOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA)
		end 
          if self.wasToFast then
              g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
          end;
      end;
end;
  
function viconAcrobat_belt:onDetach()
      if self.deactivateOnDetach then
          viconAcrobat_belt.onDeactivate(self);
      else
          viconAcrobat_belt.onDeactivateSounds(self)
      end;

end;

function viconAcrobat_belt:onAttach(attacherVehicle)

end;
  
function viconAcrobat_belt:onLeave()
      if self.deactivateOnLeave then
          viconAcrobat_belt.onDeactivate(self);
      else
          viconAcrobat_belt.onDeactivateSounds(self)
      end;
end;
  
function viconAcrobat_belt:onDeactivate()
      if self.isClient then
          for k,v in pairs(self.grassParticleSystems) do
              v.isEnabled = false;
              Utils.setEmittingState(v.ps, false);
          end;
      end;
      viconAcrobat_belt.onDeactivateSounds(self)
      self.isTurnedOn = false;
end;
  
function viconAcrobat_belt:onDeactivateSounds()
	if self.rotarySoundEnabled then
		stopSample(self.rotarySound);
		self.rotarySoundEnabled = false;
	end;
end;
  
function viconAcrobat_belt:setIsTurnedOn(isTurnedOn, noEventSend)
     SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend)
     self.isTurnedOn = isTurnedOn;
end;
