
tines = {}

function tines.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function tines:load(xmlFile)
    self.tinesanimation = {};
    self.tinesanimation.animCharSet = 0;
    self.tinesanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.flywheel#rootNode"));

    if rootNode ~= nil then
        self.tinesanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.tinesanimation.animCharSet ~= 0 then
            self.tinesanimation.clip = getAnimClipIndex(self.tinesanimation.animCharSet, getXMLString(xmlFile, "vehicle.flywheel#animationClip"));
            if self.tinesanimation.clip >= 0 then
                assignAnimTrackClip(self.tinesanimation.animCharSet, 0, self.tinesanimation.clip);
                setAnimTrackLoopState(self.tinesanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.tinesanimation.animCharSet, 0, -.5);
            end;
        end;
    end;
end;

function tines:delete()
end;

function tines:update()
    if self.isTurnedOn then
        enableAnimTrack(self.tinesanimation.animCharSet, 0);
    else
        disableAnimTrack(self.tinesanimation.animCharSet, 0);
        self.tinesanimationEnabled = false;
    end;
end;

function tines:draw()
end;

function tines:onEnter()
end;

function tines:onLeave()
    if self.tinesanimationEnabled then
        disableAnimTrack(self.tinesanimation.animCharSet, 0);
        self.tinesanimationEnabled = false;
    end;
end;

function tines:keyEvent(unicode, sym, modifier, isDown)
end;

function tines:mouseEvent(posX, posY, isDown, isUp, button)
end;
