
starwheel = {}

function starwheel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function starwheel:load(xmlFile)
    self.starwheelanimation = {};
    self.starwheelanimation.animCharSet = 0;
    self.starwheelanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.starwheel#rootNode"));
    if rootNode ~= nil then
        self.starwheelanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.starwheelanimation.animCharSet ~= 0 then
            self.starwheelanimation.clip = getAnimClipIndex(self.starwheelanimation.animCharSet, getXMLString(xmlFile, "vehicle.starwheel#animationClip"));
            if self.starwheelanimation.clip >= 0 then
                assignAnimTrackClip(self.starwheelanimation.animCharSet, 0, self.starwheelanimation.clip);
                setAnimTrackLoopState(self.starwheelanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.starwheelanimation.animCharSet, 0, 1);
            end;
        end;
    end;
end;

function starwheel:delete()
end;

function starwheel:update()
    if self.isTurnedOn and self.movingDirection > 0 and self.fillLevel > (self.capacity * 0.01) and self.fillLevel < (self.capacity) then
        enableAnimTrack(self.starwheelanimation.animCharSet, 0);
    else
        disableAnimTrack(self.starwheelanimation.animCharSet, 0);
        self.starwheelanimationEnabled = false;
    end;
end;

function starwheel:draw()
end;

function starwheel:onEnter()
end;

function starwheel:onLeave()
end;

function starwheel:keyEvent(unicode, sym, modifier, isDown)
end;

function starwheel:mouseEvent(posX, posY, isDown, isUp, button)
end;
