
shaft = {}

function shaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function shaft:load(xmlFile)
    self.shaftanimation = {};
    self.shaftanimation.animCharSet = 0;
    self.shaftanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shaft#rootNode"));
    if rootNode ~= nil then
        self.shaftanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.shaftanimation.animCharSet ~= 0 then
            self.shaftanimation.clip = getAnimClipIndex(self.shaftanimation.animCharSet, getXMLString(xmlFile, "vehicle.shaft#animationClip"));
            if self.shaftanimation.clip >= 0 then
                assignAnimTrackClip(self.shaftanimation.animCharSet, 0, self.shaftanimation.clip);
                setAnimTrackLoopState(self.shaftanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.shaftanimation.animCharSet, 0, 1);
            end;
        end;
    end;
end;

function shaft:delete()
end;

function shaft:update()
    if self.isTurnedOn then 
        enableAnimTrack(self.shaftanimation.animCharSet, 0);
    else
        disableAnimTrack(self.shaftanimation.animCharSet, 0);
        self.shaftanimationEnabled = false;
    end;
end;

function shaft:draw()
end;

function shaft:onEnter()
end;

function shaft:onLeave()
    if self.shaftanimationEnabled then
        disableAnimTrack(self.shaftanimation.animCharSet, 0);
        self.shaftanimationEnabled = false;
    end;
end;

function shaft:keyEvent(unicode, sym, modifier, isDown)
end;

function shaft:mouseEvent(posX, posY, isDown, isUp, button)
end;
