
running = {}

function running.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Foldable, specializations);
end;

function running:load(xmlFile)

    self.sickleSound = {}
    local sickleSound = getXMLString(xmlFile, "vehicle.sickleSound#file");
    if sickleSound ~= nil and sickleSound ~= "" then
        sickleSound = Utils.getFilename(sickleSound, self.baseDirectory);
        self.sickleSound = createSample("sickleSound");
        loadSample(self.sickleSound, sickleSound, false);
        self.sickleSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#pitchOffset"), 1);
        self.sickleSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#volume"), 1);
        setSamplePitch(self.sickleSound, self.sickleSoundPitchOffset);
    end;
    self.rod = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rod#index"));

    self.sickleSoundEnabled = false;

    local sickleSound = getXMLString(xmlFile, "vehicle.sickleSound#file");
    if sickleSound ~= nil and sickleSound ~= "" then
        sickleSound = Utils.getFilename(sickleSound, self.baseDirectory);
        self.sickleSound = createSample("sickleSound");
        loadSample(self.sickleSound, sickleSound, false);
        self.sickleSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#pitchOffset"), 1);
        self.sickleSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#volume"), 1);
        setSamplePitch(self.sickleSound, self.sickleSoundPitchOffset);

        self.sickleSound3DVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#volume3D"), self.sickleSoundVolume);
        self.sickleSound3DInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#innerRadius"), 10);
        self.sickleSound3DRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.sickleSound#radius"), 50);

        self.sickleSound3D = createAudioSource("sickleSound3D", sickleSound, self.sickleSound3DRadius, self.sickleSound3DInnerRadius, self.sickleSound3DVolume, 0);
        setSamplePitch(getAudioSourceSample(self.sickleSound3D), self.sickleSoundPitchOffset);
        link(self.components[1].node, self.sickleSound3D);
        setVisibility(self.sickleSound3D, false);
    end;
 
    self.runninganimation = {};
    self.runninganimation.animCharSet = 0;
    self.runninganimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.running#rootNode"));
    if rootNode ~= nil then
        self.runninganimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.runninganimation.animCharSet ~= 0 then
            self.runninganimation.clip = getAnimClipIndex(self.runninganimation.animCharSet, getXMLString(xmlFile, "vehicle.running#animationClip"));
            if self.runninganimation.clip >= 0 then
                assignAnimTrackClip(self.runninganimation.animCharSet, 0, self.runninganimation.clip);
                setAnimTrackLoopState(self.runninganimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.runninganimation.animCharSet, 0, 3);
            end;
        end;
    end;
end;

function running:delete()
    if self.sickleStartSound ~= nil then
        delete(self.sickleStartSound);
    end;
    if self.sickleSound ~= nil then
        delete(self.sickleSound);
        self.sickleSoundEnabled = false;
    end;
    if self.sickleStopSound ~= nil then
        delete(self.sickleStopSound);
    end;
end;

function running:update()
    if self.isTurnedOn and self.foldAnimTime == 0 then
        enableAnimTrack(self.runninganimation.animCharSet, 0);
        self.sickleSoundEnabled = true;
        setVisibility(self.sickleSound3D, true);
    else 
        disableAnimTrack(self.runninganimation.animCharSet, 0);
        self.runninganimationEnabled = false;
        self.isTurnedOn = false;
        self.sickleSoundEnabled = false;
        setVisibility(self.sickleSound3D, false);
    end;
    setVisibility(self.rod, self.foldAnimTime == 1);
end;


function running:draw()
end;

function running:onEnter()
end;

function running:onLeave()
    if self.runninganimationEnabled and self.isTurnedOn then
        disableAnimTrack(self.runninganimation.animCharSet, 0);
        self.runninganimationEnabled = false;
        self.isTurnedOn = not self.isTurnedOn;
        self.sickleSoundEnabled = false;
    end;
end;

function running:setIsTurnedOn(isTurnedOn, noEventSend)
    if self.isClient then
        if self.sickleSoundEnabled then
            stopSample(self.sickleSound);
            self.sickleSoundEnabled = false;
        end
        if self.sickleSound3D ~= nil then
            setVisibility(self.sickleSound3D, false);
        end
    end;
end;

function running:keyEvent(unicode, sym, modifier, isDown)
end;

function running:mouseEvent(posX, posY, isDown, isUp, button)
end;
