

--source("dataS/scripts/vehicles/specializations/CultivatorAreaEvent.lua");


plow = {};

function plow.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function plow:load(xmlFile)
    --
    self.setParms = SpecializationUtil.callSpecializationsFunction("setParms");
    --
    self.rotationParts = {}
    local i = 0;
    while (true) do
        local baseName = string.format("vehicle.rotationParts.rotationPart(%d)", i);
        if not hasXMLProperty(xmlFile, baseName) then
            break;
        end;
        
        local entry = {};
        entry.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#index"));
        
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#minRot"));
        entry.minRot = {};
        entry.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        entry.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        entry.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRot"));
        entry.maxRot = {};
        entry.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 180));
        entry.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 180));
        entry.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 180));

        entry.rotTime = Utils.getNoNil(getXMLString(xmlFile, baseName.."#rotTime"), 100)*1000;
        entry.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, baseName.."#touchRotLimit"), 10));

        table.insert(self.rotationParts, entry);
        i = i+1;
    end;
    
    --
    local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        self.workSound = createSample("workSound");
        loadSample(self.workSound, workSound, false);
    end;
    --
    self.newGroundParticleSystems = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.groundParticleSystems.groundParticleSystem(%d)", i);
        if not hasXMLProperty(xmlFile, baseName) then
            break;
        end;
        local entry = {};
        entry.ps = {};
        Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
        if table.getn(entry.ps) > 0 then
            entry.isActive = false;
            table.insert(self.newGroundParticleSystems, entry);
        end;
        i = i+1;
    end;
    --
    self.plowLowered = false;
    self.safeMode = true
	
      self.cultivatorDirectionNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cultivatorDirectionNode#index")), self.components[1].node);	
	
      self.aiTerrainDetailChannel1 = g_currentMission.ploughChannel;
      self.aiTerrainDetailChannel2 = g_currentMission.sowingChannel;
      self.aiTerrainDetailChannel3 = g_currentMission.sowingWidthChannel;
  
      self.maxSpeedLevel = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxSpeedLevel#value"), 1);
      self.speedViolationMaxTime = 2500;
      self.speedViolationTimer = self.speedViolationMaxTime;
      self.cultivatorContactReportsActive = false;
      self.startActivationTimeout = 2000;
      self.startActivationTime = 0;	
      self.cultivatorLimitToField = false;
      self.cultivatorForceLimitToField = true;
  
      self.showFieldNotOwnedWarning = false;
end;

function plow:delete()
    for _, entry in ipairs(self.newGroundParticleSystems) do
        Utils.deleteParticleSystem(entry.ps);
    end;
end;

function plow:mouseEvent(posX, posY, isDown, isUp, button)
end;

function plow:keyEvent(unicode, sym, modifier, isDown)
end;

function plow:readStream(streamId, connection)
    self.plowLowered  = streamReadBool(streamId);
    self.safeMode     = streamReadBool(streamId);
end;

function plow:writeStream(streamId, connection)
    streamWriteBool(streamId, self.plowLowered);
    streamWriteBool(streamId, self.safeMode);

end;

function plow:readUpdateStream(streamId, timestamp, connection)
      if connection:getIsServer() then

          self.showFieldNotOwnedWarning = streamReadBool(streamId);
      end;
end;
  
function plow:writeUpdateStream(streamId, connection, dirtyMask)
      if not connection:getIsServer() then
          --if bitAND(dirtyMask, self.cultivatorGroundContactFlag) ~= 0 then
          --    streamWriteBool(streamId, true);

          streamWriteBool(streamId, self.showFieldNotOwnedWarning);
      end;
end;

function plow:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
            self:setParms(self.plowLowered, not self.safeMode);
        elseif InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            self:setParms(not self.plowLowered, self.safeMode);
        end;
    end;
    
    if self.attacherVehicle then
        --
        self.isFullyRotated = false;
        if table.getn(self.rotationParts) > 0 and self.rotationParts[1].node ~= nil then
            local x, y, z = getRotation(self.rotationParts[1].node);
            local minRot = self.rotationParts[1].minRot;
            local eps = self.rotationParts[1].touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isFullyRotated = true;
            end;
        end;
        --

        --
        local particlesActive = self.isFullyRotated and (self.attacherVehicle.lastSpeed*3600 > 2);
        for k, ps in pairs(self.newGroundParticleSystems) do
            if ps.isActive ~= particlesActive then
                ps.isActive = particlesActive;
                Utils.setEmittingState(ps.ps, particlesActive);
            end;
        end;
        --
        for k,v in pairs(self.rotationParts) do
            if v.node ~= nil then
                local x, y, z = getRotation(v.node);
                local rot = {x,y,z};
                local newRot = Utils.getMovedLimitedValues(rot, v.maxRot, v.minRot, 3, v.rotTime, dt, self.plowLowered);
                setRotation(v.node, unpack(newRot));
            end;
        end;
    end;
	
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

function plow:updateTick(dt)

  
    if self:getIsActive() then
          local showFieldNotOwnedWarning = false;
        if self.isFullyRotated then

          -- local doGroundManipulation = (hasGroundContact and (not self.onlyActiveWhenLowered or self:isLowered(false)) and self.startActivationTime <= self.time);	
          -- if doGroundManipulation then
              if self.isServer then
                  local cuttingAreasSend = {};
                  for _, cuttingArea in pairs(self.cuttingAreas) do
                      if self:getIsAreaActive(cuttingArea) then
                          local x,_,z = getWorldTranslation(cuttingArea.start);
                          if g_currentMission:getIsFieldOwnedAtWorldPos(x,z) then
                              local x1,_,z1 = getWorldTranslation(cuttingArea.width);
                              local x2,_,z2 = getWorldTranslation(cuttingArea.height);
                              table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                          else
                              showFieldNotOwnedWarning = true;
                          end
                      end;
                  end;
                  if table.getn(cuttingAreasSend) > 0 then
                      local limitToField = self.cultivatorLimitToField or self.cultivatorForceLimitToField;
                      local limitGrassDestructionToField = false;
                      if not g_currentMission:getHasPermission("createFields", self:getOwner()) then
                          limitToField = true;
                          limitGrassDestructionToField = true;
                      end;
  
                      local dx,dy,dz = localDirectionToWorld(self.cultivatorDirectionNode, 0, 0, 1);
                      local angle = Utils.convertToDensityMapAngle(Utils.getYRotationFromDirection(dx, dz), g_currentMission.terrainDetailAngleMaxValue);
  
                      local realArea = CultivatorAreaEvent.runLocally(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle);
                      g_server:broadcastEvent(CultivatorAreaEvent:new(cuttingAreasSend, limitToField, limitGrassDestructionToField, angle));
  
                      local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
                      local sqm = realArea*pixelToSqm;
                      local ha = sqm/10000;
                      g_currentMission.missionStats.hectaresWorkedTotal = g_currentMission.missionStats.hectaresWorkedTotal + ha;
                      g_currentMission.missionStats.hectaresWorkedSession = g_currentMission.missionStats.hectaresWorkedSession + ha;
  
                  end;
              end;
          -- end
        end;
          if self.isServer then
              if showFieldNotOwnedWarning ~= self.showFieldNotOwnedWarning then
                  self.showFieldNotOwnedWarning = showFieldNotOwnedWarning;
                  self:raiseDirtyFlags(self.cultivatorGroundContactFlag);
              end
          end
	end;
end;

function plow:onDetach()
      self.cultivatorLimitToField = false;
end;

function plow:onDeactivate()

    self.showFieldNotOwnedWarning = false;
	  
end;


function plow:setParms(plowLowered, safeMode, noEventSend)
    self.plowLowered = plowLowered;

    --
    plowEvent.sendEvent(self, self.plowLowered, self.safeMode, noEventSend);
end;

function plow:aiTurnOn()
      self.cultivatorLimitToField = true;
    self:setParms(self.plowLowered, true);	  
end;
  
function plow:aiTurnOff()
      self.cultivatorLimitToField = false;
end;

function plow:draw()
    if g_currentMission.showHelpText then
        if self.plowLowered then
            g_currentMission:addHelpButtonText(g_i18n:getText("liftCultivator"), InputBinding.LOWER_IMPLEMENT);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("lowerCultivator"), InputBinding.LOWER_IMPLEMENT);
        end;
      if self.showFieldNotOwnedWarning then
          g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
      end;        

    end;
end;

---
---
---

plowEvent = {};
plowEvent_mt = Class(plowEvent, Event);

InitEventClass(plowEvent, "plowEvent");

function plowEvent:emptyNew()
    local self = Event:new(plowEvent_mt);
    self.className="plowEvent";
    return self;
end;

function plowEvent:new(vehicle, parm1, parm2)
    local self = plowEvent:emptyNew()
    self.vehicle = vehicle;
    self.parm1 = parm1;
    self.parm2 = parm2;
    return self;
end;

function plowEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
    self.parm1  = streamReadBool(streamId);
    self.parm2  = streamReadBool(streamId);
    self:run(connection);
end;

function plowEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.parm1);
    streamWriteBool(streamId, self.parm2);
end;

function plowEvent:run(connection)
    self.vehicle:setParms(self.parm1, self.parm2, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(plowEvent:new(self.vehicle, self.parm1, self.parm2), nil, connection, self.vehicle);
    end;    
end;

function plowEvent.sendEvent(vehicle, parm1, parm2, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(plowEvent:new(vehicle, parm1, parm2), nil, nil, vehicle);
        else
            g_client:getServerConnection():sendEvent(plowEvent:new(vehicle, parm1, parm2));
        end;
    end;
end;
