
packer = {}

function packer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function packer:load(xmlFile)
    self.packeranimation = {};
    self.packeranimation.animCharSet = 0;
    self.packeranimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.packer#rootNode"));
    if rootNode ~= nil then
        self.packeranimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.packeranimation.animCharSet ~= 0 then
            self.packeranimation.clip = getAnimClipIndex(self.packeranimation.animCharSet, getXMLString(xmlFile, "vehicle.packer#animationClip"));
            if self.packeranimation.clip >= 0 then
                assignAnimTrackClip(self.packeranimation.animCharSet, 0, self.packeranimation.clip);
                setAnimTrackLoopState(self.packeranimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.packeranimation.animCharSet, 0, 1.1);
            end;
        end;
    end;
end;

function packer:delete()
end;

function packer:update()
    if self.isTurnedOn then
        enableAnimTrack(self.packeranimation.animCharSet, 0);
    else
        disableAnimTrack(self.packeranimation.animCharSet, 0);
        self.packeranimationEnabled = false;
    end;
end;

function packer:draw()
end;

function packer:onEnter()
end;

function packer:onLeave()
    if self.packeranimationEnabled then
        disableAnimTrack(self.packeranimation.animCharSet, 0);
        self.packeranimationEnabled = false;
    end;
end;

function packer:keyEvent(unicode, sym, modifier, isDown)
end;

function packer:mouseEvent(posX, posY, isDown, isUp, button)
end;
