
knot = {}

function knot.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function knot:load(xmlFile)
    self.knotanimation = {};
    self.knotanimation.animCharSet = 0;
    self.knotanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.knot#rootNode"));
    if rootNode ~= nil then
        self.knotanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.knotanimation.animCharSet ~= 0 then
            self.knotanimation.clip = getAnimClipIndex(self.knotanimation.animCharSet, getXMLString(xmlFile, "vehicle.knot#animationClip"));
            if self.knotanimation.clip >= 0 then
                assignAnimTrackClip(self.knotanimation.animCharSet, 0, self.knotanimation.clip);
                setAnimTrackLoopState(self.knotanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.knotanimation.animCharSet, 0, 1);
            end;
        end;
    end;
end;

function knot:delete()
end;

function knot:update()
    if self.isTurnedOn and self.fillLevel > (self.capacity * 0.975) and self.fillLevel < self.capacity then
        enableAnimTrack(self.knotanimation.animCharSet, 0);
    else
        disableAnimTrack(self.knotanimation.animCharSet, 0);
        self.knotanimationEnabled = false;
    end;
end;

function knot:draw()
end;

function knot:onEnter()
end;

function knot:onLeave()
end;

function knot:keyEvent(unicode, sym, modifier, isDown)
end;

function knot:mouseEvent(posX, posY, isDown, isUp, button)
end;
