
--
-- Craig, you need to use indention, to more clearly see how the code is structured.
--


circularMovement = {}

function circularMovement.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function circularMovement:load(xmlFile)
  if self.isClient then
    local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
      workSound = Utils.getFilename(workSound, self.baseDirectory);

      self.workSound = createSample("workSound");
      self.workSoundEnabled = false;
      loadSample(self.workSound, workSound, false);

      self.workSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#pitchOffset"), 1);
      self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), 1.0);
    end;
  end;
  
  self.driveshaft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.driveshaft#index"));

  self.groups = {};
  local g=0;
  while true do
    local tag = string.format("vehicle.circularMovement.group(%d)", g);
    local mType = getXMLString(xmlFile, tag.."#movementType");
    if mType == nil then
      break;
    end;
    local group = {};
    if mType=="translate" then
      group.type = "T";
    elseif mType=="rotateZ" then
      group.type = "RZ";
    elseif mType=="rotateD" then
      group.type = "RD";
    end;
    group.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#speedFactor"), 1.0);
    group.radius = Utils.getNoNil(getXMLFloat(xmlFile, tag.."#radius"), 1.0);
    group.lastAngle = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, tag.."#rotOffset"), 0.0));
    local x,y,z = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, tag.."#translateOffset"), "0 0 0"));
    group.translateOffset = {x,y,z};
    group.parts = {};
    local i=0;
    while true do
      local obj = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format(tag..".part(%d)#index", i)));  
      if obj == nil then
        break
      end;
      group.parts[i+1] = obj;
      i=i+1;
    end;
    if group.type ~= nil and table.getn(group.parts) > 0 then
      table.insert(self.groups, group);
    end;
    g=g+1;
  end;
end;

function circularMovement:delete()
  if self.workSound ~= nil then
    delete(self.workSound);
  end;
end;

function circularMovement:update(dt)
  if self.isClient then
    if self.isTurnedOn and self.movingDirection > 0 then
      if not self.workSoundEnabled and self:getIsActiveForSound() then
        playSample(self.workSound, 0, self.workSoundVolume, 0);
        setSamplePitch(self.workSound, self.workSoundPitchOffset);
        self.workSoundEnabled = true;
      end;
    elseif not self.isTurnedOn or self.movingDirection <= 0 then
      if self.workSoundEnabled then
        stopSample(self.workSound);
        self.workSoundEnabled = false;
      end;
    end;
  end;

  setVisibility(self.driveshaft, self.isTurnedOn);

  if self.movingDirection ~= 0 then 
    for _,grp in pairs(self.groups) do
      if grp.type == "RD" then
        local rotSpeed = (grp.speedFactor * self.lastSpeed) * self.movingDirection;
        grp.lastAngle = grp.lastAngle + (rotSpeed)*dt;
        for i,obj in ipairs(grp.parts) do
          local dx,dy,dz;
          dx = 0;
          dy = 0;
          dz = grp.lastAngle;
          setRotation(obj, dx,dy,dz);
        end;
      end; 
    end;
  end;

  if self.isTurnedOn and self.movingDirection > 0 then 
    for _,grp in pairs(self.groups) do
      if grp.type == "T" then
        local rotSpeed = (grp.speedFactor * self.lastSpeed);
        grp.lastAngle = grp.lastAngle + (rotSpeed)*dt;
        local x,y,z;
        local angleStep = (math.pi*2) / table.getn(grp.parts);
        for i,obj in ipairs(grp.parts) do
          x = grp.translateOffset[1] + math.cos(grp.lastAngle + angleStep * i) * grp.radius;
          y = grp.translateOffset[2] + math.sin(grp.lastAngle + angleStep * i) * grp.radius;
          z = grp.translateOffset[3];
          setTranslation(obj, x,y,z);
        end;
      elseif grp.type == "RZ" then
        local rotSpeed = (grp.speedFactor * self.lastSpeed);
        grp.lastAngle = grp.lastAngle + (rotSpeed)*dt;
        for i,obj in ipairs(grp.parts) do
          local rx,ry,rz;
          rx = 0;
          ry = 0;
          rz = grp.lastAngle;
          setRotation(obj, rx,ry,rz);
        end;
      end;
    end;
  end;
end;

function circularMovement:draw()
end;

function circularMovement:onEnter()
end;

function circularMovement:onLeave()
  if self.isClient then
    stopSample(self.workSound);
    self.workSoundEnabled = false;
  end;
end;

function circularMovement:keyEvent(unicode, sym, modifier, isDown)
end;

function circularMovement:mouseEvent(posX, posY, isDown, isUp, button)
end;
