
chain = {}

function chain.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function chain:load(xmlFile)
    self.chainanimation = {};
    self.chainanimation.animCharSet = 0;
    self.chainanimationEnabled = false;
    local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chain#rootNode"));

    if rootNode ~= nil then
        self.chainanimation.animCharSet = getAnimCharacterSet(rootNode);
        if self.chainanimation.animCharSet ~= 0 then
            self.chainanimation.clip = getAnimClipIndex(self.chainanimation.animCharSet, getXMLString(xmlFile, "vehicle.chain#animationClip"));
            if self.chainanimation.clip >= 0 then
                assignAnimTrackClip(self.chainanimation.animCharSet, 0, self.chainanimation.clip);
                setAnimTrackLoopState(self.chainanimation.animCharSet, 0, true);
                setAnimTrackSpeedScale(self.chainanimation.animCharSet, 0, .5);
            end;
        end;
    end;
end;

function chain:delete()
end;

function chain:update()
    if self.isTurnedOn then
        enableAnimTrack(self.chainanimation.animCharSet, 0);
    else
        disableAnimTrack(self.chainanimation.animCharSet, 0);
        self.chainanimationEnabled = false;
    end;
end;

function chain:draw()
end;

function chain:onEnter()
end;

function chain:onLeave()
    if self.chainanimationEnabled then
        disableAnimTrack(self.chainanimation.animCharSet, 0);
        self.chainanimationEnabled = false;
    end;
end;

function chain:keyEvent(unicode, sym, modifier, isDown)
end;

function chain:mouseEvent(posX, posY, isDown, isUp, button)
end;
